<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="utf-8" />
<title><?php echo $__env->yieldContent('title', 'MediTrack - Medical Waste Management System'); ?></title>
<meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no">
<meta name="description" content="<?php echo $__env->yieldContent('meta_description', 'MediTrack - Comprehensive medical waste management system for healthcare facilities. Track, manage, and monitor medical waste disposal efficiently.'); ?>">
<meta name="keywords" content="medical waste management, healthcare waste tracking, waste disposal, clinic management, hospital waste">
<meta name="author" content="MediTrack" />
<meta name="csrf-token" content="<?php echo e(csrf_token()); ?>" />

<!-- layout setup -->
<script type="module" src="<?php echo e(asset('assets/js/layout-setup.js')); ?>"></script>

<!-- App favicon -->
<link rel="shortcut icon" href="<?php echo e(asset('assets/images/fav-icon.png')); ?>">
<link rel="icon" type="image/png" sizes="32x32" href="<?php echo e(asset('assets/images/fav-icon.png')); ?>">
<link rel="icon" type="image/png" sizes="16x16" href="<?php echo e(asset('assets/images/fav-icon.png')); ?>">
<link rel="apple-touch-icon" href="<?php echo e(asset('assets/images/fav-icon.png')); ?>">

<!-- Inter Tight font-family link below -->
<link href="https://fonts.googleapis.com/css2?family=Inter+Tight:wght@300;400;500;600;700&display=swap" rel="stylesheet">

<?php echo $__env->yieldContent('css'); ?>
<?php echo $__env->make('partials.head-css', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

<body>

    <?php echo $__env->make('partials.header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    <?php echo $__env->make('partials.sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    <?php echo $__env->make('partials.horizontal', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <main class="app-wrapper">
        <div class="container-fluid">

            <?php echo $__env->make('partials.page-title', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

            <?php echo $__env->yieldContent('content'); ?>
            <?php echo $__env->make('partials.switcher', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
            <?php echo $__env->make('partials.scroll-to-top', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
            <?php echo $__env->make('partials.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

            <?php echo $__env->make('partials.vendor-scripts', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

            <?php echo $__env->yieldContent('js'); ?>
        </div>
    </main>
</body>

</html>
<?php /**PATH /Users/muhammadfarooq/Desktop/Ozeito Drive D/Development/Web Development/MediTrack/resources/views/partials/layouts/master.blade.php ENDPATH**/ ?>