<!-- Begin Header -->
<header class="app-header" id="app-header">
    <div class="container-fluid w-100">
        <div class="d-flex justify-content-between">
            <div class="d-flex align-items-center" style="gap: 12px;">
                
                <!-- 
                    ✅ Back Arrow Button 
                    Multiple pages ke liye conditions
                -->
                <?php
                    // Check karo konse page par hai aur back link kya hoga
                    $showBackArrow = false;
                    $backLink = '#';

                    // Get clinic_id from current route if it exists
                    $clinicId = request()->route('clinic_id');

                    // Clinics create/add/edit page
                    if(Request::routeIs('clinics.create') || Request::routeIs('add-new-Clinic') || Request::routeIs('clinic.edit')) {
                        $showBackArrow = true;
                        $backLink = route('clinics');
                    }
                    // Moduls page
                    elseif(Request::routeIs('moduls')) {
                        $showBackArrow = true;
                        $backLink = route('clinics');
                    }
                     // hospital-department page
                    elseif(Request::routeIs('hospital-department')) {
                       $showBackArrow = true;
                        $backLink = route('add-new-Clinic');
                    }
                    // Room page
                       elseif(Request::routeIs('Room')) {
                          $showBackArrow = true;
                          $backLink = route('add-new-Clinic');
                       }
                        // All Persons page
                       elseif(Request::routeIs('All-persons')) {
                          $showBackArrow = true;
                          $backLink = route('clinics');
                       }
                    // Medical Waste page
                    elseif(Request::routeIs('Medical-Waste')) {
                        $showBackArrow = true;
                        $backLink = $clinicId ? route('moduls', ['clinic_id' => $clinicId]) : route('moduls');
                    }
                    // Waste Type page
                    elseif(Request::routeIs('Waste-Type')) {
                        $showBackArrow = true;
                        $backLink = $clinicId ? route('Medical-Waste', ['clinic_id' => $clinicId]) : route('Medical-Waste');
                    }
                    // Waste Bags page
                    elseif(Request::routeIs('Waste-bags')) {
                        $showBackArrow = true;
                        $backLink = $clinicId ? route('Medical-Waste', ['clinic_id' => $clinicId]) : route('Medical-Waste');
                    }
                    // Container Type page
                    elseif(Request::routeIs('container-type')) {
                        $showBackArrow = true;
                        $backLink = $clinicId ? route('Medical-Waste', ['clinic_id' => $clinicId]) : route('Medical-Waste');
                    }
                    // Collectors page
                     elseif(Request::routeIs('collectors')) {
                        $showBackArrow = true;
                        $backLink = $clinicId ? route('Medical-Waste', ['clinic_id' => $clinicId]) : route('Medical-Waste');
                     }
                    // All Collectors page
                    elseif(Request::routeIs('All-collectors')) {
                        $showBackArrow = true;
                        $backLink = route('dashboard');
                    }
                    // Document page
                    elseif(Request::routeIs('document')) {
                        $showBackArrow = true;
                        $backLink = route('dashboard');
                    }
                    // Cleaning page
                    elseif(Request::routeIs('cleaning')) {
                        $showBackArrow = true;
                        $backLink = route('moduls');
                    }
                    // summary page
                    elseif(Request::routeIs('summary')) {
                        $showBackArrow = true;
                        $backLink = $clinicId ? route('Medical-Waste', ['clinic_id' => $clinicId]) : route('dashboard');
                    }
                    // All cleaning page
                    elseif(Request::routeIs('All-cleaning')) {
                        $showBackArrow = true;
                        $backLink = route('cleaning');
                    }
                ?>

                <?php if($showBackArrow): ?>
                <a href="<?php echo e($backLink); ?>" 
                    class="back-arrow-btn"
                    title="Back">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="back-arrow-icon">
                        <path d="M15 19l-7-7 7-7"/>
                    </svg>
                </a>
                <?php endif; ?>

                <!-- Page Title with Custom Style -->
                <h4 class="page-title-custom mb-0"><?php echo $__env->yieldContent('title-sub', 'Dashboard'); ?></h4>
            </div>

            <!-- START: User Profile Dropdown Integration -->
            <div class="dropdown">
                
                <!-- Dropdown Toggle Button -->
                <a href="#" role="button" id="userDropdownToggle" data-bs-toggle="dropdown" aria-expanded="false" 
                   class="d-flex align-items-center text-dark text-decoration-none" style="cursor: pointer;"
                   data-bs-offset="0, 20">
                    
                    <div class="border-start border-1 border-text-secondary me-2" style="height:25px; margin-top:5px;"></div>
                    <img src="<?php echo e(asset('assets/images/person.png')); ?>" alt="User Avatar" width="30" height="30" class="me-2 rounded-circle">
                    <div>
                        <p class="fw-bold mb-0"><?php echo e(Session::get('admin_name', 'User')); ?></p>
                        <p class="mb-0 text-muted small"><?php echo e(Session::get('admin_role', 'Guest')); ?></p>
                    </div>
                </a>
                
                <!-- Dropdown Menu Content -->
                <ul class="dropdown-menu dropdown-menu-end p-3 mt-3 shadow-lg border-0" aria-labelledby="userDropdownToggle" 
                    style="min-width: 250px; border-radius: 12px;">

                    <!-- User Info Header -->
                    <li class="mb-2 pb-2 border-bottom">
                        <div class="d-flex align-items-center">
                            <img src="<?php echo e(asset('assets/images/person.png')); ?>" alt="User Avatar" style="width: 40px; height: 40px; border-radius: 50%;">
                            <div class="ms-2">
                                <p class="mb-0 fw-bold"><?php echo e(Session::get('admin_name', 'User')); ?></p>
                                <p class="mb-0 text-muted small"><?php echo e(Session::get('admin_username', 'username')); ?></p>
                            </div>
                        </div>
                    </li>
                    
                    <!-- Menu Items -->
                    <li><a class="dropdown-item py-2 rounded" href="<?php echo e(route('dashboard')); ?>"><i class="bi bi-person me-2"></i>Home</a></li>
                    <li><a class="dropdown-item py-2 rounded" href="<?php echo e(route('dashboard')); ?>"><i class="bi bi-graph-up me-2"></i>Analytics</a></li>
                    <li><a class="dropdown-item py-2 rounded" href="<?php echo e(route('clinics')); ?>"><i class="bi bi-hospital me-2"></i>Clinics</a></li>
                    <?php if(Session::get('admin_role') === 'Super Admin'): ?>
                    <li><hr class="dropdown-divider my-2"></li>
                    <li><a class="dropdown-item py-2 rounded" href="<?php echo e(route('document')); ?>"><i class="bi bi-file-earmark-text me-2"></i>Document</a></li>
                    <li><a class="dropdown-item py-2 rounded" href="/payment"><i class="bi bi-credit-card me-2"></i>Payment</a></li>
                    <?php endif; ?>
                    <li><hr class="dropdown-divider my-2"></li>
                    <li><a class="dropdown-item py-2 rounded" href="#"><i class="bi bi-headset me-2"></i>Support</a></li>
                    <li><a class="dropdown-item py-2 rounded" href="/Settings"><i class="bi bi-gear me-2"></i>Setting</a></li>

                    <li><hr class="dropdown-divider my-2"></li>
                    <li>
                        <form action="<?php echo e(route('logout')); ?>" method="POST" class="d-inline">
                            <?php echo csrf_field(); ?>
                            <button type="submit" class="dropdown-item py-2 rounded text-danger border-0 bg-transparent w-100 text-start">
                                <i class="bi bi-box-arrow-right me-2"></i>Sign Out
                            </button>
                        </form>
                    </li>
                </ul>
            </div>
            <!-- END: User Profile Dropdown Integration -->
        </div>
    </div>
</header>
<!-- END Header -->

<style>
    /* Custom Style for Page Title - Sirf <?php echo $__env->yieldContent('title-sub'); ?> ke liye */
    .page-title-custom {
        color: #0D0D12;
        font-family: "Inter Tight", -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, sans-serif;
        font-size: 20px;
        font-style: normal;
        font-weight: 600;
        line-height: 135%; /* 27px */
        margin: 0;
    }
    
    /* Back Arrow Button Styling */
    .back-arrow-btn {
        display: inline-flex;
        align-items: center;
        justify-content: center;
        width: 30px;
        height: 30px;
        background-color: #f3f4f6d5;
        border-radius: 8px;
        color: #6b7280;
        text-decoration: none;
        transition: all 0.3s ease;
        cursor: pointer;
        flex-shrink: 0;
    }
    
    /* .back-arrow-btn:hover {
        background-color: #e5e7eb;
        color: #374151;
        transform: scale(1.05);
    } */
    
    .back-arrow-btn:active {
        transform: scale(0.95);
    }
    
    .back-arrow-icon {
        width: 16px;
        height: 16px;
        stroke-width: 1.5;
    }
    
    /* Header Styling */
    /* .app-header {
        background: white;
        border-bottom: 1px solid #e5e7eb;
        padding: 1rem 0;
        position: sticky;
        top: 0;
        z-index: 1000;
    } */
</style><?php /**PATH /Users/muhammadfarooq/Desktop/Ozeito Drive D/Development/Web Development/MediTrack/resources/views/partials/header.blade.php ENDPATH**/ ?>