<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\WasteSummaryController;
use App\Http\Controllers\AdminUserController;
use App\Http\Controllers\DocumentController;
use App\Http\Controllers\ClinicController;
use App\Http\Controllers\RoomController;
use App\Http\Controllers\HospitalDepartmentController;
use App\Http\Controllers\ResponsiblePersonController;
use App\Http\Controllers\WasteTypeController;
use App\Http\Controllers\ContainerTypeController;
use App\Http\Controllers\CollectorController;
use App\Http\Controllers\WasteBagController;
use App\Http\Controllers\InvoiceController;

// Welcome/Home Page
Route::get('/', function () {
    return view('welcome');
})->name('welcome');

// Sign In Page (redirect to dashboard if already logged in)
Route::get('/sign-in', [AuthController::class, 'showLogin'])->middleware('admin.guest')->name('sign-in');
Route::post('/login', [AuthController::class, 'login'])->middleware('admin.guest')->name('login.submit');

// Protected Routes (require authentication)
Route::middleware(['admin.auth'])->group(function () {
    // Dashboard Page (After Login)
    Route::get('/dashboard', function () {
        return view('dashboard');
    })->name('dashboard');

// Sidebar Menu Routes
Route::get('/index', function () {
    return view('index');
})->name('index');

Route::get('/Admin-dashboard', function () {
    return view('dashboard');
})->name('Admin-dashboard');

Route::get('/clinics', [ClinicController::class, 'index'])->name('clinics');
Route::get('/clinics/paginated', [ClinicController::class, 'getClinicsPaginated'])->name('clinics.paginated');
Route::get('/clinic/{id}/edit', [ClinicController::class, 'edit'])->name('clinic.edit');



 Route::get('/moduls/{clinic_id}/medical-waste/summary', function ($clinic_id) {
     $clinic = \App\Models\Clinic::findOrFail($clinic_id);
     $waste_bag_id = request('waste_bag_id');

     $data = [];
     if ($waste_bag_id) {
         $wasteBag = \App\Models\WasteBag::with(['wasteType', 'containerType', 'department', 'collector'])
             ->where('clinic_id', $clinic_id)
             ->findOrFail($waste_bag_id);

         // Prepare data for the view
         $data = [
             'clinic_name' => $clinic->name,
             'location' => $clinic->location ?? $clinic->clinic_location ?? 'N/A',
             'hospital_department' => $wasteBag->department->name ?? 'N/A',
             'waste_type' => $wasteBag->wasteType->name ?? 'N/A',
             'container_type' => $wasteBag->containerType->name ?? 'N/A',
             'collector_name' => $wasteBag->collector->name ?? 'N/A',
             'status' => $wasteBag->status == 1 ? 'Active' : ($wasteBag->status == 2 ? 'Closed' : 'Delivered'),
             'created_by' => $wasteBag->created_by_id ?? 'N/A',
             'closed_by' => $wasteBag->closed_by_id ?? 'N/A',
             'deliver_by' => $wasteBag->delivered_by_id ?? 'N/A',
             'created_time' => $wasteBag->created_timestamp ? \Carbon\Carbon::parse($wasteBag->created_timestamp)->format('m/d/Y h:iA') : 'N/A',
             'closed_time' => $wasteBag->closed_timestamp ? \Carbon\Carbon::parse($wasteBag->closed_timestamp)->format('m/d/Y h:iA') : 'N/A',
             'deliver_time' => $wasteBag->delivered_timestamp ? \Carbon\Carbon::parse($wasteBag->delivered_timestamp)->format('m/d/Y h:iA') : 'N/A',
         ];
     }

     return view('summary', compact('clinic', 'data'));
 })->name('summary');

    Route::get('/waste/summary', [WasteSummaryController::class, 'index'])->name('waste.summary');
    Route::get('/waste/summary/view-pdf', [WasteSummaryController::class, 'viewPdf'])->name('waste.summary.view-pdf');
    Route::get('/waste/summary/export-pdf', [WasteSummaryController::class, 'exportPdf'])->name('waste.summary.export-pdf');

    // Invoice Management Routes
    Route::get('/payment', [InvoiceController::class, 'index'])->name('payment');
    Route::post('/invoices/generate', [InvoiceController::class, 'generateMonthlyInvoices'])->name('invoices.generate');
    Route::get('/invoices/{id}/download', [InvoiceController::class, 'downloadInvoice'])->name('invoices.download');
    Route::get('/invoices/download-all', [InvoiceController::class, 'downloadAllInvoices'])->name('invoices.downloadAll');
    Route::put('/invoices/{id}/status', [InvoiceController::class, 'updateStatus'])->name('invoices.updateStatus');

    Route::get('/Settings', function () {
        $admin = (object)[
            'name' => Session::get('admin_name'),
            'username' => Session::get('admin_username'),
            'role' => Session::get('admin_role'),
        ];
        return view('Settings', compact('admin'));
    })->name('Settings');

    Route::get('/help', function () {
        return view('help');
    })->name('help');

    // Profile Update Route
    Route::post('/admin/update-profile', [AuthController::class, 'updateProfile'])->name('admin.update-profile');

    // Password Change Route
    Route::post('/admin/change-password', [AuthController::class, 'changePassword'])->name('admin.change-password');

    // Admin User Management Routes
    Route::get('/admin/users', [AdminUserController::class, 'index'])->name('admin.users.index');
    Route::post('/admin/users', [AdminUserController::class, 'store'])->name('admin.users.store');
    Route::put('/admin/users/{id}', [AdminUserController::class, 'update'])->name('admin.users.update');
    Route::delete('/admin/users/{id}', [AdminUserController::class, 'destroy'])->name('admin.users.destroy');

    // Document Management Routes (Super Admin only)
    Route::get('/documents/list', [DocumentController::class, 'index'])->name('documents.list');
    Route::post('/documents/upload', [DocumentController::class, 'store'])->name('documents.upload');
    Route::delete('/documents/{id}', [DocumentController::class, 'destroy'])->name('documents.delete');
    Route::get('/documents/view/{id}', [DocumentController::class, 'view'])->name('documents.view');
    Route::get('/documents/download/{id}', [DocumentController::class, 'download'])->name('documents.download');

    // Logout Route
    Route::post('/logout', [AuthController::class, 'logout'])->name('logout');
});

// Other Pages
Route::get('/dummy', function () {
    return view('dummy');
})->name('dummy');

Route::get('/moduls/{clinic_id?}', function ($clinic_id = null) {
    $hasAccess = [];

    if ($clinic_id) {
        // Load clinic's module access
        $clinic = \App\Models\Clinic::find($clinic_id);
        if ($clinic) {
            $modulAccess = json_decode($clinic->modul_access, true);
            if (is_array($modulAccess)) {
                // Convert module names to lowercase to match view expectations
                $hasAccess = array_map(function($module) {
                    // Convert "Medical Waste" to "medical_waste", "Cleaning" to "cleaning", etc.
                    return strtolower(str_replace(' ', '_', $module));
                }, $modulAccess);
            }
        }
    } else {
        // Fallback to session data for logged-in user
        $role = Session::get('admin_role', 'User');
        $accessLevel = Session::get('admin_access_level', []);

        // Super Admin has access to all modules
        if ($role === 'Super Admin') {
            $hasAccess = ['cleaning', 'disinfection', 'sterilization', 'inventory', 'task', 'medical_waste'];
        } else {
            // For other roles, check their access level
            $hasAccess = is_array($accessLevel) ? $accessLevel : [];
        }
    }

    return view('moduls', compact('hasAccess'));
})->name('moduls')->middleware('admin.auth');

Route::get('/moduls/{clinic_id}/medical-waste', function ($clinic_id) {
    $clinic = \App\Models\Clinic::findOrFail($clinic_id);
    return view('Medical-Waste', compact('clinic'));
})->name('Medical-Waste');

// Waste Type Management Routes (within clinic context)
Route::get('/moduls/{clinic_id}/medical-waste/waste-type', [WasteTypeController::class, 'index'])->name('waste-type.index');
Route::post('/moduls/{clinic_id}/medical-waste/waste-type/store', [WasteTypeController::class, 'store'])->name('waste-type.store');
Route::get('/moduls/{clinic_id}/medical-waste/waste-type/{id}', [WasteTypeController::class, 'show'])->name('waste-type.show');
Route::put('/moduls/{clinic_id}/medical-waste/waste-type/{id}', [WasteTypeController::class, 'update'])->name('waste-type.update');
Route::delete('/moduls/{clinic_id}/medical-waste/waste-type/{id}', [WasteTypeController::class, 'destroy'])->name('waste-type.destroy');

// Container Type Management Routes (within clinic context)
Route::get('/moduls/{clinic_id}/medical-waste/container-type', [ContainerTypeController::class, 'index'])->name('container-type.index');
Route::post('/moduls/{clinic_id}/medical-waste/container-type/store', [ContainerTypeController::class, 'store'])->name('container-type.store');
Route::get('/moduls/{clinic_id}/medical-waste/container-type/{id}', [ContainerTypeController::class, 'show'])->name('container-type.show');
Route::put('/moduls/{clinic_id}/medical-waste/container-type/{id}', [ContainerTypeController::class, 'update'])->name('container-type.update');
Route::delete('/moduls/{clinic_id}/medical-waste/container-type/{id}', [ContainerTypeController::class, 'destroy'])->name('container-type.destroy');

// Collector Management Routes (within clinic context)
Route::get('/moduls/{clinic_id}/medical-waste/collectors', [CollectorController::class, 'index'])->name('collectors.index');
Route::post('/moduls/{clinic_id}/medical-waste/collectors/store', [CollectorController::class, 'store'])->name('collectors.store');
Route::get('/moduls/{clinic_id}/medical-waste/collectors/{id}', [CollectorController::class, 'show'])->name('collectors.show');
Route::put('/moduls/{clinic_id}/medical-waste/collectors/{id}', [CollectorController::class, 'update'])->name('collectors.update');
Route::delete('/moduls/{clinic_id}/medical-waste/collectors/{id}', [CollectorController::class, 'destroy'])->name('collectors.destroy');

// Waste Bags Management Routes (within clinic context)
Route::get('/moduls/{clinic_id}/medical-waste/waste-bags', [WasteBagController::class, 'index'])->name('Waste-bags');
Route::post('/moduls/{clinic_id}/medical-waste/waste-bags/store', [WasteBagController::class, 'store'])->name('waste-bags.store');
Route::get('/moduls/{clinic_id}/medical-waste/waste-bags/{id}', [WasteBagController::class, 'show'])->name('waste-bags.show');
Route::put('/moduls/{clinic_id}/medical-waste/waste-bags/{id}', [WasteBagController::class, 'update'])->name('waste-bags.update');
Route::put('/moduls/{clinic_id}/medical-waste/waste-bags/{id}/status', [WasteBagController::class, 'updateStatus'])->name('waste-bags.updateStatus');
Route::delete('/moduls/{clinic_id}/medical-waste/waste-bags/{id}', [WasteBagController::class, 'destroy'])->name('waste-bags.destroy');

Route::get('/All-collectors', function () {
    return view('All-collectors');
})->name('All-collectors');

// Add New Clinic Page Route
Route::get('/add-new-Clinic', [ClinicController::class, 'create'])->name('add-new-Clinic');

// Clinics create page route
Route::get('/clinics/create', function () {
    return view('addnewClinic');
})->name('clinics.create');

// Clinic Store Route (Form Submit ke liye)
Route::post('/clinic/store', [ClinicController::class, 'store'])->name('clinic.store');
Route::put('/clinic/{id}', [ClinicController::class, 'update'])->name('clinic.update');
Route::put('/clinic/{id}/status', [ClinicController::class, 'updateStatus'])->name('clinic.updateStatus');
Route::delete('/clinic/{id}', [ClinicController::class, 'destroy'])->name('clinic.destroy');

// Room Management Routes
Route::get('/Room', [RoomController::class, 'index'])->name('Room');
Route::post('/room/store', [RoomController::class, 'store'])->name('room.store');
Route::put('/room/{id}', [RoomController::class, 'update'])->name('room.update');
Route::delete('/room/{id}', [RoomController::class, 'destroy'])->name('room.destroy');

// Hospital Department Management Routes
Route::get('/hospital-department', [HospitalDepartmentController::class, 'index'])->name('hospital-department');
Route::post('/hospital-department/store', [HospitalDepartmentController::class, 'store'])->name('hospital-department.store');
Route::put('/hospital-department/{id}', [HospitalDepartmentController::class, 'update'])->name('hospital-department.update');
Route::delete('/hospital-department/{id}', [HospitalDepartmentController::class, 'destroy'])->name('hospital-department.destroy');

// Responsible Person Management Routes
Route::get('/All-persons', [ResponsiblePersonController::class, 'index'])->name('All-persons');
Route::post('/responsible-person/store', [ResponsiblePersonController::class, 'store'])->name('responsible-person.store');
Route::put('/responsible-person/{id}', [ResponsiblePersonController::class, 'update'])->name('responsible-person.update');
Route::delete('/responsible-person/{id}', [ResponsiblePersonController::class, 'destroy'])->name('responsible-person.destroy');

// All Document create page route (Super Admin only)
Route::get('document', function () {
    $role = Session::get('admin_role');

    // Only Super Admin can access document section
    if ($role !== 'Super Admin') {
        abort(403, 'Access denied. Only Super Admin can access this section.');
    }

    return view('documents');
})->name('document')->middleware('admin.auth');

// Cleaning create page route
Route::get('cleaning', function () {
    return view('cleaning');
})->name('cleaning');

// All cleaning create page route
Route::get('All-cleaning', function () {
    return view('All-cleaning');
})->name('All-cleaning');

// clinic form create page route
Route::get('clinic-form', function () {
    return view('clinic-form');
})->name('clinic-form');

// pdf route 
Route::get('generate-pdf', function () {
    return view('generate-pdf');
})->name('generate-pdf');
