@extends('partials.layouts.master')

@section('title', 'Waste Bag Summary - MediTrack')
@section('meta_description', 'View detailed waste bag summary including clinic information, waste type, container details, collector information, and disposal timestamps. Export PDF reports for record keeping.')
@section('title-sub', 'Summary')

@section('content')

<style>
    body {
        background-color: #ffffff !important;
    }
    
    .summary-container {
        max-width: 1200px;
        margin: 0 auto;
        padding: 24px;
        background-color: #ffffff;
    }
    
    .breadcrumb-nav {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 24px;
        padding: 16px 0;
    }
    
    .breadcrumb-links {
        display: flex;
        align-items: center;
        font-size: 14px;
        color: #6b7280;
    }
    
    .breadcrumb-links a {
        color: #6b7280;
        text-decoration: none;
        transition: color 0.2s;
    }
    
    .breadcrumb-links a:hover {
        color: #374151;
    }
    
    .breadcrumb-separator {
        margin: 0 8px;
        color: #d1d5db;
    }
    
    .breadcrumb-current {
        color: #111827;
        font-weight: 600;
    }
    
    .btn-export {
        background: linear-gradient(180deg, rgba(255, 255, 255, 0.12) 0%, rgba(255, 255, 255, 0.00) 100%), linear-gradient(180deg, #4598F9 0%, #3A77BF 100%);
        color: white;
        border: none;
        border-radius: 8px;
        padding: 10px 24px;
        font-size: 14px;
        font-weight: 500;
        cursor: pointer;
        transition: all 0.2s;
        box-shadow: 0 1px 2px 0 rgba(13, 13, 18, 0.06);
    }
    
    .btn-export:hover {
        background-color: #2563eb;
        transform: translateY(-1px);
        box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
    }
    
    .main-title {
        font-size: 24px;
        font-weight: 700;
        color: #111827;
        margin-bottom: 24px;
        padding-bottom: 16px;
        border-bottom: 1px solid #e5e7eb;
    }
    
    .info-card {
        background-color: #f9fafb;
        border: 1px solid #e5e7eb;
        border-radius: 12px;
        padding: 32px;
        margin-bottom: 24px;
    }
    
    .info-card-title {
        font-size: 16px;
        font-weight: 600;
        color: #111827;
        margin-bottom: 24px;
    }
    
    .info-row {
        display: flex;
        margin-bottom: 20px;
    }
    
    .info-row:last-child {
        margin-bottom: 0;
    }
    
    .info-label {
        flex: 0 0 200px;
        font-size: 14px;
        color: #9ca3af;
        font-weight: 400;
    }
    
    .info-value {
        flex: 1;
        font-size: 14px;
        color: #111827;
        font-weight: 500;
    }
    
    .info-divider {
        width: 1px;
        background-color: #e5e7eb;
        margin: 0 48px;
    }
    
    .info-two-columns {
        display: flex;
        gap: 0;
    }
    
    .info-column {
        flex: 1;
    }
    
    .signature-box {
        display: inline-block;
        border: 1px solid #e5e7eb;
        border-radius: 8px;
        padding: 20px 30px;
        background-color: #ffffff;
    }
    
    .signature-img {
        width: 180px;
        height: 70px;
        object-fit: contain;
    }
    
    .qr-img {
        width: 120px;
        height: 120px;
        display: block;
    }
    
    .status-badge {
        display: inline-block;
        background-color: #10b981;
        color: white;
        font-size: 13px;
        font-weight: 500;
        padding: 4px 12px;
        border-radius: 6px;
    }

    /* PDF Modal Styles - Updated */
    .pdf-modal {
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background-color: rgba(0, 0, 0, 0.5);
        display: flex;
        align-items: center;
        justify-content: center;
        z-index: 9999;
        animation: fadeIn 0.3s ease-in-out;
    }

    @keyframes fadeIn {
        from {
            opacity: 0;
        }
        to {
            opacity: 1;
        }
    }

    .pdf-modal-content {
        background-color: white;
        border-radius: 0;
        width: 100%;
        height: 100%;
        display: flex;
        flex-direction: column;
        box-shadow: none;
        animation: slideUp 0.3s ease-in-out;
    }

    @keyframes slideUp {
        from {
            transform: translateY(50px);
            opacity: 0;
        }
        to {
            transform: translateY(0);
            opacity: 1;
        }
    }

    .pdf-modal-header {
        padding: 16px 24px;
        border-bottom: 1px solid #e5e7eb;
        display: flex;
        justify-content: space-between;
        align-items: center;
        flex-shrink: 0;
    }

    .pdf-modal-title {
        font-size: 20px;
        font-weight: 600;
        margin: 0;
        color: #111827;
    }

    .pdf-modal-close {
        font-size: 32px;
        cursor: pointer;
        color: #6b7280;
        background: none;
        border: none;
        padding: 0;
        width: 40px;
        height: 40px;
        display: flex;
        align-items: center;
        justify-content: center;
        transition: all 0.2s;
        border-radius: 6px;
    }

    .pdf-modal-close:hover {
        color: #000;
        background-color: #f3f4f6;
    }

    .pdf-modal-body {
        flex: 1;
        overflow: auto;
        padding: 0;
        background-color: #f5f5f5;
    }

    /* Scrolling Style */
    .pdf-modal-body::-webkit-scrollbar {
        width: 10px;
    }

    .pdf-modal-body::-webkit-scrollbar-track {
        background: #f1f1f1;
    }

    .pdf-modal-body::-webkit-scrollbar-thumb {
        background: #888;
        border-radius: 5px;
    }

    .pdf-modal-body::-webkit-scrollbar-thumb:hover {
        background: #555;
    }

    .pdf-modal-footer {
        padding: 16px 24px;
        border-top: 1px solid #e5e7eb;
        display: flex;
        gap: 12px;
        justify-content: flex-end;
        flex-shrink: 0;
        background-color: #f9fafb;
    }

    .btn {
        padding: 10px 20px;
        border: none;
        border-radius: 6px;
        cursor: pointer;
        font-weight: 500;
        text-decoration: none;
        display: inline-block;
        transition: all 0.2s;
        font-size: 14px;
    }

    .btn-secondary {
        background-color: #6b7280;
        color: white;
        border: 1px solid #6b7280;
    }

    .btn-secondary:hover {
        background-color: #4b5563;
        transform: translateY(-1px);
        box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
    }

    .btn-primary {
        background: linear-gradient(180deg, rgba(255, 255, 255, 0.12) 0%, rgba(255, 255, 255, 0.00) 100%), linear-gradient(180deg, #4598F9 0%, #3A77BF 100%);
        color: white;
        box-shadow: 0 1px 2px 0 rgba(13, 13, 18, 0.06);
        border: none;
    }

    .btn-primary:hover {
        transform: translateY(-1px);
        box-shadow: 0 6px 12px rgba(69, 152, 249, 0.3);
    }

    .btn-view-pdf {
        padding: 8px 16px;
        background: linear-gradient(180deg, rgba(255, 255, 255, 0.12) 0%, rgba(255, 255, 255, 0.00) 100%), linear-gradient(180deg, #4598F9 0%, #3A77BF 100%);
        color: white;
        border: none;
        border-radius: 6px;
        cursor: pointer;
        font-weight: 500;
        box-shadow: 0 1px 2px 0 rgba(13, 13, 18, 0.06);
        transition: all 0.2s;
    }

    .btn-view-pdf:hover {
        background-color: #2e7dd4;
        transform: translateY(-1px);
        box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
    }

    embed, iframe {
        border: none;
    }

    /* Responsive */
    @media (max-width: 768px) {
        .pdf-modal-content {
            width: 100%;
            height: 100%;
        }

        .pdf-modal-header {
            padding: 12px 16px;
        }

        .pdf-modal-title {
            font-size: 18px;
        }

        .pdf-modal-footer {
            padding: 12px 16px;
            flex-direction: column;
        }

        .btn {
            width: 100%;
            text-align: center;
        }

        .info-divider {
            display: none;
        }

        .info-two-columns {
            flex-direction: column;
        }
    }
</style>

<div class="summary-container">
    <!-- Breadcrumb & Export Button -->
    <div class="breadcrumb-nav">
        <div class="breadcrumb-links">
            <a href="#">Home</a>
            <span class="breadcrumb-separator">/</span>
            <a href="#">Clinics</a>
            <span class="breadcrumb-separator">/</span>
            <a href="#">Moduls</a>
            <span class="breadcrumb-separator">/</span>
            <a href="#">Medical Waste</a>
            <span class="breadcrumb-separator">/</span>
            <a href="#">Waste bag</a>
            <span class="breadcrumb-separator">/</span>
            <span class="breadcrumb-current">Summary</span>
        </div>
        <button class="btn-export" onclick="exportPDF()">
            Export PDF
        </button>
    </div>
    
    <!-- Main Title -->
    <div class="p-4 rounded-4 border border-1">
        <h1 class="main-title">Summary</h1>
        
        <!-- Summary Info Card 1 -->
        <div class="info-card p-4">
            <h2 class="info-card-title">Summary Info</h2>
            
            <div class="info-two-columns">
                <!-- Left Column -->
                <div class="info-column">
                    <div class="info-row">
                        <div class="info-label">Clinic Name</div>
                        <div class="info-value">{{ $data['clinic_name'] ?? ($clinic->name ?? 'N/A') }}</div>
                    </div>
                    <div class="info-row">
                        <div class="info-label">Location</div>
                        <div class="info-value">{{ $data['location'] ?? ($clinic->location ?? $clinic->clinic_location ?? 'N/A') }}</div>
                    </div>
                    <div class="info-row">
                        <div class="info-label">Hospital Department</div>
                        <div class="info-value">{{ $data['hospital_department'] ?? 'Urologist Room' }}</div>
                    </div>
                    <div class="info-row">
                        <div class="info-label">Waste Type</div>
                        <div class="info-value">{{ $data['waste_type'] ?? 'Drip Bag' }}</div>
                    </div>
                    <div class="info-row">
                        <div class="info-label">Created by</div>
                        <div class="info-value">{{ $data['created_by'] ?? 'Jhon Wick' }}</div>
                    </div>
                    <div class="info-row">
                        <div class="info-label">Closed by</div>
                        <div class="info-value">{{ $data['closed_by'] ?? 'Steave harvy' }}</div>
                    </div>
                    <div class="info-row">
                        <div class="info-label">Deliver by</div>
                        <div class="info-value">{{ $data['deliver_by'] ?? 'Sam Wison' }}</div>
                    </div>
                </div>
                
                <!-- Divider -->
                <div class="info-divider"></div>
                
                <!-- Right Column -->
                <div class="info-column">
                    <div class="info-row">
                        <div class="info-label">Container Type</div>
                        <div class="info-value">{{ $data['container_type'] ?? 'Plastic' }}</div>
                    </div>
                    <div class="info-row">
                        <div class="info-label">Collector Name</div>
                        <div class="info-value">{{ $data['collector_name'] ?? 'Steave Job' }}</div>
                    </div>
                    <div class="info-row">
                        <div class="info-label">Status</div>
                        <div class="info-value">
                            <span class="status-badge">{{ $data['status'] ?? 'Active' }}</span>
                        </div>
                    </div>
                    <div class="info-row" style="height: 20px;"></div>
                    <div class="info-row">
                        <div class="info-label">Created Time & Date</div>
                        <div class="info-value">{{ $data['created_time'] ?? '12/02/2025 12:00AM' }}</div>
                    </div>
                    <div class="info-row">
                        <div class="info-label">Closed Time & Date</div>
                        <div class="info-value">{{ $data['closed_time'] ?? '12/02/2025 12:30AM' }}</div>
                    </div>
                    <div class="info-row">
                        <div class="info-label">Deliver Time & Date</div>
                        <div class="info-value">{{ $data['deliver_time'] ?? '12/02/2025 12:30AM' }}</div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Summary Info Card 2 - Signature & QR -->
        <div class="info-card">
            <h2 class="info-card-title">Signature & QR Code</h2>
            
            <div class="info-two-columns">
                <!-- Signature Section -->
                <div class="info-column">
                    <div class="info-row">
                        <div class="info-label">Clinic Signature</div>
                        <div class="info-value">
                            <div class="signature-box">
                                <svg class="signature-img" viewBox="0 0 180 70" >
                                    <path d="M10 40 Q 20 20, 35 35 T 60 40 Q 75 25, 90 35 Q 100 45, 115 30 T 140 40 Q 155 30, 170 45" 
                                          stroke="#000000" 
                                          stroke-width="2" 
                                          fill="none" 
                                          stroke-linecap="round"/>
                                    <text x="10" y="60" font-family="cursive" font-size="12" fill="#666">Riverside Family Clinic</text>
                                </svg>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Divider -->
                <div class="info-divider"></div>
                
                <!-- QR Code Section -->
                <div class="info-column">
                    <div class="info-row">
                        <div class="info-label">QR Code</div>
                        <div class="info-value">
                            <div>
                                <img src="/assets/images/QR.png" 
                                     alt="QR Code" 
                                     class="qr-img"
                                     onerror="this.src='data:image/svg+xml,%3Csvg xmlns=%22http://www.w3.org/2000/svg%22 width=%22120%22 height=%22120%22%3E%3Crect fill=%22%23f0f0f0%22 width=%22120%22 height=%22120%22/%3E%3C/svg%3E'">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Summary Card 3 - PDF Download -->
        <div class="info-card">
            <h2 class="info-card-title">Export Options</h2>
            
            <div class="info-row">
                <div class="info-label">Clinic Handover Slip</div>
                <div class="info-value">
                    <button class="btn-view-pdf" onclick="viewPDF('{{ route('waste.summary.view-pdf') }}')">
                        View PDF
                    </button>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    // Export PDF - براہ راست download
    function exportPDF() {
        window.location.href = '{{ route('waste.summary.export-pdf') }}';
    }

    // View PDF - Modal میں دیکھیں (Full Width Version)
    function viewPDF(pdfUrl) {
        const modalId = 'pdf-modal-' + Date.now();
        const html = `
            <div class="pdf-modal" id="${modalId}">
                <div class="pdf-modal-content">
                    <div class="pdf-modal-header">
                        <h5 class="pdf-modal-title">Waste Summary Report</h5>
                        <button class="pdf-modal-close" onclick="closePDFModal('${modalId}')">×</button>
                    </div>
                    
                    <div class="pdf-modal-body">
                        <iframe src="${pdfUrl}" 
                                type="application/pdf" 
                                width="100%" 
                                height="100%" 
                                style="border: none; display: block;">
                        </iframe>
                    </div>
                </div>
            </div>
        `;
        
        document.body.insertAdjacentHTML('beforeend', html);
        document.body.style.overflow = 'hidden';
    }

    function closePDFModal(modalId) {
        const modal = document.getElementById(modalId);
        if (modal) {
            modal.remove();
            document.body.style.overflow = 'auto';
        }
    }

    // ESC key سے modal بند کریں
    document.addEventListener('keydown', (e) => {
        if (e.key === 'Escape') {
            const modals = document.querySelectorAll('.pdf-modal');
            if (modals.length > 0) {
                const lastModal = modals[modals.length - 1];
                lastModal.remove();
                document.body.style.overflow = 'auto';
            }
        }
    });

    // Modal کے باہر click سے بند ہو
    document.addEventListener('click', (e) => {
        if (e.target.classList.contains('pdf-modal')) {
            e.target.remove();
            document.body.style.overflow = 'auto';
        }
    });
</script>

@endsection