<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Waste Summary Report</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 40px;
            color: #333;
        }
        .header {
            text-align: center;
            margin-bottom: 40px;
            border-bottom: 2px solid #ddd;
            padding-bottom: 20px;
        }
        .title {
            font-size: 28px;
            font-weight: bold;
            margin-bottom: 10px;
        }
        .section {
            margin-bottom: 30px;
        }
        .section-title {
            font-size: 16px;
            font-weight: bold;
            background-color: #f5f5f5;
            padding: 10px;
            margin-bottom: 15px;
            border-radius: 4px;
        }
        .row {
            display: flex;
            margin-bottom: 12px;
            border-bottom: 1px solid #eee;
            padding-bottom: 8px;
        }
        .label {
            flex: 0 0 200px;
            font-weight: 600;
            color: #555;
        }
        .value {
            flex: 1;
            color: #333;
        }
        .two-column {
            display: flex;
            gap: 20px;
        }
        .column {
            flex: 1;
        }
        .footer {
            margin-top: 60px;
            text-align: center;
            font-size: 12px;
            color: #999;
            border-top: 1px solid #ddd;
            padding-top: 20px;
        }
        .badge {
            display: inline-block;
            background-color: #10b981;
            color: white;
            padding: 4px 8px;
            border-radius: 4px;
            font-size: 12px;
        }
    </style>
</head>
<body>
    <div class="header">
        <div class="title">Waste Handover Summary Report</div>
        <div>Generated on {{ date('d/m/Y H:i A') }}</div>
    </div>

    <div class="section">
        <div class="section-title">Clinic Information</div>
        <div class="two-column">
            <div class="column">
                <div class="row">
                    <div class="label">Clinic Name:</div>
                    <div class="value">{{ $data['clinic_name'] ?? 'N/A' }}</div>
                </div>
                <div class="row">
                    <div class="label">Location:</div>
                    <div class="value">{{ $data['location'] ?? 'N/A' }}</div>
                </div>
                <div class="row">
                    <div class="label">Hospital Department:</div>
                    <div class="value">{{ $data['hospital_department'] ?? 'N/A' }}</div>
                </div>
                <div class="row">
                    <div class="label">Waste Type:</div>
                    <div class="value">{{ $data['waste_type'] ?? 'N/A' }}</div>
                </div>
            </div>
            <div class="column">
                <div class="row">
                    <div class="label">Container Type:</div>
                    <div class="value">{{ $data['container_type'] ?? 'N/A' }}</div>
                </div>
                <div class="row">
                    <div class="label">Collector Name:</div>
                    <div class="value">{{ $data['collector_name'] ?? 'N/A' }}</div>
                </div>
                <div class="row">
                    <div class="label">Status:</div>
                    <div class="value"><span class="badge">{{ $data['status'] ?? 'N/A' }}</span></div>
                </div>
            </div>
        </div>
    </div>

    <div class="section">
        <div class="section-title">Handover Details</div>
        <div class="two-column">
            <div class="column">
                <div class="row">
                    <div class="label">Created By:</div>
                    <div class="value">{{ $data['created_by'] ?? 'N/A' }}</div>
                </div>
                <div class="row">
                    <div class="label">Created Time & Date:</div>
                    <div class="value">{{ $data['created_time'] ?? 'N/A' }}</div>
                </div>
                <div class="row">
                    <div class="label">Closed By:</div>
                    <div class="value">{{ $data['closed_by'] ?? 'N/A' }}</div>
                </div>
                <div class="row">
                    <div class="label">Closed Time & Date:</div>
                    <div class="value">{{ $data['closed_time'] ?? 'N/A' }}</div>
                </div>
            </div>
            <div class="column">
                <div class="row">
                    <div class="label">Delivered By:</div>
                    <div class="value">{{ $data['deliver_by'] ?? 'N/A' }}</div>
                </div>
                <div class="row">
                    <div class="label">Deliver Time & Date:</div>
                    <div class="value">{{ $data['deliver_time'] ?? 'N/A' }}</div>
                </div>
            </div>
        </div>
    </div>

    <div class="footer">
        <p>This is an automatically generated report. Please contact administration for any discrepancies.</p>
    </div>
</body>
</html>