@extends('partials.layouts.master')

@section('title', 'Analytics | FabKin Admin & Dashboards Template')
@section('title-sub', 'Payment')

@section('pagetitle')
<div class="d-flex justify-content-between align-items-center mb-3">
    <div class="flex items-center space-x-2 text-sm font-medium">
        <span class="main-home">Home</span>
        <span class="main-home">/</span>
        <span class="main-payment">Payment</span>
    </div>
    <!-- Download Button -->
    <div class="d-flex justify-content-end mb-3">
        <button class="btn px-5 fw-bold" style="border: 1px solid #00000034; color: #000;" @click="exportAllInvoices()">
            Download All Invoice
        </button>
    </div>
</div>
@endsection

@section('content')
<script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>

<div class="border border-0 p-4" x-data="paymentManager">

    <div class="container bg-white rounded-4 p-4 border border-1">
        <!-- Header Section -->
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h4 class="main-all-clinics mb-0">All Clinics</h4>
            <div class="d-flex align-items-center gap-2">
                <div class="input-group" style="width: 200px;">
                    <span class="input-group-text bg-white border-end-0">
                        <i class="bi bi-search text-muted"></i>
                    </span>
                    <input type="text" class="form-control border-start-0" placeholder="Search..." x-model="searchQuery">
                </div>
            </div>
        </div>

        <!-- Table -->
        <div class="table-responsive">
            <table class="table align-middle">
                <thead class="table-light">
                    <tr>
                        <th class="border-0 py-3" style="border-top-left-radius: 8px; border-bottom-left-radius: 8px;">
                            <span style="color: #666d80; font-weight: 500;">Name</span>
                        </th>
                        <th class="border-0 py-3">
                            <span style="color: #666d80; font-weight: 500;">Location</span>
                        </th>
                        <th class="border-0 py-3">
                            <span style="color: #666d80; font-weight: 500;">Paid Date</span>
                        </th>
                        <th class="border-0 py-3">
                            <span style="color: #666d80; font-weight: 500;">Download Invoice</span>
                        </th>
                        <th class="border-0 py-3">
                            <span style="color: #666d80; font-weight: 500;">Status</span>
                        </th>
                        <th class="border-0 py-3 text-end" style="border-top-right-radius: 8px; border-bottom-right-radius: 8px;">
                            <span style="color: #666d80; font-weight: 500;">Actions</span>
                        </th>
                    </tr>
                </thead>

                <tbody>
                    <template x-if="filteredClinics.length === 0">
                        <tr>
                            <td colspan="6" class="text-center text-muted py-4">No clinics found.</td>
                        </tr>
                    </template>

                    <template x-for="(clinic, index) in paginatedClinics" :key="index">
                        <tr>
                            <td x-text="clinic.name"></td>
                            <td x-text="clinic.location"></td>
                            <td x-text="formatDate(clinic.paid_date)"></td>
                            <td>
                                <button class="btn btn-sm download-Invoice-Btn" @click="downloadInvoice(index)">
                                    Download invoice
                                </button>
                            </td>
                            <td>
                                <span class="badge bg-white rounded-pill"
                                    style="cursor: pointer;"
                                    :class="{
                                        'text-success border border-success': clinic.status === 'Paid',
                                        'text-danger border border-danger': clinic.status === 'Overdue',
                                        'text-warning border border-warning': clinic.status === 'Pending'
                                    }"
                                    @click="openStatusModal(index)"
                                    x-text="clinic.status"></span>
                            </td>
                            <td class="text-end">
                                <div class="d-inline-flex align-items-center">
                                    <button class="btn btn-sm me-1" style="background-color: #f0fbff; border: 1px solid #dee2e6;" @click="openEditModal(index)">
                                        <i class="bi bi-pencil" style="color: #33cfff;"></i>
                                    </button>
                                    <button class="btn btn-sm" style="background-color: #fff0f3; border: 1px solid #dee2e6;" @click="deleteClinic(index)">
                                        <i class="bi bi-trash" style="color: red;"></i>
                                    </button>
                                </div>
                            </td>
                        </tr>
                    </template>
                </tbody>
            </table>
        </div>

        <!-- Pagination -->
        <div class="d-flex justify-content-between align-items-center mt-4 px-3">
            <div class="text-muted">
                Showing <span x-text="startIndex + 1"></span> to <span x-text="endIndex"></span> of <span x-text="'500'"></span> results
            </div>
            
            <div class="d-flex gap-3 align-items-center">
                <div class="text-muted">Per page</div>
                <select class="form-select form-select-sm" 
                        style="width: 70px; border-radius: 8px;" 
                        x-model="itemsPerPage" 
                        @change="currentPage = 1">
                    <option value="5">5</option>
                    <option value="10">10</option>
                    <option value="25">25</option>
                    <option value="50">50</option>
                </select>
                
                <div class="pagination-container d-flex align-items-center">
                    <button class="pagination-btn prev-btn" 
                            @click="prevPage" 
                            :disabled="currentPage === 1">
                        <i class="bi bi-chevron-left"></i>
                    </button>
                    
                    <template x-for="page in visiblePages" :key="page">
                        <button class="pagination-btn" 
                                :class="page === currentPage ? 'active' : ''"
                                @click="goToPage(page)"
                                x-text="page"></button>
                    </template>
                    
                    <button class="pagination-btn next-btn" 
                            @click="nextPage" 
                            :disabled="currentPage === totalPages">
                        <i class="bi bi-chevron-right"></i>
                    </button>
                </div>
            </div>
        </div>
    </div>

    <!-- Change Status Modal -->
    <template x-if="showStatusModal">
        <div class="modal fade show d-block" tabindex="-1" @click.self="showStatusModal=false" style="background-color: rgba(0,0,0,0.5);">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content" style="border-radius: 12px;">
                    <div class="modal-header border-0">
                        <h5 class="modal-title fw-bold">Change Status</h5>

                        <!-- close button  -->
                        <button type="button" 
                style="width: 36px; height: 36px; border-radius: 50%; border: 1px solid #D1D5DB; background-color: white; display: flex; align-items: center; justify-content: center; padding: 0; cursor: pointer;"
                    class="btn-close" 
                    data-bs-dismiss="modal" 
                    aria-label="Close"
                    style="position: absolute; right: 20px; top: 20px;">
                </button>

                    </div>
                    <div class="modal-body px-4 py-4">
                        <div class="mb-3">
                            <label class="form-label text-muted" style="font-size: 14px;">Status</label>
                            <div class="dropdown-container" style="position: relative;">
                                <button type="button" 
                                        class="form-control text-start d-flex justify-content-between align-items-center" 
                                        style="background-color: #eff6ff; border: 1px solid #e5e7eb; border-radius: 8px; padding: 10px;"
                                        @click="showStatusDropdown = !showStatusDropdown">
                                    <span x-text="tempStatus"></span>
                                    <i class="bi" :class="showStatusDropdown ? 'bi-chevron-up' : 'bi-chevron-down'"></i>
                                </button>
                                <div x-show="showStatusDropdown"
                                     @click.away="showStatusDropdown = false"
                                     class="dropdown-menu show w-100"
                                     style="position: absolute; top: 100%; left: 0; z-index: 1000; border-radius: 8px; box-shadow: 0 4px 6px rgba(0,0,0,0.1); margin-top: 5px;">
                                    <a class="dropdown-item"
                                       href="#"
                                       @click.prevent="selectStatus('Pending')"
                                       style="padding: 10px 15px; cursor: pointer;">
                                        Pending
                                    </a>
                                    <a class="dropdown-item d-flex justify-content-between align-items-center"
                                       href="#"
                                       @click.prevent="selectStatus('Paid')"
                                       style="padding: 10px 15px; cursor: pointer;">
                                        <span>Paid</span>
                                        <i class="bi bi-check" x-show="tempStatus === 'Paid'" style="color: #4598F9; font-size: 20px;"></i>
                                    </a>
                                    <a class="dropdown-item"
                                       href="#"
                                       @click.prevent="selectStatus('Overdue')"
                                       style="padding: 10px 15px; cursor: pointer;">
                                        Overdue
                                    </a>
                                </div>
                            </div>
                        </div>
                        <div class="mb-3">
                            <label class="form-label text-muted" style="font-size: 14px;">Paid Date</label>
                            <input type="text" 
                                   class="form-control" 
                                   placeholder="DD-MM-YY" 
                                   x-model="tempPaidDate"
                                   style="border: 1px solid #e5e7eb; border-radius: 8px; padding: 10px;">
                        </div>
                    </div>
                    <div class="modal-footer border-0 pt-0 px-4 pb-4">
                        <button class="btn btn-light border" style="border-radius: 8px; padding: 10px 24px;" @click="showStatusModal=false">Cancel</button>
                        <button class="btn px-3 py-2 saveBtn" style="border-radius: 8px;" @click="saveStatus()">Save</button>
                    </div>
                </div>
            </div>
        </div>
    </template>

    <!-- Filter Modal -->
    <template x-if="showFilterModal">
        <div class="modal fade show d-block" tabindex="-1" @click.self="showFilterModal=false" style="background-color: rgba(0,0,0,0.5);">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content" style="border-radius: 12px;">
                    <div class="modal-header border-0 pb-0">
                        <h5 class="modal-title fw-bold">Filter Clinics</h5>

<button type="button" 
                style="width: 36px; height: 36px; border-radius: 50%; border: 1px solid #D1D5DB; background-color: white; display: flex; align-items: center; justify-content: center; padding: 0; cursor: pointer;"
                    class="btn-close" 
                    data-bs-dismiss="modal" 
                    aria-label="Close"
                    style="position: absolute; right: 20px; top: 20px;">
                </button>


                    </div>
                    <div class="modal-body px-4 py-4">
                        <div class="mb-3">
                            <label class="form-label text-muted" style="font-size: 14px;">Status</label>
                            <select class="form-select" x-model="filterStatus">
                                <option value="">All</option>
                                <option value="Pending">Pending</option>
                                <option value="Paid">Paid</option>
                                <option value="Overdue">Overdue</option>
                            </select>
                        </div>
                        <div class="d-flex justify-content-end gap-2 mt-3">
                            <button class="btn btn-light border" @click="resetFilter()">Reset</button>
                            <button class="btn text-white" style="background-color:#4598F9;" @click="applyFilter()">Apply</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </template>

    <!-- Edit Modal -->
    <template x-if="showModal">
        <div class="modal fade show d-block" tabindex="-1" @click.self="resetModal()" style="background-color: rgba(0,0,0,0.5);">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content" style="border-radius: 12px;">
                    <div class="modal-header border-0 pb-0">
                        <h5 class="modal-title fw-bold">Edit Clinic Payment</h5>

                        <!-- close button code -->
                       <button type="button" 
                style="width: 36px; height: 36px; border-radius: 50%; border: 1px solid #D1D5DB; background-color: white; display: flex; align-items: center; justify-content: center; padding: 0; cursor: pointer;"
                    class="btn-close" 
                    @click="resetModal()"
                    style="position: absolute; right: 20px; top: 20px;">
                </button>

                    </div>
                    <div class="modal-body px-4 py-4">
                        <form @submit.prevent="saveClinic()">
                            <div class="mb-3">
                                <label class="form-label text-muted">Clinic Name</label>
                                <input type="text" class="form-control" x-model="editClinic.name" required>
                            </div>
                            <div class="mb-3">
                                <label class="form-label text-muted">Location</label>
                                <input type="text" class="form-control" x-model="editClinic.location" required>
                            </div>
                            <div class="mb-3">
                                <label class="form-label text-muted">Paid Date</label>
                                <input type="date" class="form-control" x-model="editClinic.paid_date" required>
                            </div>
                            <div class="mb-3">
                                <label class="form-label text-muted">Status</label>
                                <select class="form-select" x-model="editClinic.status" required>
                                    <option value="Pending">Pending</option>
                                    <option value="Paid">Paid</option>
                                    <option value="Overdue">Overdue</option>
                                </select>
                            </div>
                        </form>
                    </div>
                    <div class="modal-footer border-0 pt-0 px-4 pb-4">
                        <button class="btn border border-1" @click="resetModal()">Cancel</button>
                        <button class="btn saveBtn px-5 py-2" @click="saveClinic()">Save</button>
                    </div>
                </div>
            </div>
        </div>
    </template>

    <!-- Success/Failed Dialog Modal -->
    <div id="statusDialog" class="modal fade" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content" style="border-radius: 16px; border: none;">
                <div class="modal-body text-center p-4">
                    <div id="dialogIcon" class="mb-3"></div>
                    <h5 id="dialogTitle" class="mb-2"></h5>
                    <p id="dialogMessage" class="text-muted mb-4"></p>
                    <button type="button" class="btn px-4" id="dialogButton" data-bs-dismiss="modal"></button>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener('alpine:init', () => {
    Alpine.data('paymentManager', () => ({
        showModal: false,
        showFilterModal: false,
        showStatusModal: false,
        showStatusDropdown: false,
        editIndex: null,
        statusEditIndex: null,
        editClinic: { name: '', location: '', paid_date: '', status: 'Pending' },
        tempStatus: 'Pending',
        tempPaidDate: '',
        currentPage: 1,
        itemsPerPage: 5,
        searchQuery: '',
        filterStatus: '',
        sortAsc: true,
        
        clinics: @json($formattedInvoices),

        get filteredClinics() {
            let list = this.clinics;
            if (this.filterStatus) {
                list = list.filter(c => c.status === this.filterStatus);
            }
            if (this.searchQuery) {
                const q = this.searchQuery.toLowerCase();
                list = list.filter(c => c.name.toLowerCase().includes(q) || c.location.toLowerCase().includes(q));
            }
            return list;
        },
        
        get totalPages() { 
            return Math.ceil(this.filteredClinics.length / this.itemsPerPage); 
        },
        
        get startIndex() { 
            return (this.currentPage - 1) * this.itemsPerPage; 
        },
        
        get endIndex() { 
            return Math.min(this.startIndex + this.itemsPerPage, this.filteredClinics.length); 
        },
        
        get paginatedClinics() { 
            return this.filteredClinics.slice(this.startIndex, this.endIndex); 
        },
        
        get visiblePages() {
            const total = this.totalPages;
            const current = this.currentPage;
            const delta = 2;
            
            let range = [];
            let rangeWithDots = [];
            let l;

            for (let i = 1; i <= total; i++) {
                if (i == 1 || i == total || (i >= current - delta && i <= current + delta)) {
                    range.push(i);
                }
            }

            range.forEach((i) => {
                if (l) {
                    if (i - l === 2) {
                        rangeWithDots.push(l + 1);
                    } else if (i - l !== 1) {
                        rangeWithDots.push('...');
                    }
                }
                rangeWithDots.push(i);
                l = i;
            });

            return rangeWithDots;
        },

        formatDate(d) {
            if (!d) return '';
            const date = new Date(d);
            return `${String(date.getDate()).padStart(2,'0')}/${String(date.getMonth()+1).padStart(2,'0')}/${String(date.getFullYear()).slice(-2)}`;
        },
        
        prevPage() { 
            if (this.currentPage > 1) this.currentPage--; 
        },
        
        nextPage() { 
            if (this.currentPage < this.totalPages) this.currentPage++; 
        },
        
        goToPage(p) { 
            if (p !== '...' && p >= 1 && p <= this.totalPages) {
                this.currentPage = p; 
            }
        },

        applyFilter() { 
            this.currentPage = 1; 
            this.showFilterModal = false; 
        },
        
        resetFilter() { 
            this.filterStatus = ''; 
            this.searchQuery = ''; 
            this.currentPage = 1;
            this.showFilterModal = false;
        },

        sortClinics() {
            this.sortAsc = !this.sortAsc;
            this.clinics.sort((a,b) => 
                this.sortAsc 
                    ? a.name.localeCompare(b.name) 
                    : b.name.localeCompare(a.name)
            );
        },

        openStatusModal(i) {
            const clinic = this.paginatedClinics[i];
            this.statusEditIndex = this.clinics.indexOf(clinic);
            this.tempStatus = clinic.status;
            this.tempPaidDate = this.formatDate(clinic.paid_date);
            this.showStatusModal = true;
            this.showStatusDropdown = false;
        },
        
        selectStatus(status) {
            this.tempStatus = status;
            this.showStatusDropdown = false;
        },
        
        async saveStatus() {
            if (this.statusEditIndex !== null) {
                const clinic = this.clinics[this.statusEditIndex];
                const invoiceId = clinic.id;

                // Parse paid date if provided
                let paidDate = null;
                if (this.tempPaidDate) {
                    const parts = this.tempPaidDate.split(/[-\/]/);
                    if (parts.length === 3) {
                        const day = parts[0].padStart(2, '0');
                        const month = parts[1].padStart(2, '0');
                        let year = parts[2];

                        if (year.length === 2) {
                            year = '20' + year;
                        }

                        paidDate = `${year}-${month}-${day}`;
                    }
                }

                try {
                    // Send AJAX request to update status in database
                    const response = await fetch(`/invoices/${invoiceId}/status`, {
                        method: 'PUT',
                        headers: {
                            'Content-Type': 'application/json',
                            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
                        },
                        body: JSON.stringify({
                            status: this.tempStatus.toLowerCase(),
                            paid_date: paidDate
                        })
                    });

                    const data = await response.json();

                    if (response.ok) {
                        // Update local data
                        this.clinics[this.statusEditIndex].status = this.tempStatus;
                        if (paidDate) {
                            this.clinics[this.statusEditIndex].paid_date = paidDate;
                        }

                        // Show success dialog
                        this.showDialog('success', 'Success!', 'Invoice status updated successfully');
                    } else {
                        // Show error dialog
                        this.showDialog('error', 'Error!', data.message || 'Failed to update status');
                    }
                } catch (error) {
                    console.error('Error updating status:', error);
                    this.showDialog('error', 'Error!', 'Failed to update status. Please try again.');
                }

                this.showStatusModal = false;
                this.statusEditIndex = null;
                this.tempStatus = 'Pending';
                this.tempPaidDate = '';
            }
        },

        showDialog(type, title, message) {
            const dialogIcon = document.getElementById('dialogIcon');
            const dialogTitle = document.getElementById('dialogTitle');
            const dialogMessage = document.getElementById('dialogMessage');
            const dialogButton = document.getElementById('dialogButton');

            if (type === 'success') {
                dialogIcon.innerHTML = '<div class="dialog-icon-success">✓</div>';
                dialogTitle.textContent = title;
                dialogMessage.textContent = message;
                dialogButton.textContent = 'OK';
                dialogButton.className = 'btn px-4 dialog-btn-success';
            } else {
                dialogIcon.innerHTML = '<div class="dialog-icon-error">✕</div>';
                dialogTitle.textContent = title;
                dialogMessage.textContent = message;
                dialogButton.textContent = 'Try Again';
                dialogButton.className = 'btn px-4 dialog-btn-error';
            }

            const modal = new bootstrap.Modal(document.getElementById('statusDialog'));
            modal.show();
        },

        openEditModal(i) { 
            const c = this.paginatedClinics[i]; 
            this.editClinic = {...c}; 
            this.editIndex = this.clinics.indexOf(c); 
            this.showModal = true; 
        },
        
        saveClinic() { 
            if (this.editIndex !== null) {
                this.clinics[this.editIndex] = {...this.editClinic}; 
            }
            this.resetModal(); 
            alert('Clinic updated successfully!');
        },
        
        deleteClinic(i) { 
            if (confirm('Are you sure you want to delete this clinic?')) {
                const item = this.paginatedClinics[i]; 
                const idx = this.clinics.indexOf(item); 
                if (idx > -1) {
                    this.clinics.splice(idx, 1);
                    alert('Clinic deleted successfully!');
                }
            }
        },
        
        resetModal() {
            this.showModal = false;
            this.editClinic = {
                name: '',
                location: '',
                paid_date: '',
                status: 'Pending'
            };
            this.editIndex = null;
        },

        downloadInvoice(i) {
            const clinic = this.paginatedClinics[i];
            if (!clinic.id) {
                alert('Invoice ID not found');
                return;
            }
            // Download PDF from server
            window.location.href = `/invoices/${clinic.id}/download`;
        },
        
        exportAllInvoices() {
            // Download all invoices as ZIP
            window.location.href = '/invoices/download-all';
        },
    }));
});




</script>

<style>
    [x-cloak]{display:none!important}
    .modal{z-index:1050}
    
    .pagination-container {
        display: flex;
        align-items: center;
        gap: 5px;
    }
    
    .pagination-btn {
        width: 36px;
        height: 36px;
        border-radius: 8px;
        border: 1px solid #e0e0e0;
        background-color: #fff;
        display: flex;
        align-items: center;
        justify-content: center;
        font-weight: 500;
        color: #333;
        transition: all 0.2s;
    }
    
    .pagination-btn:hover:not(:disabled) {
        background-color: #f5f5f5;
    }
    
    .pagination-btn.active {
        background: linear-gradient(180deg, rgba(255, 255, 255, 0.12) 0%, rgba(255, 255, 255, 0.00) 100%), linear-gradient(180deg, #4598F9 0%, #3A77BF 100%); box-shadow: 0 1px 2px 0 rgba(13, 13, 18, 0.06); color: #ffffff !important;
        color: white;
        border-color: #4598F9;
    }
    
    .pagination-btn:disabled {
        opacity: 0.5;
        cursor: not-allowed;
    }
    
    .pagination-btn.prev-btn, 
    .pagination-btn.next-btn {
        font-size: 14px;
    }
    
    .dropdown-item:hover {
        background-color: #f0f9ff !important;
    }
    
    body{
        background-color: white !important;
    }
    
    .table thead th:first-child {
        border-top-left-radius: 8px;
    }

    .table thead th:last-child {
        border-top-right-radius: 8px;
    }
    .download-Invoice-Btn {
    background: linear-gradient(180deg, rgba(255, 255, 255, 0.12) 0%, rgba(255, 255, 255, 0.00) 100%), linear-gradient(180deg, #4598F9 0%, #3A77BF 100%); box-shadow: 0 1px 2px 0 rgba(13, 13, 18, 0.06); color: #ffffff !important;
    }
    .saveBtn {
    background: linear-gradient(180deg, rgba(255, 255, 255, 0.12) 0%, rgba(255, 255, 255, 0.00) 100%), linear-gradient(180deg, #4598F9 0%, #3A77BF 100%); box-shadow: 0 1px 2px 0 rgba(13, 13, 18, 0.06); color: #ffffff !important;
    }
    .main-home {
        color: var(--Greyscale-400, #818898);
/* Body/Medium/Medium */
font-family: "Inter Tight";
font-size: 14px;
font-style: normal;
font-weight: 500;
line-height: 150%; /* 21px */
letter-spacing: 0.28px;
    }
    .main-payment {
        color: var(--Greyscale-900, #0D0D12);
/* Body/Medium/Medium */
font-family: "Inter Tight";
font-size: 14px;
font-style: normal;
font-weight: 500;
line-height: 150%; /* 21px */
letter-spacing: 0.28px;
    }
    .main-all-clinics {
        color: var(--Greyscale-900, #0D0D12);
/* Body/Large/Semibold */
font-family: "Inter Tight";
font-size: 16px;
font-style: normal;
font-weight: 600;
line-height: 150%; /* 24px */
letter-spacing: 0.32px;
    }

    /* Dialog Styles */
    .dialog-icon-success {
        width: 80px;
        height: 80px;
        border-radius: 50%;
        background-color: #d4edda;
        color: #28a745;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 48px;
        font-weight: bold;
        margin: 0 auto;
    }

    .dialog-icon-error {
        width: 80px;
        height: 80px;
        border-radius: 50%;
        background-color: #f8d7da;
        color: #dc3545;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 48px;
        font-weight: bold;
        margin: 0 auto;
    }

    .dialog-btn-success {
        background: linear-gradient(180deg, rgba(255, 255, 255, 0.12) 0%, rgba(255, 255, 255, 0.00) 100%), linear-gradient(180deg, #28a745 0%, #218838 100%);
        box-shadow: 0 1px 2px 0 rgba(13, 13, 18, 0.06);
        color: #ffffff !important;
        border: none;
        border-radius: 8px;
        padding: 10px 24px;
    }

    .dialog-btn-success:hover {
        background: linear-gradient(180deg, #218838 0%, #1e7e34 100%);
    }

    .dialog-btn-error {
        background: linear-gradient(180deg, rgba(255, 255, 255, 0.12) 0%, rgba(255, 255, 255, 0.00) 100%), linear-gradient(180deg, #dc3545 0%, #c82333 100%);
        box-shadow: 0 1px 2px 0 rgba(13, 13, 18, 0.06);
        color: #ffffff !important;
        border: none;
        border-radius: 8px;
        padding: 10px 24px;
    }

    .dialog-btn-error:hover {
        background: linear-gradient(180deg, #c82333 0%, #bd2130 100%);
    }
</style>
@endsection