<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="utf-8" />
<title>@yield('title', 'MediTrack - Medical Waste Management System')</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no">
<meta name="description" content="@yield('meta_description', 'MediTrack - Comprehensive medical waste management system for healthcare facilities. Track, manage, and monitor medical waste disposal efficiently.')">
<meta name="keywords" content="medical waste management, healthcare waste tracking, waste disposal, clinic management, hospital waste">
<meta name="author" content="MediTrack" />

<!-- layout setup -->
<script type="module" src="assets/js/layout-setup.js"></script>

<!-- App favicon -->
<link rel="shortcut icon" href="{{ asset('assets/images/fav-icon.png') }}">
<link rel="icon" type="image/png" sizes="32x32" href="{{ asset('assets/images/fav-icon.png') }}">
<link rel="icon" type="image/png" sizes="16x16" href="{{ asset('assets/images/fav-icon.png') }}">
<link rel="apple-touch-icon" href="{{ asset('assets/images/fav-icon.png') }}">

@yield('css')
@include('partials.head-css') 

<body>

@yield('content')

@include('partials.vendor-scripts')  

@yield('js')

</body>

</html>