<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="utf-8" />
<title>@yield('title', 'MediTrack - Medical Waste Management System')</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no">
<meta name="description" content="@yield('meta_description', 'MediTrack - Comprehensive medical waste management system for healthcare facilities. Track, manage, and monitor medical waste disposal efficiently.')">
<meta name="keywords" content="medical waste management, healthcare waste tracking, waste disposal, clinic management, hospital waste">
<meta name="author" content="MediTrack" />
<meta name="csrf-token" content="{{ csrf_token() }}" />

<!-- layout setup -->
<script type="module" src="{{ asset('assets/js/layout-setup.js') }}"></script>

<!-- App favicon -->
<link rel="shortcut icon" href="{{ asset('assets/images/fav-icon.png') }}">
<link rel="icon" type="image/png" sizes="32x32" href="{{ asset('assets/images/fav-icon.png') }}">
<link rel="icon" type="image/png" sizes="16x16" href="{{ asset('assets/images/fav-icon.png') }}">
<link rel="apple-touch-icon" href="{{ asset('assets/images/fav-icon.png') }}">

<!-- Inter Tight font-family link below -->
<link href="https://fonts.googleapis.com/css2?family=Inter+Tight:wght@300;400;500;600;700&display=swap" rel="stylesheet">

@yield('css')
@include('partials.head-css')

<body>

    @include('partials.header')
    @include('partials.sidebar')
    @include('partials.horizontal')

    <main class="app-wrapper">
        <div class="container-fluid">

            @include('partials.page-title')

            @yield('content')
            @include('partials.switcher')
            @include('partials.scroll-to-top')
            @include('partials.footer')

            @include('partials.vendor-scripts')

            @yield('js')
        </div>
    </main>
</body>

</html>
