@extends('partials.layouts.master')

@section('title', 'Modules - MediTrack')
@section('meta_description', 'Access all available modules for your clinic including Cleaning, Disinfection, Sterilization, Inventory, Task Management, and Medical Waste Management.')
@section('title-sub', 'Moduls')
@section('pagetitle')
    <div class="flex items-center space-x-2 text-sm font-medium">
        <span class="main-home">Home</span>
        <span class="main-home">/</span>
        <span class="main-home">Clinics</span>
        <span class=" main-home">/</span>
        <span class="main-moduls">Moduls</span>
    </div>
@endsection
{{-- ************************ --}}

@section('css')
   <style>
    body {
        background-color: white !important;
    }
    .main-home{
        color: var(--Greyscale-400, #818898);
/* Body/Medium/Medium */
font-family: "Inter Tight";
font-size: 14px;
font-style: normal;
font-weight: 500;
line-height: 150%; /* 21px */
letter-spacing: 0.28px;
    }
    .main-moduls {
        color: var(--Greyscale-900, #0D0D12);
/* Body/Medium/Medium */
font-family: "Inter Tight";
font-size: 14px;
font-style: normal;
font-weight: 500;
line-height: 150%; /* 21px */
letter-spacing: 0.28px;
    }
      .moduls {
        color: var(--Black, #05080B);
font-family: Inter;
font-size: 16px;
font-style: normal;
font-weight: 600;
line-height: 110%; /* 17.6px */
    }
   </style>
@endsection

@section('content')




<div class=" p-4 ">


<div class="container border rounded-2 ">
    <div class="p-4 bg-white rounded-2">
    <div class="row g-3">
        <!-- Card 1 - Cleaning -->
        @if(in_array('cleaning', $hasAccess))
        <div class="col-lg-4 col-md-3 col-sm-6">
            <div class="p-3 border bg-white rounded-1">
                <div class="bg-white rounded-xl overflow-hidden">
                    <!-- Image Area -->
                    <div class="h-48 overflow-hidden rounded-1">
                        <img src="{{ asset('assets/images/clean.png') }}" alt="" class="w-100 h-100">
                    </div>

                    <div class="p-4">
                        <h5 class="moduls">Cleaning</h5>
                        <!-- Divider Line -->
                        <div class="border-bottom border-gray-200 mt-2 mb-4"></div>
                        <!-- Button -->
                         <a href="{{route('cleaning')}}">
                        <button class="w-full py-3 text-white rounded-1 border-0" style="border-radius: 8px; border: 1px solid #FFF; background: var(--grad, linear-gradient(180deg, rgba(255, 255, 255, 0.12) 0%, rgba(255, 255, 255, 0.00) 100%), linear-gradient(180deg, #4598F9 0%, #3A77BF 100%)); box-shadow: 0 1px 2px 0 rgba(13, 13, 18, 0.06);">
                         View Cleaning Moduls
                        </button>
                        </a>
                    </div>
                </div>
            </div>
        </div>
        @endif

        <!-- Card 2 - Disinfection -->
        @if(in_array('disinfection', $hasAccess))
        <div class="col-lg-4 col-md-3 col-sm-6">
            <div class="p-3 border bg-white rounded-1">
                <div class="bg-white rounded-xl overflow-hidden">
                    <div class="h-48 overflow-hidden rounded-1">
                        <img src="{{ asset('assets/images/disinfection.png') }}" alt="" class="w-100 h-100">
                    </div>
                    <div class="p-4">
                        <h5 class="moduls">Disinfection</h5>
                        <div class="border-bottom border-gray-200 mt-2 mb-4"></div>
                        <button class="w-full py-3 text-white rounded-1 border-0" style="border-radius: 8px; border: 1px solid #FFF; background: var(--grad, linear-gradient(180deg, rgba(255, 255, 255, 0.12) 0%, rgba(255, 255, 255, 0.00) 100%), linear-gradient(180deg, #4598F9 0%, #3A77BF 100%)); box-shadow: 0 1px 2px 0 rgba(13, 13, 18, 0.06);">
                         View Disinfection Moduls
                        </button>
                    </div>
                </div>
            </div>
        </div>
        @endif

        <!-- Card 3 - Sterilization -->
        @if(in_array('sterilization', $hasAccess))
        <div class="col-lg-4 col-md-3 col-sm-6">
            <div class="p-3 border bg-white rounded-1">
                <div class="bg-white rounded-xl overflow-hidden">
                    <div class="h-48 overflow-hidden rounded-1">
                        <img src="{{ asset('assets/images/sterilization.png') }}" alt="" class="w-100 h-100">
                    </div>
                    <div class="p-4">
                        <h5 class="moduls">Sterilization</h5>
                        <div class="border-bottom border-gray-200 mt-2 mb-4"></div>
                         <button class="w-full py-3 text-white rounded-1 border-0" style="border-radius: 8px; border: 1px solid #FFF; background: var(--grad, linear-gradient(180deg, rgba(255, 255, 255, 0.12) 0%, rgba(255, 255, 255, 0.00) 100%), linear-gradient(180deg, #4598F9 0%, #3A77BF 100%)); box-shadow: 0 1px 2px 0 rgba(13, 13, 18, 0.06);">
                         View Sterilization Moduls
                        </button>
                    </div>
                </div>
            </div>
        </div>
        @endif

        <!-- Card 4 - Inventory -->
        @if(in_array('inventory', $hasAccess))
        <div class="col-lg-4 col-md-3 col-sm-6">
            <div class="p-3 border bg-white rounded-1">
                <div class="bg-white rounded-xl overflow-hidden">
                    <div class="h-48 overflow-hidden rounded-1">
                        <img src="{{ asset('assets/images/Inventory.png') }}" alt="" class="w-100 h-100">
                    </div>
                    <div class="p-4">
                        <h5 class="moduls">Inventory</h5>
                        <div class="border-bottom border-gray-200 mt-2 mb-4"></div>
                         <button class="w-full py-3 text-white rounded-1 border-0" style="border-radius: 8px; border: 1px solid #FFF; background: var(--grad, linear-gradient(180deg, rgba(255, 255, 255, 0.12) 0%, rgba(255, 255, 255, 0.00) 100%), linear-gradient(180deg, #4598F9 0%, #3A77BF 100%)); box-shadow: 0 1px 2px 0 rgba(13, 13, 18, 0.06);">
                            View Inventory Moduls
                        </button>
                    </div>
                </div>
            </div>
        </div>
        @endif

        <!-- Card 5 - Task -->
        @if(in_array('task', $hasAccess))
        <div class="col-lg-4 col-md-3 col-sm-6">
            <div class="p-3 border bg-white rounded-1">
                <div class="bg-white rounded-xl overflow-hidden">
                    <div class="h-48 overflow-hidden rounded-1">
                        <img src="{{ asset('assets/images/Task.png') }}" alt="" class="w-100 h-100">
                    </div>
                    <div class="p-4">
                        <h5 class="moduls">Task</h5>
                        <div class="border-bottom border-gray-200 mt-2 mb-4"></div>
                        <button class="w-full py-3 text-white rounded-1 border-0" style="border-radius: 8px; border: 1px solid #FFF; background: var(--grad, linear-gradient(180deg, rgba(255, 255, 255, 0.12) 0%, rgba(255, 255, 255, 0.00) 100%), linear-gradient(180deg, #4598F9 0%, #3A77BF 100%)); box-shadow: 0 1px 2px 0 rgba(13, 13, 18, 0.06);">
                           View Task Moduls
                        </button>
                    </div>
                </div>
            </div>
        </div>
        @endif

        <!-- Card 6 - Medical Waste -->
        @if(in_array('medical_waste', $hasAccess))
        <div class="col-lg-4 col-md-3 col-sm-6">
            <a href="{{ route('Medical-Waste', ['clinic_id' => request()->route('clinic_id')]) }}">
            <div class="p-3 border bg-white rounded-1">
                <div class="bg-white rounded-xl overflow-hidden">
                    <div class="h-48 overflow-hidden rounded-1">
                        <img src="{{ asset('assets/images/Medical Waste.png') }}" alt="" class="w-100 h-100">
                    </div>
                    <div class="p-4">
                        <h5 class="moduls">Medical Waste</h5>
                        <div class="border-bottom border-gray-200 mt-2 mb-4"></div>
                        <button class="w-full py-3 text-white rounded-1 border-0" style="border-radius: 8px; border: 1px solid #FFF; background: var(--grad, linear-gradient(180deg, rgba(255, 255, 255, 0.12) 0%, rgba(255, 255, 255, 0.00) 100%), linear-gradient(180deg, #4598F9 0%, #3A77BF 100%)); box-shadow: 0 1px 2px 0 rgba(13, 13, 18, 0.06);">
                           View Medical Waste Moduls
                        </button>
                    </div>
                </div>
            </div>
            </a>
        </div>
        @endif

        <!-- No Access Message -->
        @if(count($hasAccess) === 0)
        <div class="col-12">
            <div class="alert alert-warning text-center" role="alert">
                <i class="bi bi-exclamation-triangle-fill me-2"></i>
                You don't have access to any modules. Please contact the administrator.
            </div>
        </div>
        @endif
    </div>
 </div>
</div>
</div>



@endsection

@section('js')

    <script src="{{ asset('assets/libs/apexcharts/apexcharts.min.js') }}"></script>

    <script src="{{ asset('assets/js/dashboard/analytics.init.js') }}"></script>

    <!-- App js -->
    <script type="module" src="{{ asset('assets/js/app.js') }}"></script>
@endsection
