<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Invoice {{ $invoice->invoice_number }}</title>
    <style>
        body {
            font-family: 'DejaVu Sans', sans-serif;
            margin: 0;
            padding: 20px;
            color: #333;
        }
        .invoice-header {
            border-bottom: 3px solid #4A90E2;
            padding-bottom: 20px;
            margin-bottom: 30px;
        }
        .invoice-title {
            font-size: 32px;
            color: #4A90E2;
            margin: 0;
            font-weight: bold;
        }
        .invoice-number {
            font-size: 14px;
            color: #666;
            margin-top: 5px;
        }
        .company-info {
            margin-bottom: 30px;
        }
        .company-name {
            font-size: 20px;
            font-weight: bold;
            color: #333;
            margin-bottom: 5px;
        }
        .company-address {
            font-size: 12px;
            color: #666;
            line-height: 1.6;
        }
        .invoice-details {
            display: table;
            width: 100%;
            margin-bottom: 30px;
        }
        .detail-row {
            display: table-row;
        }
        .detail-label {
            display: table-cell;
            font-weight: bold;
            padding: 8px 0;
            width: 150px;
            color: #555;
        }
        .detail-value {
            display: table-cell;
            padding: 8px 0;
            color: #333;
        }
        .invoice-items {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 30px;
        }
        .invoice-items thead {
            background-color: #4A90E2;
            color: white;
        }
        .invoice-items th {
            padding: 12px;
            text-align: left;
            font-weight: bold;
        }
        .invoice-items td {
            padding: 12px;
            border-bottom: 1px solid #ddd;
        }
        .invoice-items tbody tr:last-child td {
            border-bottom: 2px solid #4A90E2;
        }
        .total-section {
            text-align: right;
            margin-top: 20px;
        }
        .total-row {
            margin-bottom: 10px;
        }
        .total-label {
            display: inline-block;
            width: 150px;
            font-weight: bold;
            color: #555;
        }
        .total-value {
            display: inline-block;
            width: 150px;
            text-align: right;
            color: #333;
        }
        .grand-total {
            font-size: 20px;
            padding-top: 15px;
            border-top: 2px solid #4A90E2;
            margin-top: 10px;
        }
        .grand-total .total-label {
            color: #4A90E2;
            font-size: 18px;
        }
        .grand-total .total-value {
            color: #4A90E2;
            font-size: 18px;
        }
        .payment-status {
            padding: 10px 20px;
            border-radius: 5px;
            display: inline-block;
            margin-top: 20px;
            font-weight: bold;
        }
        .status-pending {
            background-color: #FFF3CD;
            color: #856404;
            border: 1px solid #FFEAA7;
        }
        .status-paid {
            background-color: #D4EDDA;
            color: #155724;
            border: 1px solid #C3E6CB;
        }
        .status-overdue {
            background-color: #F8D7DA;
            color: #721C24;
            border: 1px solid #F5C6CB;
        }
        .footer {
            margin-top: 50px;
            padding-top: 20px;
            border-top: 1px solid #ddd;
            text-align: center;
            color: #666;
            font-size: 12px;
        }
    </style>
</head>
<body>
    <div class="invoice-header">
        <h1 class="invoice-title">INVOICE</h1>
        <div class="invoice-number">Invoice Number: {{ $invoice->invoice_number }}</div>
    </div>

    <div class="company-info">
        <div class="company-name">MediTrack Medical Waste Management</div>
        <div class="company-address">
            Medical Waste Management Services<br>
            Email: billing@meditrack.com<br>
            Phone: +1 (555) 123-4567
        </div>
    </div>

    <div class="invoice-details">
        <div class="detail-row">
            <div class="detail-label">Bill To:</div>
            <div class="detail-value">{{ $invoice->clinic->name ?? $invoice->clinic->clinic_name }}</div>
        </div>
        <div class="detail-row">
            <div class="detail-label">Location:</div>
            <div class="detail-value">{{ $invoice->clinic->location ?? $invoice->clinic->clinic_location }}</div>
        </div>
        <div class="detail-row">
            <div class="detail-label">Invoice Date:</div>
            <div class="detail-value">{{ $invoice->invoice_date->format('F d, Y') }}</div>
        </div>
        @if($invoice->paid_date)
        <div class="detail-row">
            <div class="detail-label">Paid Date:</div>
            <div class="detail-value">{{ \Carbon\Carbon::parse($invoice->paid_date)->format('F d, Y') }}</div>
        </div>
        @endif
    </div>

    <table class="invoice-items">
        <thead>
            <tr>
                <th>Description</th>
                <th style="text-align: center;">Quantity</th>
                <th style="text-align: right;">Unit Price</th>
                <th style="text-align: right;">Total</th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td>Medical Waste Management Services - Monthly Fee</td>
                <td style="text-align: center;">1</td>
                <td style="text-align: right;">${{ number_format($invoice->amount, 2) }}</td>
                <td style="text-align: right;">${{ number_format($invoice->amount, 2) }}</td>
            </tr>
        </tbody>
    </table>

    <div class="total-section">
        <div class="total-row">
            <span class="total-label">Subtotal:</span>
            <span class="total-value">${{ number_format($invoice->amount, 2) }}</span>
        </div>
        <div class="total-row">
            <span class="total-label">Tax (0%):</span>
            <span class="total-value">$0.00</span>
        </div>
        <div class="total-row grand-total">
            <span class="total-label">TOTAL:</span>
            <span class="total-value">${{ number_format($invoice->amount, 2) }}</span>
        </div>
    </div>

    <div class="payment-status status-{{ $invoice->status }}">
        Status: {{ ucfirst($invoice->status) }}
    </div>

    <div class="footer">
        <p>Thank you for your business!</p>
        <p>For any questions regarding this invoice, please contact us at billing@meditrack.com</p>
    </div>
</body>
</html>
