@extends('partials.layouts.master')
@section('title','Hospital Department | FabKin')
@section('title-sub','Add new clinic')
@section('pagetitle','')

@section('content')

<style>
    body {
        background-color: white; 
    }
    /* Custom Styles for Exact Design Match */
    .page-container {
        background-color: #f8f9fa;
        min-height: 100vh;
        padding: 20px;
    }
    
    .breadcrumb-custom {
        font-size: 14px;
        color: #6b7280;
        margin-bottom: 24px;
    }
    
    .breadcrumb-custom a {
        color: #6b7280;
        text-decoration: none;
    }
    
    .breadcrumb-custom a:hover {
        color: #374151;
    }
    
    .header-section {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 20px;
    }
    
    .page-title {
        font-size: 24px;
        font-weight: 600;
        color: #111827;
        margin: 0;
    }
    
    .btn-add-department {
        background-color: #3b82f6;
        color: white;
        border: none;
        padding: 10px 24px;
        border-radius: 8px;
        font-size: 14px;
        font-weight: 500;
    }
    
    .btn-add-department:hover {
        background-color: #2563eb;
    }
    
    .controls-section {
        background: white;
        border-radius: 12px;
        padding: 16px 20px;
        margin-bottom: 16px;
        display: flex;
        justify-content: space-between;
        align-items: center;
        box-shadow: 0 1px 3px rgba(0,0,0,0.1);
    }
    
    .search-box {
        position: relative;
        width: 300px;
    }
    
    .search-box input {
        width: 100%;
        padding: 8px 12px 8px 36px;
        border: 1px solid #e5e7eb;
        border-radius: 8px;
        font-size: 14px;
    }
    
    .search-box i {
        position: absolute;
        left: 12px;
        top: 50%;
        transform: translateY(-50%);
        color: #9ca3af;
    }
    
    .filter-sort-buttons {
        display: flex;
        gap: 8px;
    }
    
    .btn-filter, .btn-sort {
        background: white;
        border: 1px solid #e5e7eb;
        padding: 8px 16px;
        border-radius: 8px;
        font-size: 14px;
        color: #374151;
        display: flex;
        align-items: center;
        gap: 8px;
    }
    
    .btn-filter:hover, .btn-sort:hover {
        background-color: #f9fafb;
    }
    
    .table-container {
        background: white;
        border-radius: 12px;
        box-shadow: 0 1px 3px rgba(0,0,0,0.1);
        overflow: hidden;
    }
    
    .custom-table {
        width: 100%;
        margin: 0;
    }
    
    .custom-table thead {
        background-color: #f9fafb;
    }
    
    .custom-table thead th {
        padding: 16px 24px;
        font-size: 13px;
        font-weight: 600;
        color: #6b7280;
        text-transform: uppercase;
        letter-spacing: 0.5px;
        border-bottom: 1px solid #e5e7eb;
    }
    
    .custom-table tbody td {
        padding: 20px 24px;
        font-size: 14px;
        color: #111827;
        border-bottom: 1px solid #f3f4f6;
    }
    
    .custom-table tbody tr:hover {
        background-color: #f9fafb;
    }
    
    .custom-table tbody tr:last-child td {
        border-bottom: none;
    }
    
    .action-buttons {
        display: flex;
        gap: 12px;
        justify-content: flex-end;
    }
    
    .btn-action {
        background: none;
        border: none;
        padding: 4px;
        cursor: pointer;
        transition: all 0.2s;
    }
    
    .btn-action.view {
        color: #10b981;
    }
    
    .btn-action.edit {
        color: #3b82f6;
    }
    
    .btn-action.delete {
        color: #ef4444;
    }
    
    .btn-action:hover {
        opacity: 0.7;
        transform: scale(1.1);
    }
    
    .pagination-section {
        background: white;
        padding: 16px 24px;
        margin-top: 16px;
        display: flex;
        justify-content: space-between;
        align-items: center;
    }
    
    .pagination-info {
        font-size: 14px;
        color: #6b7280;
    }
    
    .pagination-controls {
        display: flex;
        align-items: center;
        gap: 20px;
    }
    
    .per-page-selector {
        display: flex;
        align-items: center;
        gap: 8px;
        font-size: 14px;
        color: #6b7280;
    }
    
    .per-page-selector select {
        padding: 4px 8px;
        border: 1px solid #e5e7eb;
        border-radius: 6px;
        font-size: 14px;
    }
    
    .pagination-buttons {
        display: flex;
        gap: 4px;
    }
    
    .page-btn {
        min-width: 36px;
        height: 36px;
        display: flex;
        align-items: center;
        justify-content: center;
        border: 1px solid #e5e7eb;
        background: white;
        border-radius: 6px;
        font-size: 14px;
        color: #374151;
        cursor: pointer;
        transition: all 0.2s;
    }
    
    .page-btn:hover:not(.active):not(.disabled) {
        background-color: #f9fafb;
    }
    
    .page-btn.active {
      background: var(--grad, linear-gradient(180deg, rgba(255, 255, 255, 0.12) 0%, rgba(255, 255, 255, 0.00) 100%), linear-gradient(180deg, #4598F9 0%, #3A77BF 100%));
        color: white;
        border-color: #3b82f6;
    }
    
    .page-btn.disabled {
        opacity: 0.5;
        cursor: not-allowed;
    }
    
    .modal-content {
        border-radius: 12px;
        border: none;
    }
    
    .modal-header {
        border-bottom: 1px solid #f3f4f6;
        padding: 20px 24px;
    }
    
    .modal-title {
        font-size: 18px;
        font-weight: 600;
        color: #111827;
    }
    
    .modal-body {
        padding: 24px;
        min-height: 150px;
    }
    
    .modal-footer {
        border-top: 1px solid #f3f4f6;
        padding: 16px 24px;
    }
    .btn-primary{
        background: var(--grad, linear-gradient(180deg, rgba(255, 255, 255, 0.12) 0%, rgba(255, 255, 255, 0.00) 100%), linear-gradient(180deg, #4598F9 0%, #3A77BF 100%));

        color: #ffffff !important;
        border: none !important;
    }
    .btn-primary:hover{
        background-color: #2563eb !important;
    }
    .btn-secondary {
        background-color: #ffffff !important;
        color: #374151 !important;
        border: 1px solid #e5e7eb !important;
    }
    .btn-secondary:hover {
        background-color: #f9fafb !important;
        color: #374151 !important;
    }
    /* extra code */
       .btn {
        font-size: 14px;
        font-weight: 500;
        border-color: #e5e7eb !important; /* Tailwind's gray-200 */
    }

    .btn:hover {
        color: #374151 !important; /* text-gray-700 */
        /* box-shadow: 0 2px 5px rgba(0,0,0,0.08) !important; */
    }

    .rounded-xl {
        border-radius: 12px !important;
    }

    .shadow-sm {
        box-shadow: 0 1px 3px rgba(0, 0, 0, 0.05) !important;
    }
    .main-clinic {
        color: var(--Greyscale-400, #818898);
/* Body/Medium/Medium */
font-family: "Inter Tight";
font-size: 14px;
font-style: normal;
font-weight: 500;
line-height: 150%; /* 21px */
letter-spacing: 0.28px;
    }
    .main-hospital {
        color: var(--Greyscale-900, #0D0D12);
/* Body/Medium/Medium */
font-family: "Inter Tight";
font-size: 14px;
font-style: normal;
font-weight: 500;
line-height: 150%; /* 21px */
letter-spacing: 0.28px;
    }
    .hospital-text {
        color: var(--Greyscale-900, #0D0D12);
/* Body/Large/Semibold */
font-family: "Inter Tight";
font-size: 16px;
font-style: normal;
font-weight: 600;
line-height: 150%; /* 24px */
letter-spacing: 0.32px;
    }
    .hospital-department {
        border-radius: 8px;
border: 1px solid #FFF;

background: var(--grad, linear-gradient(180deg, rgba(255, 255, 255, 0.12) 0%, rgba(255, 255, 255, 0.00) 100%), linear-gradient(180deg, #4598F9 0%, #3A77BF 100%));
/* Shadow/XSmall */
box-shadow: 0 1px 2px 0 rgba(13, 13, 18, 0.06);
    } 
    .hospital-department:hover {
        color: white !important;
    }
    #saveDepartmentBtn:hover {
        color: #ffffff !important;
    }
    #updateDepartmentBtn:hover {
        color: #ffffff !important
    }
    table thead th:nth-child(1) {
    border-right: none !important;
}
 table thead th:nth-child(2) {
    border-left: none !important;
}
</style>

<div class="p-0 m-2">
    <!-- Top Section: Breadcrumb + Button -->
    <div class="d-flex justify-content-between align-items-center mb-0 pb-0 ">
        
        <!-- Breadcrumb -->
        <div class="breadcrumb-custom d-flex align-items-center m-0 p-0">
            <a href="{{ route('clinics') }}" class="main-clinic">Clinics</a>
            <span class="mx-2 text-muted main-clinic">/</span>
            <a href="{{ route('add-new-Clinic') }}" class="main-clinic">Add Clinic</a>
            <span class="mx-2 text-muted main-clinic">/</span>
            <span class="main-hospital">Hospital Department</span>
        </div>

        <!-- Add Button -->
        <button type="button" 
                class="btn btn-primary px-4 py-2 hospital-department mb-0" 
                data-bs-toggle="modal" 
                data-bs-target="#addDepartmentModal">
            <!-- <i class="bi bi-plus-circle me-1"></i> -->
            Add Hospital Department
        </button>
    </div>
</div>


   

   <div class="p-4">

    <!-- Controls (Search, Filter, Sort) -->

     
     <div class="p-4 rounded-4" style="border-radius: 16px; border: 1px solid var(--Greyscale-100, #DFE1E7);
background: var(--Greyscale-0, #FFF);
box-shadow: 0 1px 2px 0 rgba(228, 229, 231, 0.24);">

     
  <div class="d-flex justify-content-between align-items-center mb-3">
    <!-- Left side -->
    <div>
        <h6 class="mb-0 hospital-text">All Hospital Department</h6>
    </div>

    <!-- Right side -->
    <div class="d-flex align-items-cente">
        <!-- Search Box -->
        <div class="search-box d-flex align-items-center me-1">
            <i class="bi bi-search "></i>
            <input type="text" id="searchInput" placeholder="Search" class="form-control form-control-sm">
        </div>

        <!-- Filter & Sort Buttons -->
<!-- <div class="d-flex align-items-center space-x-2"> -->
    <!-- Filter Button -->
    <!-- <button type="button" class="btn me-1 bg-white border text-gray-600 d-flex align-items-center shadow-sm rounded-xl hover:bg-gray-50 transition px-3 py-2">
        <i class="bi bi-funnel me-1 text-gray-500"></i>
        Filter
    </button> -->

    <!-- Sort Button -->
    <!-- <button type="button" class="btn bg-white border text-gray-600 d-flex align-items-center shadow-sm rounded-xl hover:bg-gray-50 transition px-3 py-2">
        <i class="bi bi-arrow-down-up me-1 text-gray-500"></i>
        Sort by
    </button>
</div> -->

    </div>
</div>


    <!-- Table -->
    <div class="table">
        <table class=" table overflow-hidden">
           <thead>
    <tr class="bg-light">
        <th style="color: var(--Greyscale-500, #666D80); background: var(--Greyscale-25, #F6F8FA); border-top-left-radius: 8px; border-bottom-left-radius: 8px;">
            Name
        </th>
        <th style="text-align: right; color: var(--Greyscale-500, #666D80); background: var(--Greyscale-25, #F6F8FA); border-top-right-radius: 8px; border-bottom-right-radius: 8px;">
            Actions
        </th>
    </tr>
</thead>
            <tbody id="departmentTableBody">
                @forelse($departments as $department)
                <tr data-id="{{ $department->id }}" data-name="{{ $department->name }}">
                    <td>{{ $department->name }}</td>
                    <td class="text-end py-3" style="white-space: nowrap;">
                        <button class="btn btn-sm me-1 edit-btn"
                                style="background-color: #f0fbff; border: 1px solid #dee2e6; padding: 4px 8px;"
                                data-id="{{ $department->id }}"
                                data-name="{{ $department->name }}">
                            <i class="bi bi-pencil" style="color: #33cfff; font-size: 14px;"></i>
                        </button>
                        <button class="btn btn-sm delete-btn"
                                style="background-color: #fff0f3; border: 1px solid #dee2e6; padding: 4px 8px;"
                                data-id="{{ $department->id }}"
                                data-name="{{ $department->name }}">
                            <i class="bi bi-trash" style="color: red; font-size: 14px;"></i>
                        </button>
                    </td>
                </tr>
                @empty
                <tr id="emptyRow">
                    <td colspan="2" class="text-center py-4 text-muted">
                        No departments found. Add your first department using the button above.
                    </td>
                </tr>
                @endforelse
            </tbody>
        </table>
    </div>

    <!-- Pagination -->
    <div class="pagination-section bg-white">
        <div class="pagination-info">
            Showing <span id="showingStart">1</span> to <span id="showingEnd">10</span> of <span id="totalResults">500</span> results
        </div>
        
        <div class="pagination-controls">
            <div class="per-page-selector">
                <span>Per page:</span>
                <select id="perPageSelect">
                    <option value="10" selected>10</option>
                    <option value="25">25</option>
                    <option value="50">50</option>
                    <option value="100">100</option>
                </select>
            </div>
            
            <div class="pagination-buttons">
                <button class="page-btn disabled" id="prevBtn">
                    <i class="bi bi-chevron-left"></i>
                </button>
                <button class="page-btn" data-page="1">1</button>
                <button class="page-btn" data-page="2">2</button>
                <button class="page-btn active" data-page="3">3</button>
                <button class="page-btn disabled">...</button>
                <button class="page-btn" data-page="5">5</button>
                <button class="page-btn" id="nextBtn">
                    <i class="bi bi-chevron-right"></i>
                </button>
            </div>
        </div>
    </div>
 </div>
</div>


<!-- Add Department Modal -->
<div class="modal fade" id="addDepartmentModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header border-0 pb-0">
                <h5 class="modal-title">Add Hospital Department</h5>
                    <button type="button" data-bs-dismiss="modal" style="width: 36px; height: 36px; border-radius: 50%; border: 1px solid #D1D5DB; background-color: white; display: flex; align-items: center; justify-content: center; padding: 0; cursor: pointer; position: absolute; right: 20px; top: 20px;" onmouseover="this.style.backgroundColor='#f9fafb'" onmouseout="this.style.backgroundColor='white'">
                    <i class="bi bi-x" style="font-size: 20px; color: #000; font-weight: bold;"></i>
                </button>           
             </div>
            <div class="modal-body">
                <form id="addDepartmentForm">
                    <div class="mb-3">
                        <label class="form-label">Department Name <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" id="departmentName" placeholder="Enter department name" required>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn" data-bs-dismiss="modal">Cancel</button>
                <button type="button" class="btn btn-primary" id="saveDepartmentBtn">Save</button>
            </div>
        </div>
    </div>
</div>

<!-- Edit Department Modal -->
<div class="modal fade" id="editDepartmentModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Edit Hospital Department</h5>
                <button type="button" data-bs-dismiss="modal" style="width: 36px; height: 36px; border-radius: 50%; border: 1px solid #D1D5DB; background-color: white; display: flex; align-items: center; justify-content: center; padding: 0; cursor: pointer; position: absolute; right: 20px; top: 20px;" onmouseover="this.style.backgroundColor='#f9fafb'" onmouseout="this.style.backgroundColor='white'">
                    <i class="bi bi-x" style="font-size: 20px; color: #000; font-weight: bold;"></i>
                </button>  
                <!-- <button type="button" class="btn-close" data-bs-dismiss="modal"></button> -->
            </div>
            <div class="modal-body">
                <form id="editDepartmentForm">
                    <div class="mb-3">
                        <label class="form-label">Department Name <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" id="editDepartmentName" required>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                <button type="button" class="btn btn-primary" id="updateDepartmentBtn">Update</button>
            </div>
        </div>
    </div>
</div>

<!-- View Department Modal -->
<div class="modal fade" id="viewDepartmentModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Department Details</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="mb-3">
                    <label class="form-label text-muted">Department Name</label>
                    <p class="fw-bold" id="viewDepartmentName" style="font-size: 16px; color: #111827;"></p>
                </div>
                <div class="mb-3">
                    <label class="form-label text-muted">Created Date</label>
                    <p class="fw-bold" style="font-size: 16px; color: #111827;">October 10, 2025</p>
                </div>
                <div class="mb-3">
                    <label class="form-label text-muted">Status</label>
                    <p><span class="badge bg-success">Active</span></p>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>

</div>

 <script>
        document.addEventListener('DOMContentLoaded', function() {
            let currentEditId = null;
            const csrfToken = '{{ csrf_token() }}';

            // ============ SEARCH FUNCTIONALITY ============
            const searchInput = document.getElementById('searchInput');
            if(searchInput) {
                searchInput.addEventListener('input', function(e) {
                    const searchTerm = e.target.value.toLowerCase();
                    const rows = document.querySelectorAll('#departmentTableBody tr:not(#emptyRow)');

                    rows.forEach(row => {
                        const name = row.getAttribute('data-name');
                        if(name && name.toLowerCase().includes(searchTerm)) {
                            row.style.display = '';
                        } else {
                            row.style.display = 'none';
                        }
                    });
                });
            }

            // ============ ADD DEPARTMENT ============
            document.getElementById('saveDepartmentBtn').addEventListener('click', async function() {
                const name = document.getElementById('departmentName').value.trim();

                if(!name) {
                    alert('Please enter department name');
                    return;
                }

                try {
                    const response = await fetch('{{ route("hospital-department.store") }}', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json',
                            'X-CSRF-TOKEN': csrfToken
                        },
                        body: JSON.stringify({ name: name })
                    });

                    const data = await response.json();

                    if(data.success) {
                        window.location.reload();
                    } else {
                        alert(data.message || 'Failed to add department');
                    }
                } catch(error) {
                    alert('An error occurred. Please try again.');
                    console.error(error);
                }
            });

            // ============ EDIT DEPARTMENT ============
            document.querySelectorAll('.edit-btn').forEach(btn => {
                btn.addEventListener('click', function() {
                    currentEditId = this.getAttribute('data-id');
                    const name = this.getAttribute('data-name');
                    document.getElementById('editDepartmentName').value = name;
                    new bootstrap.Modal(document.getElementById('editDepartmentModal')).show();
                });
            });

            // ============ UPDATE DEPARTMENT ============
            document.getElementById('updateDepartmentBtn').addEventListener('click', async function() {
                const newName = document.getElementById('editDepartmentName').value.trim();

                if(!newName) {
                    alert('Please enter department name');
                    return;
                }

                if(!currentEditId) {
                    alert('No department selected');
                    return;
                }

                try {
                    const response = await fetch(`/hospital-department/${currentEditId}`, {
                        method: 'PUT',
                        headers: {
                            'Content-Type': 'application/json',
                            'X-CSRF-TOKEN': csrfToken
                        },
                        body: JSON.stringify({ name: newName })
                    });

                    const data = await response.json();

                    if(data.success) {
                        window.location.reload();
                    } else {
                        alert(data.message || 'Failed to update department');
                    }
                } catch(error) {
                    alert('An error occurred. Please try again.');
                    console.error(error);
                }
            });

            // ============ DELETE DEPARTMENT ============
            document.querySelectorAll('.delete-btn').forEach(btn => {
                btn.addEventListener('click', async function() {
                    const id = this.getAttribute('data-id');
                    const name = this.getAttribute('data-name');

                    if(!confirm(`Are you sure you want to delete "${name}"?`)) {
                        return;
                    }

                    try {
                        const response = await fetch(`/hospital-department/${id}`, {
                            method: 'DELETE',
                            headers: {
                                'Content-Type': 'application/json',
                                'X-CSRF-TOKEN': csrfToken
                            }
                        });

                        const data = await response.json();

                        if(data.success) {
                            window.location.reload();
                        } else {
                            alert(data.message || 'Failed to delete department');
                        }
                    } catch(error) {
                        alert('An error occurred. Please try again.');
                        console.error(error);
                    }
                });
            });
        });
    </script>

@endsection