@extends('partials.layouts.master')
@section('title', 'Documents - MediTrack')
@section('meta_description', 'Manage all your medical waste management documents. Upload, view, download, and organize important files, reports, and compliance documents.')
@section('title-sub','Documents')
@section('pagetitle','')

@section('content')

<script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>

<style>
    body {
        background-color: white !important;
    }
    .main-home {
        color: var(--Greyscale-400, #818898);
        font-family: "Inter Tight";
        font-size: 14px;
        font-weight: 500;
        line-height: 150%;
        letter-spacing: 0.28px;
    }
    .main-document {
        color: var(--Greyscale-900, #0D0D12);
        font-family: "Inter Tight";
        font-size: 20px;
        font-weight: 600;
        line-height: 135%;
    }
    .main-document-list {
        color: var(--Greyscale-900, #0D0D12);
        font-family: "Inter Tight";
        font-size: 16px;
        font-weight: 600;
        line-height: 150%;
        letter-spacing: 0.32px;
    }
    .custom-add-btn {
        background: linear-gradient(180deg, rgba(255, 255, 255, 0.12) 0%, rgba(255, 255, 255, 0.00) 100%), linear-gradient(180deg, #4598F9 0%, #3A77BF 100%);
        box-shadow: 0 1px 2px 0 rgba(13, 13, 18, 0.06);
        color: #ffffff !important;
    }
    .saveBtn {
        background: linear-gradient(180deg, rgba(255, 255, 255, 0.12) 0%, rgba(255, 255, 255, 0.00) 100%), linear-gradient(180deg, #4598F9 0%, #3A77BF 100%);
        box-shadow: 0 1px 2px 0 rgba(13, 13, 18, 0.06);
        color: #ffffff !important;
    }
    .pagination-btn {
        width: 32px;
        height: 32px;
        border-radius: 6px;
        border: 1px solid #dee2e6;
        background-color: #fff;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 14px;
        cursor: pointer;
    }
    .pagination-btn.active {
        background: linear-gradient(180deg, rgba(255, 255, 255, 0.12) 0%, rgba(255, 255, 255, 0.00) 100%), linear-gradient(180deg, #4598F9 0%, #3A77BF 100%);
        color: white;
        border-color: #4598F9;
    }
    .pagination-btn:disabled {
        opacity: 0.4;
        cursor: not-allowed;
    }
    .progress-bar-container {
        width: 100%;
        height: 8px;
        background-color: #e5e7eb;
        border-radius: 4px;
        overflow: hidden;
        margin-top: 15px;
    }
    .progress-bar {
        height: 100%;
        background: linear-gradient(90deg, #4598F9 0%, #3A77BF 100%);
        transition: width 0.3s ease;
        border-radius: 4px;
    }
</style>

<div class="p-0 m-2" x-data="documentManager">
    <!-- Breadcrumb + Add Button -->
    <div class="d-flex justify-content-between align-items-center mb-4 pb-0">
        <div class="breadcrumb-custom d-flex align-items-center m-0 p-0">
            <a href="{{ route('dashboard') }}" class="main-home">Home</a>
            <span class="mx-2 main-home">/</span>
            <span class="main-document">Documents</span>
        </div>
        <button type="button" class="btn px-4 py-2 mb-0 custom-add-btn" @click="openAddModal()">
            Add Documents
        </button>
    </div>

    <!-- Document List -->
    <div class="p-2">
        <div class="bg-white p-4 rounded-4 border">
            <div class="d-flex justify-content-between align-items-center mb-3">
                <h6 class="mb-0 main-document-list">Documents List</h6>
                <div class="search-box d-flex align-items-center">
                    <i class="bi bi-search me-2"></i>
                    <input type="text" x-model="searchQuery" placeholder="Search" class="form-control form-control-sm">
                </div>
            </div>

            <!-- Loading State -->
            <div x-show="isLoading" class="text-center py-4">
                <div class="spinner-border text-primary" role="status">
                    <span class="visually-hidden">Loading...</span>
                </div>
            </div>

            <!-- Table -->
            <div x-show="!isLoading" class="table-responsive">
                <table class="table align-middle">
                    <thead style="background-color: #f8f9faff;">
                        <tr>
                            <th class="fw-semibold" style="color: #6c757d;">Document Name</th>
                            <th class="fw-semibold" style="color: #6c757d;">File</th>
                            <th class="text-end fw-semibold" style="color: #6c757d;">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <template x-if="filteredDocuments.length === 0">
                            <tr>
                                <td colspan="3" class="text-center text-muted py-4">No documents found.</td>
                            </tr>
                        </template>

                        <template x-for="(doc, index) in paginatedDocuments" :key="doc.id">
                            <tr>
                                <td class="fw-medium" x-text="doc.name"></td>
                                <td>
                                    <div class="d-flex gap-2">
                                        <button type="button" @click="viewDocument(doc.id)" class="btn btn-sm px-3 py-2 mb-0 custom-add-btn">
                                            <i class="bi bi-eye me-1"></i> View
                                        </button>
                                        <button type="button" @click="downloadDocument(doc.id)" class="btn btn-sm px-3 py-2 mb-0" style="background: linear-gradient(180deg, rgba(255, 255, 255, 0.12) 0%, rgba(255, 255, 255, 0.00) 100%), linear-gradient(180deg, #10b981 0%, #059669 100%); box-shadow: 0 1px 2px 0 rgba(13, 13, 18, 0.06); color: #ffffff;">
                                            <i class="bi bi-download me-1"></i> Download
                                        </button>
                                    </div>
                                </td>
                                <td class="text-end">
                                    <div class="d-inline-flex align-items-center gap-1">
                                        <button class="btn btn-sm btn-light" @click="deleteDocument(doc.id)" style="border: 1px solid #dee2e6;">
                                            <i class="bi bi-trash" style="color: #dc3545;"></i>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        </template>
                    </tbody>
                </table>
            </div>

            <!-- Pagination -->
            <div class="d-flex justify-content-between align-items-center mt-3">
                <div class="text-muted small">
                    Showing <span x-text="startIndex + 1"></span> to <span x-text="endIndex"></span> of <span x-text="filteredDocuments.length"></span>
                </div>

                <div class="d-flex gap-3 align-items-center">
                    <span class="text-muted small">Per page</span>
                    <select class="form-select form-select-sm" style="width: 70px;" x-model="itemsPerPage" @change="currentPage = 1">
                        <option value="5">5</option>
                        <option value="10">10</option>
                        <option value="15">15</option>
                    </select>

                    <div class="d-flex align-items-center gap-1">
                        <button class="pagination-btn" @click="prevPage" :disabled="currentPage === 1">
                            <i class="bi bi-chevron-left"></i>
                        </button>

                        <template x-for="page in visiblePages" :key="page">
                            <button class="pagination-btn" :class="page === currentPage ? 'active' : ''" @click="goToPage(page)" x-text="page"></button>
                        </template>

                        <button class="pagination-btn" @click="nextPage" :disabled="currentPage === totalPages">
                            <i class="bi bi-chevron-right"></i>
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Success Modal -->
    <template x-if="showSuccessModal">
        <div class="modal fade show d-block" tabindex="-1" @click.self="showSuccessModal=false" style="background-color: rgba(0,0,0,0.5); z-index: 1060;">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content" style="border-radius: 16px; border: none;">
                    <div class="modal-body text-center py-5 px-4">
                        <div class="mb-4">
                            <div style="width: 80px; height: 80px; background: linear-gradient(135deg, #10b981 0%, #059669 100%); border-radius: 50%; display: flex; align-items: center; justify-content: center; margin: 0 auto;">
                                <i class="bi bi-check-lg" style="font-size: 48px; color: white;"></i>
                            </div>
                        </div>
                        <h4 class="fw-bold mb-3" style="color: #0D0D12;">Success!</h4>
                        <p class="text-muted mb-4" x-text="successMessage"></p>
                        <button class="btn saveBtn px-5" @click="showSuccessModal = false">OK</button>
                    </div>
                </div>
            </div>
        </div>
    </template>

    <!-- Error Modal -->
    <template x-if="showErrorModal">
        <div class="modal fade show d-block" tabindex="-1" @click.self="showErrorModal=false" style="background-color: rgba(0,0,0,0.5); z-index: 1060;">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content" style="border-radius: 16px; border: none;">
                    <div class="modal-body text-center py-5 px-4">
                        <div class="mb-4">
                            <div style="width: 80px; height: 80px; background: linear-gradient(135deg, #ef4444 0%, #dc2626 100%); border-radius: 50%; display: flex; align-items: center; justify-content: center; margin: 0 auto;">
                                <i class="bi bi-x-lg" style="font-size: 48px; color: white;"></i>
                            </div>
                        </div>
                        <h4 class="fw-bold mb-3" style="color: #0D0D12;">Error!</h4>
                        <p class="text-muted mb-4" x-text="errorMessage"></p>
                        <button class="btn btn-danger px-5" @click="showErrorModal = false" style="background: linear-gradient(135deg, #ef4444 0%, #dc2626 100%);">Close</button>
                    </div>
                </div>
            </div>
        </div>
    </template>

    <!-- Add Document Modal -->
    <template x-if="showModal">
        <div class="modal fade show d-block" tabindex="-1" @click.self="resetModal()" style="background-color: rgba(0,0,0,0.5); z-index: 1060;">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content" style="border-radius: 12px;">
                    <div class="modal-header border-0 pb-0">
                        <h5 class="modal-title fw-bold">Upload Document</h5>
                        <button type="button" class="btn-close" @click="resetModal()"></button>
                    </div>
                    <div class="modal-body px-4 py-4">
                        <form @submit.prevent="uploadDocument()">
                            <div class="mb-3">
                                <label class="form-label text-muted">Document Name</label>
                                <input type="text" class="form-control" x-model="newDocument.name" placeholder="Enter document name" required>
                            </div>
                            <div class="mb-3">
                                <label class="form-label text-muted">Upload File</label>
                                <div @click="$refs.fileInput.click()" class="upload-area" style="border: 2px dashed #e5e7eb; border-radius: 8px; padding: 40px 20px; text-align: center; cursor: pointer; background-color: #f9fafb;">
                                    <i class="bi bi-file-earmark-plus" style="font-size: 48px; color: #9ca3af;"></i>
                                    <p style="color: #9ca3af; margin-top: 10px; margin-bottom: 0;">Click to upload document</p>
                                    <small style="color: #9ca3af;">PDF, DOC, DOCX, XLS, XLSX, JPG, JPEG, PNG (Max 10MB)</small>
                                    <input type="file" x-ref="fileInput" @change="handleFileChange" accept=".pdf,.doc,.docx,.xls,.xlsx,.jpg,.jpeg,.png" style="display: none;" required>
                                </div>
                                <small x-show="selectedFileName" class="text-muted mt-2 d-block">Selected: <span x-text="selectedFileName"></span></small>
                            </div>

                            <!-- Progress Bar -->
                            <div x-show="isUploading" class="progress-bar-container">
                                <div class="progress-bar" :style="`width: ${uploadProgress}%`"></div>
                            </div>
                            <small x-show="isUploading" class="text-muted mt-2 d-block text-center">
                                Uploading... <span x-text="uploadProgress"></span>%
                            </small>
                        </form>
                    </div>
                    <div class="modal-footer border-0 pt-0 px-4 pb-4">
                        <button class="btn border border-1" @click="resetModal()" :disabled="isUploading">Cancel</button>
                        <button class="btn px-5 py-2 saveBtn" @click="uploadDocument()" :disabled="isUploading">
                            <span x-show="!isUploading">Upload</span>
                            <span x-show="isUploading">
                                <span class="spinner-border spinner-border-sm me-2" role="status"></span>
                                Uploading...
                            </span>
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </template>
</div>

<script>
document.addEventListener('alpine:init', () => {
    Alpine.data('documentManager', () => ({
        documents: [],
        searchQuery: '',
        currentPage: 1,
        itemsPerPage: 10,
        isLoading: false,
        showModal: false,
        showSuccessModal: false,
        showErrorModal: false,
        successMessage: '',
        errorMessage: '',
        isUploading: false,
        uploadProgress: 0,
        newDocument: {
            name: '',
            file: null
        },
        selectedFileName: '',

        async init() {
            await this.fetchDocuments();
        },

        showSuccess(message) {
            this.successMessage = message;
            this.showSuccessModal = true;
        },

        showError(message) {
            this.errorMessage = message;
            this.showErrorModal = true;
        },

        async fetchDocuments() {
            this.isLoading = true;
            try {
                const response = await fetch('{{ route("documents.list") }}');
                if (response.ok) {
                    this.documents = await response.json();
                } else {
                    this.showError('Failed to load documents');
                }
            } catch (error) {
                this.showError('An error occurred while loading documents');
                console.error(error);
            } finally {
                this.isLoading = false;
            }
        },

        get filteredDocuments() {
            let list = this.documents;
            if (this.searchQuery) {
                const q = this.searchQuery.toLowerCase();
                list = list.filter(doc => doc.name.toLowerCase().includes(q));
            }
            return list;
        },

        get totalPages() {
            return Math.ceil(this.filteredDocuments.length / this.itemsPerPage);
        },

        get startIndex() {
            return (this.currentPage - 1) * this.itemsPerPage;
        },

        get endIndex() {
            return Math.min(this.startIndex + this.itemsPerPage, this.filteredDocuments.length);
        },

        get paginatedDocuments() {
            return this.filteredDocuments.slice(this.startIndex, this.endIndex);
        },

        get visiblePages() {
            const total = this.totalPages;
            const current = this.currentPage;
            const delta = 2;
            let range = [];
            let rangeWithDots = [];
            let l;

            for (let i = 1; i <= total; i++) {
                if (i == 1 || i == total || (i >= current - delta && i <= current + delta)) {
                    range.push(i);
                }
            }

            range.forEach((i) => {
                if (l) {
                    if (i - l === 2) {
                        rangeWithDots.push(l + 1);
                    } else if (i - l !== 1) {
                        rangeWithDots.push('...');
                    }
                }
                rangeWithDots.push(i);
                l = i;
            });

            return rangeWithDots;
        },

        prevPage() {
            if (this.currentPage > 1) this.currentPage--;
        },

        nextPage() {
            if (this.currentPage < this.totalPages) this.currentPage++;
        },

        goToPage(p) {
            if (p !== '...' && p >= 1 && p <= this.totalPages) {
                this.currentPage = p;
            }
        },

        openAddModal() {
            this.showModal = true;
        },

        handleFileChange(event) {
            const file = event.target.files[0];
            if (file) {
                this.newDocument.file = file;
                this.selectedFileName = file.name;
            }
        },

        uploadDocument() {
            if (!this.newDocument.name || !this.newDocument.file) {
                this.resetModal(); // Close modal first
                this.showError('Please provide document name and file');
                return;
            }

            this.isUploading = true;
            this.uploadProgress = 0;

            const formData = new FormData();
            formData.append('name', this.newDocument.name);
            formData.append('document', this.newDocument.file);

            const xhr = new XMLHttpRequest();

            // Track upload progress
            xhr.upload.addEventListener('progress', (e) => {
                if (e.lengthComputable) {
                    this.uploadProgress = Math.round((e.loaded / e.total) * 100);
                }
            });

            // Handle completion
            xhr.addEventListener('load', async () => {
                this.isUploading = false;

                try {
                    const data = JSON.parse(xhr.responseText);

                    if (xhr.status === 201) {
                        this.resetModal(); // Close modal first
                        this.showSuccess(data.message);
                        await this.fetchDocuments();
                    } else {
                        this.resetModal(); // Close modal first
                        // Show detailed error message from server
                        const errorMsg = data.message || data.error || 'Failed to upload document';
                        this.showError(errorMsg);
                    }
                } catch (error) {
                    this.resetModal(); // Close modal first
                    this.showError('An error occurred. Please try again.');
                    console.error(error);
                }
            });

            // Handle errors
            xhr.addEventListener('error', () => {
                this.isUploading = false;
                this.resetModal(); // Close modal first
                this.showError('Network error occurred. Please check your connection and try again.');
            });

            // Send request
            xhr.open('POST', '{{ route("documents.upload") }}');
            xhr.setRequestHeader('X-CSRF-TOKEN', '{{ csrf_token() }}');
            xhr.send(formData);
        },

        viewDocument(id) {
            // Open in new tab to view the document inline
            window.open(`{{ url('/documents/view') }}/${id}`, '_blank');
        },

        downloadDocument(id) {
            // Force download
            window.location.href = `{{ url('/documents/download') }}/${id}`;
        },

        async deleteDocument(id) {
            if (!confirm('Are you sure you want to delete this document?')) {
                return;
            }

            try {
                const response = await fetch(`{{ url('/documents') }}/${id}`, {
                    method: 'DELETE',
                    headers: {
                        'X-CSRF-TOKEN': '{{ csrf_token() }}'
                    }
                });

                const data = await response.json();

                if (response.ok) {
                    this.showSuccess(data.message);
                    await this.fetchDocuments();
                } else {
                    this.showError(data.message || 'Failed to delete document');
                }
            } catch (error) {
                this.showError('An error occurred. Please try again.');
                console.error(error);
            }
        },

        resetModal() {
            this.showModal = false;
            this.newDocument = { name: '', file: null };
            this.selectedFileName = '';
            this.uploadProgress = 0;
            this.isUploading = false;
        }
    }));
});
</script>

@endsection
