@extends('partials.layouts.master')

@section('title', 'Dashboard - MediTrack Medical Waste Management')
@section('meta_description', 'MediTrack Dashboard - Monitor and manage medical waste across all clinics. View real-time statistics, track waste disposal, and manage healthcare facilities efficiently.')
@section('title-sub', 'Dashboard')
@section('pagetitle', '')

@section('content')

     <div class="d-flex justify-content-between align-items-center mb-3">
          <div class="flex items-center space-x-2 text-sm">
           <span class="text-gray-500 main-home">Home</span>
            <span class="text-gray-400 fw-bold">/</span>
              <span class="text-gray-900 main-analytics">Analytics</span>
         </div>
     </div>

    <div id="layout-wrapper">
         <div class="row">
                 <div class="col-lg-4 col-md-4 col-sm-6">
    <div class="card overflow-hidden rounded-4">
        <div class="card-body border rounded-4">
            <div class="d-flex justify-content-between align-items-start mb-3">
                <div class="h-45px w-45px d-flex justify-content-center align-items-center bg-primary bg-opacity-10 text-primary rounded">
                    <!-- <i class="bi bi-hospital fs-5"></i> -->
                   <img src="assets/images/clinics.png" alt="Logo" height="30">
                </div>
                <div>
                    <i class="bi bi-info-circle text-muted"></i>
                </div>
            </div>
               <div class="mb-3">
                <p class="text-muted mb-2 fs-14">Clinics</p>
                <div class="d-flex justify-content-between align-items-center">
                <!-- Left side -->
                <div class="d-inline-flex">
                <h3 class="mb-0 fw-semibold">10k</h3>
                </div>
                <!-- Right side -->
                <div class="d-flex align-items-center gap-1 px-2 py-1 bg-danger bg-opacity-10 text-danger rounded fs-12">
               <i class="bi bi-arrow-down-short"></i>
              <span>10.5%</span>
              </div>
               </div>
              </div>
              </div>
              </div>
             </div>
                         <div class="col-lg-4 col-md-4 col-sm-6">
    <div class="card overflow-hidden rounded-4">
        <div class="card-body border rounded-4">
            <div class="d-flex justify-content-between align-items-start mb-3">
                <div class="h-45px w-45px d-flex justify-content-center align-items-center bg-primary bg-opacity-10 text-primary rounded">
                    <!-- <i class="bi bi-hospital fs-5"></i> -->
                   <img src="assets/images/persons.png" alt="Logo" height="30">
                </div>
                <div>
                    <i class="bi bi-info-circle text-muted"></i>
                </div>
            </div>
               <div class="mb-3">
                <p class="text-muted mb-2 fs-14">Persons</p>
                <div class="d-flex justify-content-between align-items-center">
                <!-- Left side -->
                <div class="d-inline-flex">
                <h3 class="mb-0 fw-semibold">10k</h3>
                </div>
                <!-- Right side -->
                <div class="d-flex align-items-center gap-1 px-2 py-1 bg-success bg-opacity-10 text-success rounded fs-12">
               <i class="bi bi-arrow-up-short"></i>
              <span>10.5%</span>
              </div>
               </div>
              </div>
              </div>
              </div>
             </div>

            <div class="col-lg-4 col-md-4 col-sm-6">
    <div class="card overflow-hidden rounded-4">
        <div class="card-body border rounded-4">
            <div class="d-flex justify-content-between align-items-start mb-3">
                <div class="h-45px w-45px d-flex justify-content-center align-items-center bg-primary bg-opacity-10 text-primary rounded">
                    <!-- <i class="bi bi-hospital fs-5"></i> -->
                   <img src="assets/images/collectors.png" alt="Logo" height="30">
                </div>
                <div>
                    <i class="bi bi-info-circle text-muted"></i>
                </div>
            </div>
               <div class="mb-3">
                <p class="text-muted mb-2 fs-14">Collectors</p>
                <div class="d-flex justify-content-between align-items-center">
                <!-- Left side -->
                <div class="d-inline-flex">
                <h3 class="mb-0 fw-semibold">25k</h3>
                </div>
                <!-- Right side -->
                <div class="d-flex align-items-center gap-1 px-2 py-1 bg-danger bg-opacity-10 text-danger rounded fs-12">
               <i class="bi bi-arrow-down-short"></i>
              <span>10.5%</span>
              </div>
               </div>
              </div>
              </div>
              </div>
             </div>

       <!-- Analytics Dashboard Section -->
<div class="card rounded-4 border">
    <div class="card-body">
        <!-- Header -->
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h4 class="mb-0 main-analytics">Analytics</h4>
            <select class="form-select w-auto" id="timeFilter">
                <option selected>Month</option>
                <option>Week</option>
                <option>Year</option>
            </select>
        </div>

        <hr class="my-3">

        <!-- Stats Section -->
        <div class="mb-4">
            <div class="d-flex align-items-center gap-2 mb-2">
                <h2 class="mb-0 fw-bold">105k</h2>
                <span class="badge bg-danger bg-opacity-10 text-danger d-flex align-items-center gap-1">
                    <i class="bi bi-arrow-down-short"></i>
                    4,5%
                </span>
            </div>
            <div class="d-flex justify-content-between align-items-center">
                <small class="text-muted">Last updated: Jun 16, 2025</small>
                <div class="d-flex gap-3">
                   <div class="d-flex align-items-center gap-2">
    <span class="d-inline-block" style="width: 10px; height: 10px; background-color: #1565ff; border-radius: 3px;"></span>
    <small class="text-muted">Clinics</small>
</div>

<div class="d-flex align-items-center gap-2">
    <span class="d-inline-block" style="width: 10px; height: 10px; background-color: #dfe1e7; border-radius: 3px;"></span>
    <small class="text-muted">Persons</small>
</div>
                </div>
            </div>
        </div>

        <!-- Chart Container -->
        <div class="chart-container" style="position: relative; height: 400px;">
            <canvas id="analyticsChart"></canvas>
        </div>
    </div>
</div>

<!-- Chart.js Script -->
<script src="https://cdn.jsdelivr.net/npm/chart.js@4.4.0/dist/chart.umd.min.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    const ctx = document.getElementById('analyticsChart').getContext('2d');
    
    // Data from Laravel Controller
    const chartData = {
        labels: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Okt', 'Nov', 'Dec'],
        datasets: [
            {
                label: 'Clinics',
                data: [90000, 120000, 165000, 95000, 145000, 55000, 100000, 115000, 90000, 120000, 165000, 100000],
                backgroundColor: '#3b82f6',
                borderRadius: 8,
                barThickness: 10,
            },
            {
                label: 'Persons',
                data: [130000, 180000, 220000, 190000, 210000, 160000, 150000, 190000, 130000, 180000, 220000, 170000],
                backgroundColor: '#d1d5db',
                borderRadius: 8,
                barThickness: 10,
            }
        ]
    };

    const config = {
        type: 'bar',
        data: chartData,
        options: {
            responsive: true,
            maintainAspectRatio: false,
            interaction: {
                mode: 'index',
                intersect: false,
            },
            plugins: {
                legend: {
                    display: false
                },
                tooltip: {
                    backgroundColor: '#fff',
                    titleColor: '#000',
                    bodyColor: '#666',
                    borderColor: '#e5e7eb',
                    borderWidth: 1,
                    padding: 15,
                    displayColors: false,
                    callbacks: {
                        title: function(context) {
                            return context[0].label + ' 2025';
                        },
                        label: function(context) {
                            return '';
                        },
                        afterBody: function(context) {
                            return [
                                'Clinics          10k',
                                'Persons          10k',
                                'Companies        10k'
                            ];
                        }
                    }
                },
                annotation: {
                    annotations: {
                        line1: {
                            type: 'line',
                            yMin: 145000,
                            yMax: 145000,
                            borderColor: '#666',
                            borderWidth: 1,
                            borderDash: [5, 5],
                            label: {
                                content: 'Avg',
                                enabled: true,
                                position: 'center',
                                backgroundColor: '#374151',
                                color: '#fff',
                                font: {
                                    size: 11
                                },
                                padding: 4
                            }
                        }
                    }
                }
            },
            scales: {
                x: {
                    grid: {
                        display: false
                    },
                    border: {
                        display: false
                    }
                },
                y: {
                    beginAtZero: true,
                    max: 250000,
                    ticks: {
                        stepSize: 50000,
                        callback: function(value) {
                            return (value / 1000) + 'k';
                        }
                    },
                    grid: {
                        color: '#f0f0f0',
                        drawBorder: false
                    },
                    border: {
                        display: false
                    }
                }
            }
        }
    };

    const analyticsChart = new Chart(ctx, config);
});
</script>



<style>
    body {
        background-color: white !important
    }
    .main-home {
      color: var(--Greyscale-400, #818898);
/* Body/Medium/Medium */
font-family: "Inter Tight";
font-size: 14px;
font-style: normal;
font-weight: 500;
line-height: 150%; /* 21px */
letter-spacing: 0.28px;
    }
    .main-analytics {
color: var(--Greyscale-900, #0D0D12);
font-family: "Inter Tight";
font-size: 14px;
font-style: normal;
font-weight: 500;
line-height: 150%; /* 21px */
letter-spacing: 0.28px;
    }

    .main-analytics{
 color: var(--Greyscale-900, #0D0D12);
/* Body/Large/Semibold */
font-family: "Inter Tight";
font-size: 16px;
font-style: normal;
font-weight: 600;
line-height: 150%; /* 24px */
letter-spacing: 0.32px;
    }

.chart-container {
    position: relative;
    height: 400px;
    width: 100%;
}

.form-select {
    cursor: pointer;
    padding: 0.5rem 2rem 0.5rem 1rem;
    font-size: 0.875rem;
}

.badge {
    border-radius: 0.375rem;
}
</style>

        </div>
    </div><!--End container-fluid-->
    </main><!--End app-wrapper-->
@endsection

@section('js')

    <script src="assets/libs/apexcharts/apexcharts.min.js"></script>

    <script src="assets/js/dashboard/analytics.init.js"></script>

    <!-- App js -->
    <script type="module" src="assets/js/app.js"></script>
@endsection
