@extends('partials.layouts.master')
@section('title', 'Waste Collectors - MediTrack')
@section('meta_description', 'Manage waste collectors responsible for medical waste collection and disposal. Track collector information and waste collection history.')
@section('title-sub','Collectors')
@section('pagetitle','')

@section('content')

<style>
    body {
        background-color: white !important;
    }

    .action-buttons {
    display: flex;
    gap: 8px;
    justify-content: flex-end;
}

.btn-action {
    background: none;
    border: none;
    padding: 6px;
    cursor: pointer;
    border-radius: 6px;
    transition: all 0.2s;
}

.btn-action.edit {
    background-color: #f0fbff;
    border: 1px solid #dee2e6;
}

.btn-action.delete {
    background-color: #fff0f3;
    border: 1px solid #dee2e6;
}

.btn-action:hover {
    opacity: 0.8;
    transform: scale(1.05);
}

    /* Custom Styles for Exact Design Match */
    .page-container {
        background-color: #f8f9fa;
        min-height: 100vh;
        padding: 20px;
    }

    .breadcrumb-custom {
        font-size: 14px;
        color: #6b7280;
        margin-bottom: 24px;
    }

    .breadcrumb-custom a {
        color: #6b7280;
        text-decoration: none;
    }

    .breadcrumb-custom a:hover {
        color: #374151;
    }

    .header-section {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 20px;
    }

    .page-title {
        font-size: 24px;
        font-weight: 600;
        color: #111827;
        margin: 0;
    }

    .btn-add-department {
        background-color: #3b82f6;
        color: white;
        border: none;
        padding: 10px 24px;
        border-radius: 8px;
        font-size: 14px;
        font-weight: 500;
    }

    .btn-add-department:hover {
        background-color: #2563eb;
    }

    .controls-section {
        background: white;
        border-radius: 12px;
        padding: 16px 20px;
        margin-bottom: 16px;
        display: flex;
        justify-content: space-between;
        align-items: center;
        box-shadow: 0 1px 3px rgba(0,0,0,0.1);
    }

    .search-box {
        position: relative;
        width: 300px;
    }

    .search-box input {
        width: 100%;
        padding: 8px 12px 8px 36px;
        border: 1px solid #e5e7eb;
        border-radius: 8px;
        font-size: 14px;
    }

    .search-box i {
        position: absolute;
        left: 12px;
        top: 50%;
        transform: translateY(-50%);
        color: #9ca3af;
    }

    .filter-sort-buttons {
        display: flex;
        gap: 8px;
    }

    .btn-filter, .btn-sort {
        background: white;
        border: 1px solid #e5e7eb;
        padding: 8px 16px;
        border-radius: 8px;
        font-size: 14px;
        color: #374151;
        display: flex;
        align-items: center;
        gap: 8px;
    }

    .btn-filter:hover, .btn-sort:hover {
        background-color: #f9fafb;
    }

    .table-container {
        background: white;
        border-radius: 12px;
        box-shadow: 0 1px 3px rgba(0,0,0,0.1);
        overflow: hidden;
    }

    .custom-table {
        width: 100%;
        margin: 0;
    }

    .custom-table thead {
        background-color: #f9fafb;
    }

    .custom-table thead th {
        padding: 16px 24px;
        font-size: 13px;
        font-weight: 600;
        color: #6b7280;
        text-transform: uppercase;
        letter-spacing: 0.5px;
        border-bottom: 1px solid #e5e7eb;
    }

    .custom-table tbody td {
        padding: 20px 24px;
        font-size: 14px;
        color: #111827;
        border-bottom: 1px solid #f3f4f6;
    }

    .custom-table tbody tr:hover {
        background-color: #f9fafb;
    }

    .custom-table tbody tr:last-child td {
        border-bottom: none;
    }

    .action-buttons {
        display: flex;
        gap: 4px;
        justify-content: flex-end;
    }

    .btn-action {
        background: none;
        border: none;
        padding: 4px;
        cursor: pointer;
        transition: all 0.2s;
    }

    .btn-action.view {
        color: #10b981;
    }

    .btn-action.edit {
        color: #3b82f6;
    }

    .btn-action.delete {
        color: #ef4444;
    }

    .btn-action:hover {
        opacity: 0.7;
        transform: scale(1.1);
    }

    .pagination-section {
        background: white;
        padding: 16px 24px;
        margin-top: 16px;
        display: flex;
        justify-content: space-between;
        align-items: center;
    }

    .pagination-info {
        font-size: 14px;
        color: #6b7280;
    }

    .pagination-controls {
        display: flex;
        align-items: center;
        gap: 20px;
    }

    .per-page-selector {
        display: flex;
        align-items: center;
        gap: 8px;
        font-size: 14px;
        color: #6b7280;
    }

    .per-page-selector select {
        padding: 4px 8px;
        border: 1px solid #e5e7eb;
        border-radius: 6px;
        font-size: 14px;
    }

    .pagination-buttons {
        display: flex;
        gap: 4px;
    }

    .page-btn {
        min-width: 36px;
        height: 36px;
        display: flex;
        align-items: center;
        justify-content: center;
        border: 1px solid #e5e7eb;
        background: white;
        border-radius: 6px;
        font-size: 14px;
        color: #374151;
        cursor: pointer;
        transition: all 0.2s;
    }

    .page-btn:hover:not(.active):not(.disabled) {
        background-color: #f9fafb;
    }

    .page-btn.active {
        background: linear-gradient(180deg, rgba(255, 255, 255, 0.12) 0%, rgba(255, 255, 255, 0.00) 100%), linear-gradient(180deg, #4598F9 0%, #3A77BF 100%);
        box-shadow: 0 1px 2px 0 rgba(13, 13, 18, 0.06);
        color: white;
        text-decoration: none;
        border-color: #3b82f6;
    }

    .page-btn.disabled {
        opacity: 0.5;
        cursor: not-allowed;
    }

    .modal-content {
        border-radius: 12px;
        border: none;
    }

    .modal-header {
        border-bottom: 1px solid #f3f4f6;
        padding: 20px 24px;
    }

    .modal-title {
        font-size: 18px;
        font-weight: 600;
        color: #111827;
    }

    .modal-body {
        padding: 24px;
    }

    .modal-footer {
        border-top: 1px solid #f3f4f6;
        padding: 16px 24px;
    }
    .btn-primary{
        background-color: #3b82f6 !important;
        color: #ffffff !important;
        border: none !important;
    }
    .btn-primary:hover{
        background-color: #3b82f6 !important;
    }
    /* extra code */
       .btn {
        font-size: 14px;
        font-weight: 500;
        border-color: #e5e7eb !important;
    }

    .btn:hover {
        color: #374151 !important;
    }

    .rounded-xl {
        border-radius: 12px !important;
    }

    .shadow-sm {
        box-shadow: 0 1px 3px rgba(0, 0, 0, 0.05) !important;
    }
    .main-home {
        color: var(--Greyscale-900, #818898) !important;
        font-family: "Inter Tight";
        font-size: 14px;
        font-style: normal;
        font-weight: 500;
        line-height: 150%;
        letter-spacing: 0.28px;
    }
    .main-clinics{
        color: var(--Greyscale-400, #0D0D12) !important;
        font-family: "Inter Tight";
        font-size: 14px;
        font-style: normal;
        font-weight: 500;
        line-height: 150%;
        letter-spacing: 0.28px;
    }
     .main-all-collectors {
        color: var(--Greyscale-900, #0D0D12);
        font-family: "Inter Tight";
        font-size: 16px;
        font-style: normal;
        font-weight: 600;
        line-height: 150%;
        letter-spacing: 0.32px;
    }
    #updateCollectorBtn:hover {
        color: #ffffff !important;
    }
    .CollectorModal:hover {
        color: #ffffff !important;
    }
</style>

<div class="p-0 m-2">
    <!-- Top Section: Breadcrumb + Button -->
    <div class="d-flex justify-content-between align-items-center mb-0 pb-0">

        <!-- Breadcrumb -->
          <div class="flex items-center space-x-2 text-sm font-medium">
        <span class="main-home"><a href="{{ route('dashboard') }}" class="main-home">Home</a></span>
        <span class="main-home">/</span>
        <span class="main-home"><a href="{{ route('clinics') }}" class="main-home">Clinics</a></span>
       <span class="main-home">/</span>
        <span class="main-home"><a href="{{ route('moduls', ['clinic_id' => $clinic->id]) }}" class="main-home">Moduls</a></span>
         <span class="main-home">/</span>
          <span class="main-home"><a href="{{ route('Medical-Waste', ['clinic_id' => $clinic->id]) }}" class="main-home">Medical Waste</a></span>
         <span class="main-home">/</span>
        <span class="main-clinics">Collectors</span>
    </div>

        <!-- Action Buttons -->
        <div class="d-flex gap-2">
            <a href="{{ route('Medical-Waste', ['clinic_id' => $clinic->id]) }}"
               class="btn px-4 py-2 mb-0"
               style="background: #f8f9fa; border: 1px solid #dee2e6; color: #374151; text-decoration: none;">
                <i class="bi bi-arrow-left me-1"></i>
                Back
            </a>
            <button type="button"
                    class="btn px-4 py-2 mb-0 CollectorModal"
                    style="background: linear-gradient(180deg, rgba(255, 255, 255, 0.12) 0%, rgba(255, 255, 255, 0.00) 100%), linear-gradient(180deg, #4598F9 0%, #3A77BF 100%); box-shadow: 0 1px 2px 0 rgba(13, 13, 18, 0.06); color: white; text-decoration: none;"
                    data-bs-toggle="modal"
                    data-bs-target="#addCollectorModal">
                Add Collector
            </button>
        </div>
    </div>
</div>

    <!-- Controls (Search, Filter, Sort) -->
     <div class="p-4">
     <div class="border border-1 p-4 rounded-4">


  <div class="d-flex justify-content-between align-items-center mb-3">
    <!-- Left side -->
    <div>
        <h6 class="main-all-collectors mb-0">All Collectors</h6>
    </div>

    <!-- Right side -->
    <div class="d-flex align-items-cente">
        <!-- Search Box -->
        <div class="search-box d-flex align-items-center me-1">
            <i class="bi bi-search "></i>
            <input type="text" id="searchInput" placeholder="Search" class="form-control form-control-sm">
        </div>
    </div>
</div>


    <!-- Table -->
    <div class="table">
        <table class=" table">
         <thead>
    <tr class="bg-light">
        <th class="heading-name" style="border-right: 1px solid #e5e7eb; border-right: none;">
            Collector Name
        </th>
        <th class="heading-location" style="border-right: 1px solid #e5e7eb; border-right: none;">
            Location
        </th>
        <th class="heading-phone" style="border-right: 1px solid #e5e7eb; border-right: none;">
            Phone Number
        </th>
        <th class="heading-bag-history" style="border-right: 1px solid #e5e7eb; border-right: none; text-align: center;">
            Bag History
        </th>
        <th class="heading-actions" style="text-align: right; border-left: none;">
            Actions
        </th>
    </tr>
</thead>
            <tbody id="collectorsTableBody">
                @forelse($collectors as $collector)
                <tr data-name="{{ $collector->name }}" data-id="{{ $collector->id }}" data-location="{{ $collector->location }}" data-phone="{{ $collector->phone_number }}" data-status="active">
                    <td>{{ $collector->name }}</td>
                    <td>{{ $collector->location ?? 'N/A' }}</td>
                    <td>{{ $collector->phone_number ?? 'N/A' }}</td>
                    <td class="text-center">
                        <button class="btn btn-sm text-white bag-history-btn"
                                style="background: linear-gradient(180deg, rgba(255, 255, 255, 0.12) 0%, rgba(255, 255, 255, 0.00) 100%), linear-gradient(180deg, #4598F9 0%, #3A77BF 100%); box-shadow: 0 1px 2px 0 rgba(13, 13, 18, 0.06); border: none; padding: 6px 16px;"
                                data-id="{{ $collector->id }}"
                                data-name="{{ $collector->name }}">
                            Bag History
                        </button>
                    </td>
                    <td>
                        <div class="action-buttons">
                            <button class="btn-action view view-btn me-1" title="View" data-id="{{ $collector->id }}">
                            </button>
                            <button class="btn-action edit edit-btn" title="Edit" style="width:29px" data-id="{{ $collector->id }}">
                                <i class="bi bi-pencil" style="font-size: 14px; color: #33cfff;"></i>
                            </button>
                            <button class="btn-action delete delete-btn" title="Delete" style="width:29px" data-id="{{ $collector->id }}">
                                <i class="bi bi-trash" style="font-size: 14px;"></i>
                            </button>
                        </div>
                    </td>
                </tr>
                @empty
                <tr id="noDataRow">
                    <td colspan="5" class="text-center py-4 text-muted">No collectors found. Add your first collector!</td>
                </tr>
                @endforelse
            </tbody>
        </table>
    </div>

    <!-- Pagination -->
    <div class="pagination-section bg-white">
        <div class="pagination-info">
            Showing <span id="showingStart">1</span> to <span id="showingEnd">10</span> of <span id="totalResults">500</span> results
        </div>

        <div class="pagination-controls">
            <div class="per-page-selector">
                <span>Per page:</span>
                <select id="perPageSelect">
                    <option value="10" selected>10</option>
                    <option value="25">25</option>
                    <option value="50">50</option>
                    <option value="100">100</option>
                </select>
            </div>

            <div class="pagination-buttons">
                <button class="page-btn disabled" id="prevBtn">
                    <i class="bi bi-chevron-left"></i>
                </button>
                <button class="page-btn" data-page="1">1</button>
                <button class="page-btn" data-page="2">2</button>
                <button class="page-btn active" data-page="3">3</button>
                <button class="page-btn disabled">...</button>
                <button class="page-btn" data-page="5">5</button>
                <button class="page-btn" id="nextBtn">
                    <i class="bi bi-chevron-right"></i>
                </button>
            </div>
        </div>
    </div>
</div>
</div>

<!-- Add Collector Modal -->
<div class="modal fade" id="addCollectorModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Add Collector</h5>
                <button type="button" data-bs-dismiss="modal" style="width: 36px; height: 36px; border-radius: 50%; border: 1px solid #D1D5DB; background-color: white; display: flex; align-items: center; justify-content: center; padding: 0; cursor: pointer; position: absolute; right: 20px; top: 20px;" onmouseover="this.style.backgroundColor='#f9fafb'" onmouseout="this.style.backgroundColor='white'">
                    <i class="bi bi-x" style="font-size: 20px; color: #000; font-weight: bold;"></i>
                </button>
            </div>
            <div class="modal-body">
                <form id="addCollectorForm">
                    <div class="mb-3">
                        <label class="form-label">Collector Name <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" id="collectorName" placeholder="Name" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Location</label>
                        <input type="text" class="form-control" id="collectorLocation" placeholder="Location">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Phone Number</label>
                        <input type="text" class="form-control" id="collectorPhone" placeholder="Phone Number">
                    </div>
                </form>
            </div>
           <div style="display: flex; justify-content: flex-end; gap: 10px; padding: 15px 20px;">
    <button type="button" class="btn" data-bs-dismiss="modal" style="background-color: #f8f9fa; border: 1px solid #dee2e6;">
        Cancel
    </button>
    <button type="button" class="btn btn-primary" id="saveCollectorBtn"
        style="background: linear-gradient(180deg, rgba(255, 255, 255, 0.12) 0%, rgba(255, 255, 255, 0.00) 100%),
               linear-gradient(180deg, #4598F9 0%, #3A77BF 100%);
               box-shadow: 0 1px 2px 0 rgba(13, 13, 18, 0.06);
               text-decoration: none; border: none; color: white !important;">
        Save
    </button>
</div>

        </div>
    </div>
</div>

<!-- Edit Collector Modal -->
<div class="modal fade" id="editCollectorModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="p-4">
                <h5 class="modal-title">Edit Collector</h5>
                  <button type="button" data-bs-dismiss="modal" style="width: 36px; height: 36px; border-radius: 50%; border: 1px solid #D1D5DB; background-color: white; display: flex; align-items: center; justify-content: center; padding: 0; cursor: pointer; position: absolute; right: 20px; top: 20px;" onmouseover="this.style.backgroundColor='#f9fafb'" onmouseout="this.style.backgroundColor='white'">
                    <i class="bi bi-x" style="font-size: 20px; color: #000; font-weight: bold;"></i>
                </button>
            </div>
            <div class="modal-body">
                <form id="editCollectorForm">
                    <div class="mb-3">
                        <label class="form-label">Collector Name <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" id="editCollectorName" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Location</label>
                        <input type="text" class="form-control" id="editCollectorLocation">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Phone Number</label>
                        <input type="text" class="form-control" id="editCollectorPhone">
                    </div>
                </form>
            </div>

            <div style="display: flex; justify-content: flex-end; gap: 10px; padding: 15px 20px 20px 20px; border-top: none;">
    <button type="button" class="btn" data-bs-dismiss="modal" style="background-color: #f8f9fa;">
        Cancel
    </button>
    <button type="button" class="btn btn-primary" id="updateCollectorBtn" style=" background: linear-gradient(180deg, rgba(255, 255, 255, 0.12) 0%, rgba(255, 255, 255, 0.00) 100%), linear-gradient(180deg, #4598F9 0%, #3A77BF 100%); box-shadow: 0 1px 2px 0 rgba(13, 13, 18, 0.06); color: white; text-decoration: none;
 border: none;">
        Update
    </button>
</div>

        </div>
    </div>
</div>

<!-- View Collector Modal -->
<div class="modal fade" id="viewCollectorModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Collector Details</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="mb-3">
                    <label class="form-label text-muted">Collector Name</label>
                    <p class="fw-bold" id="viewCollectorName" style="font-size: 16px; color: #111827;"></p>
                </div>
                <div class="mb-3">
                    <label class="form-label text-muted">Location</label>
                    <p class="fw-bold" id="viewCollectorLocation" style="font-size: 16px; color: #111827;"></p>
                </div>
                <div class="mb-3">
                    <label class="form-label text-muted">Phone Number</label>
                    <p class="fw-bold" id="viewCollectorPhone" style="font-size: 16px; color: #111827;"></p>
                </div>
                <div class="mb-3">
                    <label class="form-label text-muted">Status</label>
                    <p><span class="badge bg-success">Active</span></p>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>

<!-- Success Dialog Modal -->
<div class="modal fade" id="successModal" tabindex="-1" data-bs-backdrop="static" data-bs-keyboard="false">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content" style="border-radius: 16px; border: none; box-shadow: 0 4px 20px rgba(0,0,0,0.15);">
            <div class="modal-body text-center p-5">
                <div class="mb-3">
                    <div style="width: 80px; height: 80px; background: #d1fae5; border-radius: 50%; display: flex; align-items: center; justify-content: center; margin: 0 auto;">
                        <i class="bi bi-check-circle-fill" style="font-size: 48px; color: #10b981;"></i>
                    </div>
                </div>
                <h4 class="mb-2" style="color: #111827; font-weight: 600;">Success!</h4>
                <p id="successMessage" class="mb-4" style="color: #6b7280; font-size: 16px;"></p>
                <button type="button" class="btn btn-primary px-5" style="background: linear-gradient(180deg, rgba(255, 255, 255, 0.12) 0%, rgba(255, 255, 255, 0.00) 100%), linear-gradient(180deg, #4598F9 0%, #3A77BF 100%); box-shadow: 0 1px 2px 0 rgba(13, 13, 18, 0.06); border: none; border-radius: 8px;" data-bs-dismiss="modal">
                    OK
                </button>
            </div>
        </div>
    </div>
</div>

<!-- Error Dialog Modal -->
<div class="modal fade" id="errorModal" tabindex="-1" data-bs-backdrop="static" data-bs-keyboard="false">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content" style="border-radius: 16px; border: none; box-shadow: 0 4px 20px rgba(0,0,0,0.15);">
            <div class="modal-body text-center p-5">
                <div class="mb-3">
                    <div style="width: 80px; height: 80px; background: #fee2e2; border-radius: 50%; display: flex; align-items: center; justify-content: center; margin: 0 auto;">
                        <i class="bi bi-x-circle-fill" style="font-size: 48px; color: #ef4444;"></i>
                    </div>
                </div>
                <h4 class="mb-2" style="color: #111827; font-weight: 600;">Error!</h4>
                <p id="errorMessage" class="mb-4" style="color: #6b7280; font-size: 16px;"></p>
                <button type="button" class="btn btn-danger px-5" style="background: #ef4444; border: none; border-radius: 8px;" data-bs-dismiss="modal">
                    Close
                </button>
            </div>
        </div>
    </div>
</div>

</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const clinicId = {{ $clinic->id }};
    const csrfToken = '{{ csrf_token() }}';
    let allCollectors = [];
    let currentSortOrder = 'asc';
    let currentFilter = 'all';

    // Initialize collectors from table
    function initializeCollectors() {
        allCollectors = [];
        document.querySelectorAll('#collectorsTableBody tr').forEach(row => {
            const name = row.getAttribute('data-name');
            if(name) {
                allCollectors.push(name);
            }
        });
    }

    initializeCollectors();

    // ============ CUSTOM DIALOG FUNCTIONS ============

    function showSuccessDialog(message) {
        document.getElementById('successMessage').textContent = message;
        const successModal = new bootstrap.Modal(document.getElementById('successModal'));
        successModal.show();
    }

    function showErrorDialog(message) {
        document.getElementById('errorMessage').textContent = message;
        const errorModal = new bootstrap.Modal(document.getElementById('errorModal'));
        errorModal.show();
    }

    // ============ SEARCH FUNCTIONALITY ============

    const searchInput = document.getElementById('searchInput');
    if(searchInput) {
        searchInput.addEventListener('input', function(e) {
            const searchTerm = this.value.toLowerCase();
            const rows = document.querySelectorAll('#collectorsTableBody tr[data-name]');

            rows.forEach(row => {
                const name = (row.getAttribute('data-name') || '').toLowerCase();
                const location = (row.getAttribute('data-location') || '').toLowerCase();
                const phone = (row.getAttribute('data-phone') || '').toLowerCase();

                if(name.includes(searchTerm) || location.includes(searchTerm) || phone.includes(searchTerm)) {
                    row.style.display = '';
                } else {
                    row.style.display = 'none';
                }
            });

            currentPage = 1;
            paginateTable();
        });
    }

    // ============ ADD COLLECTOR ============

    const saveBtn = document.getElementById('saveCollectorBtn');
    if(saveBtn) {
        saveBtn.addEventListener('click', function() {
            const nameInput = document.getElementById('collectorName');
            const locationInput = document.getElementById('collectorLocation');
            const phoneInput = document.getElementById('collectorPhone');

            if(!nameInput) return;

            const name = nameInput.value.trim();
            const location = locationInput.value.trim();
            const phone = phoneInput.value.trim();

            if(!name) {
                showErrorDialog('Please enter Collector name');
                return;
            }

            // Send AJAX request to backend
            fetch(`/moduls/${clinicId}/medical-waste/collectors/store`, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': csrfToken,
                    'Accept': 'application/json'
                },
                body: JSON.stringify({
                    name: name,
                    location: location,
                    phone_number: phone
                })
            })
            .then(response => response.json())
            .then(data => {
                if(data.success) {
                    // Hide the add modal first
                    const addModal = document.getElementById('addCollectorModal');
                    if(addModal) {
                        const modal = bootstrap.Modal.getInstance(addModal);
                        if(modal) modal.hide();
                    }

                    const tbody = document.getElementById('collectorsTableBody');
                    if(!tbody) return;

                    // Remove "no data" row if it exists
                    const noDataRow = document.getElementById('noDataRow');
                    if(noDataRow) {
                        noDataRow.remove();
                    }

                    const newRow = document.createElement('tr');
                    newRow.setAttribute('data-name', data.collector.name);
                    newRow.setAttribute('data-id', data.collector.id);
                    newRow.setAttribute('data-location', data.collector.location || '');
                    newRow.setAttribute('data-phone', data.collector.phone_number || '');
                    newRow.setAttribute('data-status', 'active');
                    newRow.innerHTML = `
                        <td>${data.collector.name}</td>
                        <td>${data.collector.location || 'N/A'}</td>
                        <td>${data.collector.phone_number || 'N/A'}</td>
                        <td class="text-center">
                            <button class="btn btn-sm text-white bag-history-btn"
                                    style="background: linear-gradient(180deg, rgba(255, 255, 255, 0.12) 0%, rgba(255, 255, 255, 0.00) 100%), linear-gradient(180deg, #4598F9 0%, #3A77BF 100%); box-shadow: 0 1px 2px 0 rgba(13, 13, 18, 0.06); border: none; padding: 6px 16px;"
                                    data-id="${data.collector.id}"
                                    data-name="${data.collector.name}">
                                Bag History
                            </button>
                        </td>
                        <td>
                            <div class="action-buttons">
                                <button class="btn-action view view-btn me-1" title="View" data-id="${data.collector.id}">
                                </button>
                                <button class="btn-action edit edit-btn" title="Edit" style="width:29px" data-id="${data.collector.id}">
                                    <i class="bi bi-pencil" style="font-size: 14px; color: #33cfff;"></i>
                                </button>
                                <button class="btn-action delete delete-btn" title="Delete" style="width:29px" data-id="${data.collector.id}">
                                    <i class="bi bi-trash" style="font-size: 14px;"></i>
                                </button>
                            </div>
                        </td>
                    `;

                    tbody.insertBefore(newRow, tbody.firstChild);
                    attachRowEvents(newRow);
                    allCollectors.unshift(data.collector.name);

                    nameInput.value = '';
                    locationInput.value = '';
                    phoneInput.value = '';

                    // Refresh pagination
                    currentPage = 1;
                    paginateTable();

                    // Show success dialog
                    showSuccessDialog(data.message || 'Collector created successfully!');
                } else {
                    showErrorDialog(data.message || 'Failed to add collector');
                }
            })
            .catch(error => {
                console.error('Error:', error);
                showErrorDialog('An error occurred while adding collector');
            });
        });
    }

    // ============ VIEW COLLECTOR ============

    function viewCollector(row) {
        const name = row.getAttribute('data-name');
        const location = row.getAttribute('data-location') || 'N/A';
        const phone = row.getAttribute('data-phone') || 'N/A';

        document.getElementById('viewCollectorName').textContent = name;
        document.getElementById('viewCollectorLocation').textContent = location;
        document.getElementById('viewCollectorPhone').textContent = phone;

        const viewModal = document.getElementById('viewCollectorModal');
        if(viewModal) {
            new bootstrap.Modal(viewModal).show();
        }
    }

    // ============ EDIT COLLECTOR ============

    function editCollector(row) {
        const name = row.getAttribute('data-name');
        const location = row.getAttribute('data-location');
        const phone = row.getAttribute('data-phone');
        const id = row.getAttribute('data-id');

        document.getElementById('editCollectorName').value = name;
        document.getElementById('editCollectorLocation').value = location || '';
        document.getElementById('editCollectorPhone').value = phone || '';

        const editModal = document.getElementById('editCollectorModal');
        if(editModal) {
            editModal.setAttribute('data-editing-id', id);
            new bootstrap.Modal(editModal).show();
        }
    }

    // ============ UPDATE COLLECTOR ============

    const updateBtn = document.getElementById('updateCollectorBtn');
    if(updateBtn) {
        updateBtn.addEventListener('click', function() {
            const editNameInput = document.getElementById('editCollectorName');
            const editLocationInput = document.getElementById('editCollectorLocation');
            const editPhoneInput = document.getElementById('editCollectorPhone');

            if(!editNameInput) return;

            const newName = editNameInput.value.trim();
            const newLocation = editLocationInput.value.trim();
            const newPhone = editPhoneInput.value.trim();

            if(!newName) {
                showErrorDialog('Please enter collector name');
                return;
            }

            const editModal = document.getElementById('editCollectorModal');
            if(!editModal) return;

            const id = editModal.getAttribute('data-editing-id');

            // Send AJAX request to backend
            fetch(`/moduls/${clinicId}/medical-waste/collectors/${id}`, {
                method: 'PUT',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': csrfToken,
                    'Accept': 'application/json'
                },
                body: JSON.stringify({
                    name: newName,
                    location: newLocation,
                    phone_number: newPhone
                })
            })
            .then(response => response.json())
            .then(data => {
                if(data.success) {
                    // Hide the edit modal first
                    const modal = bootstrap.Modal.getInstance(editModal);
                    if(modal) modal.hide();

                    // Find and update the row
                    const row = document.querySelector(`#collectorsTableBody tr[data-id="${id}"]`);
                    if(row) {
                        const oldName = row.getAttribute('data-name');

                        const index = allCollectors.indexOf(oldName);
                        if(index > -1) {
                            allCollectors[index] = newName;
                        }

                        row.setAttribute('data-name', newName);
                        row.setAttribute('data-location', newLocation);
                        row.setAttribute('data-phone', newPhone);

                        const cells = row.querySelectorAll('td');
                        if(cells.length >= 3) {
                            cells[0].textContent = newName;
                            cells[1].textContent = newLocation || 'N/A';
                            cells[2].textContent = newPhone || 'N/A';
                        }
                    }

                    // Show success dialog
                    showSuccessDialog(data.message || 'Collector updated successfully!');
                } else {
                    showErrorDialog(data.message || 'Failed to update collector');
                }
            })
            .catch(error => {
                console.error('Error:', error);
                showErrorDialog('An error occurred while updating collector');
            });
        });
    }

    // ============ DELETE COLLECTOR ============

    function deleteCollector(row) {
        if(confirm('Are you sure you want to delete this Collector?')) {
            const id = row.getAttribute('data-id');
            const name = row.getAttribute('data-name');

            // Send AJAX request to backend
            fetch(`/moduls/${clinicId}/medical-waste/collectors/${id}`, {
                method: 'DELETE',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': csrfToken,
                    'Accept': 'application/json'
                }
            })
            .then(response => response.json())
            .then(data => {
                if(data.success) {
                    const index = allCollectors.indexOf(name);
                    if(index > -1) {
                        allCollectors.splice(index, 1);
                    }

                    row.remove();

                    // Check if table is now empty
                    const tbody = document.getElementById('collectorsTableBody');
                    const remainingRows = tbody.querySelectorAll('tr[data-name]');

                    if(remainingRows.length === 0) {
                        const noDataRow = document.createElement('tr');
                        noDataRow.id = 'noDataRow';
                        noDataRow.innerHTML = '<td colspan="5" class="text-center py-4 text-muted">No collectors found. Add your first collector!</td>';
                        tbody.appendChild(noDataRow);
                    }

                    // Refresh pagination
                    paginateTable();

                    // Show success dialog
                    showSuccessDialog(data.message || 'Collector deleted successfully!');
                } else {
                    showErrorDialog(data.message || 'Failed to delete collector');
                }
            })
            .catch(error => {
                console.error('Error:', error);
                showErrorDialog('An error occurred while deleting collector');
            });
        }
    }

    // ============ BAG HISTORY ============

    function showBagHistory(row) {
        const id = row.getAttribute('data-id');
        const name = row.getAttribute('data-name');
        // TODO: Navigate to bag history page or show modal
        alert(`Show bag history for ${name} (ID: ${id})`);
    }

    // ============ ATTACH EVENTS ============

    function attachRowEvents(row) {
        const viewBtn = row.querySelector('.view-btn');
        const editBtn = row.querySelector('.edit-btn');
        const deleteBtn = row.querySelector('.delete-btn');
        const bagHistoryBtn = row.querySelector('.bag-history-btn');

        if(viewBtn) {
            const newViewBtn = viewBtn.cloneNode(true);
            viewBtn.parentNode.replaceChild(newViewBtn, viewBtn);
            newViewBtn.addEventListener('click', () => viewCollector(row));
        }

        if(editBtn) {
            const newEditBtn = editBtn.cloneNode(true);
            editBtn.parentNode.replaceChild(newEditBtn, editBtn);
            newEditBtn.addEventListener('click', () => editCollector(row));
        }

        if(deleteBtn) {
            const newDeleteBtn = deleteBtn.cloneNode(true);
            deleteBtn.parentNode.replaceChild(newDeleteBtn, deleteBtn);
            newDeleteBtn.addEventListener('click', () => deleteCollector(row));
        }

        if(bagHistoryBtn) {
            const newBagHistoryBtn = bagHistoryBtn.cloneNode(true);
            bagHistoryBtn.parentNode.replaceChild(newBagHistoryBtn, bagHistoryBtn);
            newBagHistoryBtn.addEventListener('click', () => showBagHistory(row));
        }
    }

    // Attach events to existing rows
    document.querySelectorAll('#collectorsTableBody tr').forEach(row => {
        attachRowEvents(row);
    });

    // ============ PAGINATION ============

    let currentPage = 1;
    let itemsPerPage = 10;

    function getVisibleRows() {
        const rows = Array.from(document.querySelectorAll('#collectorsTableBody tr[data-name]'));
        return rows.filter(row => row.style.display !== 'none');
    }

    function updatePaginationInfo() {
        const visibleRows = getVisibleRows();
        const totalItems = visibleRows.length;
        const showingStart = totalItems > 0 ? ((currentPage - 1) * itemsPerPage) + 1 : 0;
        const showingEnd = Math.min(currentPage * itemsPerPage, totalItems);

        document.getElementById('showingStart').textContent = showingStart;
        document.getElementById('showingEnd').textContent = showingEnd;
        document.getElementById('totalResults').textContent = totalItems;
    }

    function renderPaginationButtons() {
        const visibleRows = getVisibleRows();
        const totalItems = visibleRows.length;
        const totalPages = Math.ceil(totalItems / itemsPerPage);

        const paginationContainer = document.querySelector('.pagination-buttons');
        if(!paginationContainer) return;

        const existingButtons = paginationContainer.querySelectorAll('.page-btn:not(#prevBtn):not(#nextBtn)');
        existingButtons.forEach(btn => btn.remove());

        const prevBtn = document.getElementById('prevBtn');
        const nextBtn = document.getElementById('nextBtn');

        paginationContainer.innerHTML = '';
        if(prevBtn) paginationContainer.appendChild(prevBtn);

        let pagesToShow = [];
        if(totalPages <= 7) {
            for(let i = 1; i <= totalPages; i++) {
                pagesToShow.push(i);
            }
        } else {
            pagesToShow.push(1);

            if(currentPage <= 3) {
                pagesToShow.push(2, 3, 4, '...', totalPages);
            } else if(currentPage >= totalPages - 2) {
                pagesToShow.push('...', totalPages - 3, totalPages - 2, totalPages - 1, totalPages);
            } else {
                pagesToShow.push('...', currentPage - 1, currentPage, currentPage + 1, '...', totalPages);
            }
        }

        pagesToShow.forEach(page => {
            const btn = document.createElement('button');
            btn.className = 'page-btn';

            if(page === '...') {
                btn.textContent = '...';
                btn.classList.add('disabled');
                btn.disabled = true;
            } else {
                btn.textContent = page;
                btn.setAttribute('data-page', page);
                if(page === currentPage) {
                    btn.classList.add('active');
                }
                btn.addEventListener('click', function() {
                    currentPage = parseInt(this.getAttribute('data-page'));
                    paginateTable();
                });
            }

            paginationContainer.appendChild(btn);
        });

        if(nextBtn) paginationContainer.appendChild(nextBtn);

        if(prevBtn) {
            if(currentPage === 1) {
                prevBtn.classList.add('disabled');
                prevBtn.disabled = true;
            } else {
                prevBtn.classList.remove('disabled');
                prevBtn.disabled = false;
            }
        }

        if(nextBtn) {
            if(currentPage >= totalPages) {
                nextBtn.classList.add('disabled');
                nextBtn.disabled = true;
            } else {
                nextBtn.classList.remove('disabled');
                nextBtn.disabled = false;
            }
        }
    }

    function paginateTable() {
        const visibleRows = getVisibleRows();
        const startIndex = (currentPage - 1) * itemsPerPage;
        const endIndex = startIndex + itemsPerPage;

        visibleRows.forEach((row, index) => {
            if(index >= startIndex && index < endIndex) {
                row.style.display = '';
            } else {
                row.style.display = 'none';
            }
        });

        updatePaginationInfo();
        renderPaginationButtons();
    }

    // ============ PAGINATION BUTTONS ============

    const prevBtn = document.getElementById('prevBtn');
    if(prevBtn) {
        prevBtn.addEventListener('click', function() {
            if(currentPage > 1) {
                currentPage--;
                paginateTable();
            }
        });
    }

    const nextBtn = document.getElementById('nextBtn');
    if(nextBtn) {
        nextBtn.addEventListener('click', function() {
            const visibleRows = getVisibleRows();
            const totalPages = Math.ceil(visibleRows.length / itemsPerPage);
            if(currentPage < totalPages) {
                currentPage++;
                paginateTable();
            }
        });
    }

    const perPageSelect = document.getElementById('perPageSelect');
    if(perPageSelect) {
        perPageSelect.addEventListener('change', function() {
            const value = parseInt(this.value);
            if(!isNaN(value)) {
                itemsPerPage = value;
                currentPage = 1;
                paginateTable();
            }
        });
    }

    // Initialize pagination on page load
    paginateTable();
});
</script>
@endsection
