@extends('partials.layouts.master')

@section('title', 'Clinics Management - MediTrack')
@section('meta_description', 'Manage all healthcare clinics in one place. Add, edit, and monitor clinic information, module access, and operational status.')
@section('title-sub','Clinics')
@section('pagetitle','')

@section('content')

<style>
    body {
        background-color: white !important;
    }
    .main-home {
color: var(--Greyscale-900, #818898) !important;
/* Body/Medium/Medium */
font-family: "Inter Tight";
font-size: 14px;
font-style: normal;
font-weight: 500;
line-height: 150%; /* 21px */
letter-spacing: 0.28px;
    }
    .main-clinics{
        color: var(--Greyscale-400, #0D0D12) !important;
/* Body/Medium/Medium */
font-family: "Inter Tight";
font-size: 14px;
font-style: normal;
font-weight: 500;
line-height: 150%; /* 21px */
letter-spacing: 0.28px;
    }
    .main-clinic-list {
        color: var(--Greyscale-900, #0D0D12);
/* Body/Large/Semibold */
font-family: "Inter Tight";
font-size: 16px;
font-style: normal;
font-weight: 600;
line-height: 150%; /* 24px */
letter-spacing: 0.32px;
    }
    .filter:hover{
    background: linear-gradient(180deg, rgba(255, 255, 255, 0.12) 0%, rgba(255, 255, 255, 0.00) 100%), linear-gradient(180deg, #4598F9 0%, #3A77BF 100%); box-shadow: 0 1px 2px 0 rgba(13, 13, 18, 0.06); color: #ffffff !important;
    }
    .sort:hover{
    background: linear-gradient(180deg, rgba(255, 255, 255, 0.12) 0%, rgba(255, 255, 255, 0.00) 100%), linear-gradient(180deg, #4598F9 0%, #3A77BF 100%); box-shadow: 0 1px 2px 0 rgba(13, 13, 18, 0.06); color: #ffffff !important;
    }
    .dropdown-toggle::after {
        display: none !important;
    }
    .status-select {
        background-image: none !important;
    }
    .pagination .page-link {
        color: #4598F9;
        background-color: white;
        border: 1px solid #dee2e6;
        padding: 8px 12px;
        margin: 0 2px;
        border-radius: 6px;
    }
    .pagination .page-link:hover {
        background: linear-gradient(180deg, rgba(255, 255, 255, 0.12) 0%, rgba(255, 255, 255, 0.00) 100%), linear-gradient(180deg, #4598F9 0%, #3A77BF 100%); box-shadow: 0 1px 2px 0 rgba(13, 13, 18, 0.06); color: #ffffff !important;
        border-color: #4598F9;
    }
    .pagination .page-item.active .page-link {
        background: linear-gradient(180deg, rgba(255, 255, 255, 0.12) 0%, rgba(255, 255, 255, 0.00) 100%), linear-gradient(180deg, #4598F9 0%, #3A77BF 100%); box-shadow: 0 1px 2px 0 rgba(13, 13, 18, 0.06); color: #ffffff !important;
        border-color: #4598F9;
    }
    .pagination .page-item.disabled .page-link {
        color: #6c757d;
        background-color: #f8f9fa;
        border-color: #dee2e6;
    }
    .export {
        border: 1px solid #00000034 !important;
    }
    .export:hover {
        border: 1px solid #00000034 !important;
        color: black !important;
    }
</style>

<div class="container-fluid">
    @if(session('success'))
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        {{ session('success') }}
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
    @endif

    @if(session('error'))
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        {{ session('error') }}
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
    @endif

    <nav aria-label="breadcrumb" class="mb-3 d-flex justify-content-between">
       <div class="d-flex justify-content-between align-items-center mb-3">
          <div class="flex items-center space-x-2 text-sm font-medium">
           <span class="main-home">Home</span>
            <span class="main-home">/</span>
              <span class="main-clinics">Clinics</span>
         </div>
     </div>
         <div>
<button class="btn export  me-2 text-black fw-bold" style=" height: 40px; padding: 6px 14px; justify-content: center; align-items: center; gap: 8px; border-radius: 8px; border: 1px solid #00000034; background: #FFF; box-shadow: 0 1px 2px 0 rgba(13, 13, 18, 0.06);">Export CSV</button>
<a href="{{ route('add-new-Clinic') }}"
   class="btn"
   style=" height: 40px; padding: 8px 16px; justify-content: center; align-items: center; gap: 8px; border-radius: 8px; border: 1px solid #FFF; background: linear-gradient(180deg, rgba(255, 255, 255, 0.12) 0%, rgba(255, 255, 255, 0.00) 100%), linear-gradient(180deg, #4598F9 0%, #3A77BF 100%); box-shadow: 0 1px 2px 0 rgba(13, 13, 18, 0.06); color: white; text-decoration: none;">
   Add Clinic
</a>
  </div>
    </nav>

    <div class="p-4">
     <div class="border border-1 p-4" style="border-radius: 12px;">
    <div class="d-flex justify-content-between align-items-center mb-3">
        <div>
        <h4 class="main-clinic-list">Clinic List</h4>
        </div>
       <div class="d-flex gap-2">
<div class="input-group" style="max-width: 280px; border: 1px solid #dee2e6; border-radius: 12px; overflow: hidden;">
    <span class="input-group-text bg-white" style="border: none;">
        <i class="bi bi-search text-muted"></i>
    </span>
    <input type="text" class="form-control ps-0" id="searchInput" placeholder="Search" style="border: none; height: 40px; outline: none; box-shadow: none;" onkeyup="searchTable()">
</div>

    <div class="dropdown">
        <button class="btn btn-light filter bg-white d-flex align-items-center gap-2 dropdown-toggle" type="button" id="filterDropdown" data-bs-toggle="dropdown" aria-expanded="false" style="border-radius: 12px; padding: 8px 20px; border: 1px solid #e0e0e0; width:100px; height:40px;">
            <i class="bi bi-funnel"></i>
            <span>Filter</span>
        </button>
        <ul class="dropdown-menu" aria-labelledby="filterDropdown">
            <li><a class="dropdown-item" href="#" onclick="filterTable('all')">All</a></li>
            <li><a class="dropdown-item" href="#" onclick="filterTable('active')">Active</a></li>
            <li><a class="dropdown-item" href="#" onclick="filterTable('suspend')">Suspend</a></li>
        </ul>
    </div>

    <div class="dropdown">
        <button class="btn sort d-flex align-items-center gap-2 dropdown-toggle" type="button" id="sortDropdown" data-bs-toggle="dropdown" aria-expanded="false" style="border-radius: 12px; padding: 6px 14px; border: 1px solid #e0e0e0; width:100px; height:40px;">
            <i class="bi bi-arrow-down-up"></i>
            <span>Sort by</span>
        </button>
        <ul class="dropdown-menu" aria-labelledby="sortDropdown">
            <li><a class="dropdown-item" href="#" onclick="sortTable('name-asc')">Name (A-Z)</a></li>
            <li><a class="dropdown-item" href="#" onclick="sortTable('name-desc')">Name (Z-A)</a></li>
        </ul>
    </div>
</div>
    </div>

    <div class="card" style="border:none;">
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table align-middle mb-0" id="clinicsTable">
  <thead>
    <tr>
        <th class="py-3 heading-name" style="border: none; background-color: #f8f9fa;">
            <span style="color: #666d80; font-weight: 500;">Name</span>
        </th>
        <th class="py-3 heading-address" style="border: none; background-color: #f8f9fa;">
            <span style="color: #666d80; font-weight: 500;">Address</span>
        </th>
        <th class="py-3 heading-models" style="border: none; background-color: #f8f9fa;">
            <span style="color: #666d80; font-weight: 500;">Models</span>
        </th>
        <th class="py-3 heading-status" style="border: none; background-color: #f8f9fa;">
            <span style="color: #666d80; font-weight: 500;">Status</span>
        </th>
        <th class="py-3 heading-actions" style="border: none; background-color: #f8f9fa;">
            <span style="color: #666d80; font-weight: 500;">Actions</span>
        </th>
    </tr>
</thead>

                    <tbody>
                        <!-- Content will be dynamically loaded via AJAX -->
                    </tbody>
                </table>
            </div>

            <div class="d-flex justify-content-between align-items-center p-3">
                <div id="paginationInfo" style="color: #666d80;">Loading...</div>
                <div class="d-flex align-items-center gap-3">
                    <div class="d-flex align-items-center gap-2">
                        <span style="color: #666d80;">Per page</span>
                        <select class="form-select form-select-sm" id="perPageSelect" onchange="changePerPage()" style="width: 70px; border: 1px solid #dee2e6; border-radius: 6px;">
                            <option value="5">5</option>
                            <option value="10" selected>10</option>
                            <option value="20">20</option>
                            <option value="50">50</option>
                        </select>
                    </div>
              <ul class="pagination mb-0" style="display: flex; align-items: center;">
                <!-- Pagination will be dynamically generated -->
</ul>       </div>
            </div>
            </div>
        </div>
    </div>
</div>
    </div>

<div class="modal fade" id="viewModal" tabindex="-1" aria-labelledby="viewModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content" style="border-radius: 12px; overflow: hidden;">
            <div class="p-4">
                <h5 class="modal-title" id="viewModalLabel">Clinic Details</h5>
                <button type="button" data-bs-dismiss="modal" style="width: 36px; height: 36px; border-radius: 50%; border: 1px solid #D1D5DB; background-color: white; display: flex; align-items: center; justify-content: center; padding: 0; cursor: pointer; position: absolute; right: 20px; top: 20px;" onmouseover="this.style.backgroundColor='#f9fafb'" onmouseout="this.style.backgroundColor='white'">
                    <i class="bi bi-x" style="font-size: 20px; color: #000; font-weight: bold;"></i>
                </button>
                    </div>
            <div class="modal-body">
                <div class="mb-3"><label class="form-label fw-bold">Clinic Name:</label><p id="viewName" class="mb-0"></p></div>
                <div class="mb-3"><label class="form-label fw-bold">Address:</label><p id="viewAddress" class="mb-0"></p></div>
            </div>
            <div style="padding: 16px 24px; display: flex; justify-content: flex-end;">
                <button type="button" class="btn border px-4" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="deleteModal" tabindex="-1" aria-labelledby="deleteModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content" style="border-radius: 12px; overflow: hidden;">
            <div class="p-4">
                <h5 class="modal-title" id="deleteModalLabel">Confirm Delete</h5>
                 <button type="button" data-bs-dismiss="modal" style="width: 36px; height: 36px; border-radius: 50%; border: 1px solid #D1D5DB; background-color: white; display: flex; align-items: center; justify-content: center; padding: 0; cursor: pointer; position: absolute; right: 20px; top: 20px;" onmouseover="this.style.backgroundColor='#f9fafb'" onmouseout="this.style.backgroundColor='white'">
                    <i class="bi bi-x" style="font-size: 20px; color: #000; font-weight: bold;"></i>
                </button>
                        </div>
            <div class="modal-body">
                <p>Are you sure you want to delete <strong id="deleteName"></strong>?</p>
            </div>
             <div style="padding: 16px 24px; display: flex; justify-content-flex-end;">
                <button type="button" class="btn border px-4 me-1" data-bs-dismiss="modal">Close</button>
                <button type="button" class="btn btn-danger" onclick="confirmDelete()" style=" height: 40px; padding: 8px 16px; justify-content: center; align-items: center; gap: 8px; border-radius: 8px; border: 1px solid #FFF; background: linear-gradient(180deg, rgba(255, 255, 255, 0.12) 0%, rgba(255, 255, 255, 0.00) 100%), linear-gradient(180deg, #4598F9 0%, #3A77BF 100%); box-shadow: 0 1px 2px 0 rgba(13, 13, 18, 0.06); color: white; text-decoration: none;">Delete</button>
            </div>
        </div>
    </div>
</div>

<script>
let currentRowId = null;
let currentPerPage = 10;
let currentPage = 1;
let totalPages = 1;
let currentSearch = '';
let currentFilter = 'all';
let currentSort = 'name-asc';

// Load clinics data on page load
document.addEventListener('DOMContentLoaded', function() {
    loadClinicsData();
});

function loadClinicsData() {
    const params = new URLSearchParams({
        page: currentPage,
        per_page: currentPerPage,
        search: currentSearch,
        filter: currentFilter,
        sort: currentSort
    });

    fetch(`/clinics/paginated?${params.toString()}`)
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                renderTable(data.data);
                updatePaginationUI(data);
            } else {
                console.error('Error loading clinics:', data.message);
            }
        })
        .catch(error => {
            console.error('Error:', error);
        });
}

function renderTable(clinics) {
    const tbody = document.querySelector('#clinicsTable tbody');
    tbody.innerHTML = '';

    if (clinics.length === 0) {
        tbody.innerHTML = `
            <tr>
                <td colspan="5" class="text-center py-4 text-muted">
                    No clinics found. <a href="{{ route('add-new-Clinic') }}" class="text-primary">Add your first clinic</a>
                </td>
            </tr>
        `;
        return;
    }

    clinics.forEach(clinic => {
        const statusColor = clinic.status == 1 ? '#10b981' : '#ef4444';
        const statusText = clinic.status == 1 ? 'Active' : 'Suspend';
        const statusValue = clinic.status == 1 ? '1' : '0';
        const dataStatus = clinic.status == 1 ? 'active' : 'suspend';

        const row = `
            <tr id="row-${clinic.id}" data-status="${dataStatus}" class="border-bottom">
                <td class="py-3"><p class="mb-0">${clinic.clinic_name}</p></td>
                <td class="py-3"><span>${clinic.clinic_location}</span></td>
                <td class="py-3">
                    <a href="/moduls/${clinic.id}" class="btn btn-sm" style="border-radius: 8px; border: 1px solid #FFF; background: linear-gradient(180deg, rgba(255, 255, 255, 0.12) 0%, rgba(255, 255, 255, 0.00) 100%), linear-gradient(180deg, #4598F9 0%, #3A77BF 100%); box-shadow: 0 1px 2px 0 rgba(13, 13, 18, 0.06); color: #ffffff; text-decoration: none; padding: 4px 12px;">View Moduls</a>
                </td>
                <td class="py-3">
                    <select class="form-select form-select-sm status-select" data-row="${clinic.id}" data-clinic-id="${clinic.id}" onchange="changeStatus(this)" style="width: auto; border-radius: 20px; font-weight: 500; padding: 4px 12px; appearance: none; border: 1px solid ${statusColor}; color: ${statusColor}; background-color: white;">
                        <option value="1" ${clinic.status == 1 ? 'selected' : ''} style="color: #10b981;">● Active</option>
                        <option value="0" ${clinic.status == 0 ? 'selected' : ''} style="color: #ef4444;">● Suspend</option>
                    </select>
                </td>
                <td class="text-end py-3" style="white-space: nowrap;">
                    <a href="/clinic/${clinic.id}/edit" class="btn btn-sm me-1" style="background-color: #f0fbff; border: 1px solid #dee2e6; padding: 4px 8px;">
                        <i class="bi bi-pencil" style="color: #33cfff; font-size: 14px;"></i>
                    </a>
                    <form action="/clinic/${clinic.id}" method="POST" style="display: inline;" onsubmit="return confirm('Are you sure you want to delete ${clinic.clinic_name}?');">
                        <input type="hidden" name="_token" value="{{ csrf_token() }}">
                        <input type="hidden" name="_method" value="DELETE">
                        <button type="submit" class="btn btn-sm" style="background-color: #fff0f3; border: 1px solid #dee2e6; padding: 4px 8px;">
                            <i class="bi bi-trash" style="color: red; font-size: 14px;"></i>
                        </button>
                    </form>
                </td>
            </tr>
        `;
        tbody.innerHTML += row;
    });
}

function updatePaginationUI(data) {
    // Update pagination info
    const paginationInfo = document.getElementById('paginationInfo');
    paginationInfo.textContent = `Showing ${data.from || 0} to ${data.to || 0} of ${data.total} results`;

    // Update total pages
    totalPages = data.last_page;
    currentPage = data.current_page;

    // Update pagination buttons
    const paginationContainer = document.querySelector('.pagination');
    paginationContainer.innerHTML = '';

    // Previous button
    const prevDisabled = currentPage === 1 ? 'disabled' : '';
    paginationContainer.innerHTML += `
        <li class="page-item ${prevDisabled}" id="prevBtn">
            <a class="page-link d-flex align-items-center justify-content-center" href="#" onclick="changePage('prev'); return false;" style="min-height: 38px;">
                <i class="bi bi-chevron-left"></i>
            </a>
        </li>
    `;

    // Page numbers
    const startPage = Math.max(1, currentPage - 2);
    const endPage = Math.min(totalPages, currentPage + 2);

    for (let i = startPage; i <= endPage; i++) {
        const activeClass = i === currentPage ? 'active' : '';
        paginationContainer.innerHTML += `
            <li class="page-item page-number ${activeClass}" data-page="${i}">
                <a class="page-link d-flex align-items-center justify-content-center" href="#" onclick="changePage(${i}); return false;" style="min-height: 38px;">${i}</a>
            </li>
        `;
    }

    // Next button
    const nextDisabled = currentPage === totalPages ? 'disabled' : '';
    paginationContainer.innerHTML += `
        <li class="page-item ${nextDisabled}" id="nextBtn">
            <a class="page-link d-flex align-items-center justify-content-center" href="#" onclick="changePage('next'); return false;" style="min-height: 38px;">
                <i class="bi bi-chevron-right"></i>
            </a>
        </li>
    `;
}

function changePerPage() {
    const perPageSelect = document.getElementById('perPageSelect');
    currentPerPage = parseInt(perPageSelect.value);
    currentPage = 1; // Reset to first page
    loadClinicsData();
}

function changePage(page) {
    if (page === 'prev') {
        if (currentPage > 1) currentPage--;
    } else if (page === 'next') {
        if (currentPage < totalPages) currentPage++;
    } else {
        currentPage = page;
    }
    loadClinicsData();
}

function searchTable() {
    const input = document.getElementById("searchInput");
    currentSearch = input.value;
    currentPage = 1; // Reset to first page
    loadClinicsData();
}

function filterTable(status) {
    currentFilter = status;
    currentPage = 1; // Reset to first page
    loadClinicsData();
}

function sortTable(sortBy) {
    currentSort = sortBy;
    currentPage = 1; // Reset to first page
    loadClinicsData();
}

function changeStatus(selectElement) {
    const status = selectElement.value;
    const clinicId = selectElement.getAttribute('data-clinic-id');
    const rowId = selectElement.getAttribute('data-row');
    const row = document.getElementById('row-' + rowId);

    // Update UI immediately
    if (status === '1') {
        selectElement.style.borderColor = '#10b981';
        selectElement.style.color = '#10b981';
        row.setAttribute('data-status', 'active');
    } else {
        selectElement.style.borderColor = '#ef4444';
        selectElement.style.color = '#ef4444';
        row.setAttribute('data-status', 'suspend');
    }

    // Save to database via AJAX
    fetch(`/clinic/${clinicId}/status`, {
        method: 'PUT',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': '{{ csrf_token() }}'
        },
        body: JSON.stringify({ status: status })
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            console.log('Status updated successfully');
        } else {
            alert('Failed to update status: ' + data.message);
            // Revert the change
            selectElement.value = status === '1' ? '0' : '1';
            changeStatus(selectElement);
        }
    })
    .catch(error => {
        console.error('Error:', error);
        alert('An error occurred while updating status');
        // Revert the change
        selectElement.value = status === '1' ? '0' : '1';
        changeStatus(selectElement);
    });
}

function viewClinic(name, address, status) {
    document.getElementById('viewName').textContent = name;
    document.getElementById('viewAddress').textContent = address;
    new bootstrap.Modal(document.getElementById('viewModal')).show();
}

function deleteClinic(name, rowId) {
    document.getElementById('deleteName').textContent = name;
    currentRowId = rowId;
    new bootstrap.Modal(document.getElementById('deleteModal')).show();
}

function confirmDelete() {
    if (currentRowId) {
        const row = document.getElementById('row-' + currentRowId);
        if (row) {
            row.remove();
        }
    }
    alert('Clinic deleted successfully!');
    bootstrap.Modal.getInstance(document.getElementById('deleteModal')).hide();
    loadClinicsData(); // Reload data
}

</script>

@endsection
