@extends('partials.layouts.master')

@section('title', 'Medical Waste | FabKin Admin')
@section('title-sub', 'Cleaning')



@section('pagetitle')
    <div class="flex items-center space-x-2 text-sm font-medium">
        <span class="text-gray-500 hover:text-gray-700 transition duration-150">Home</span>
        <span class="text-gray-400">/</span>
        <span class="text-gray-500 hover:text-gray-700 transition duration-150">Clinics</span>
        <span class="text-gray-400">/</span>
        <span class="text-gray-500 hover:text-gray-700 transition duration-150">Moduls</span>
        <span class="text-gray-400">/</span>
        <span class="text-gray-900 font-bold">Cleaning</span>
    </div>
@endsection



@section('content')
<div class="container mt-4">
  <div class="p-4 bg-white rounded-1">
    <div class="border border-1 p-3 rounded-2">
      <div class="row g-3 p-3">
        
        <!-- Card 1 - Waste bags -->
        <div class="col-lg-4 col-md-4 col-sm-6">
          <div class="p-3 border rounded-1">
            <div class="bg-white rounded-xl overflow-hidden">
              <div class="h-48 overflow-hidden rounded-1">
                <img src="{{ asset('assets/images/clean.png') }}" alt="Waste bags" class="w-100 h-100">
              </div>
              <div class="p-4">
                <h5 class="text-lg font-semibold text-gray-900">All Cleaning</h5>
                <div class="border-bottom border-gray-200 mt-2 mb-4"></div>
                <a href="{{ route('All-cleaning') }}">
                  <button class="w-full py-3 text-white rounded-1 border-0" style="border-radius: 8px; border: 1px solid #FFF; background: var(--grad, linear-gradient(180deg, rgba(255, 255, 255, 0.12) 0%, rgba(255, 255, 255, 0.00) 100%), linear-gradient(180deg, #4598F9 0%, #3A77BF 100%)); box-shadow: 0 1px 2px 0 rgba(13, 13, 18, 0.06);">
                  View or Add All Cleaning
                  </button>
                </a>
              </div>
            </div>
          </div>
        </div>

        <!-- Card 2 - Waste Type -->
        <div class="col-lg-4 col-md-4 col-sm-6">
          <div class="p-3 border bg-white rounded-1">
            <div class="bg-white rounded-xl overflow-hidden">
              <div class="h-48 overflow-hidden rounded-1">
                <img src="{{ asset('assets/images/disinfection.png') }}" alt="Waste Type" class="w-100 h-100">
              </div>
              <div class="p-4">
                <h5 class="text-lg font-semibold text-gray-900">Cleaning Product</h5>
                <div class="border-bottom border-gray-200 mt-2 mb-4"></div>
                <a href="{{ route('Waste-Type') }}">
                  <button class="w-full py-3 text-white rounded-1 border-0" style="border-radius: 8px; border: 1px solid #FFF; background: var(--grad, linear-gradient(180deg, rgba(255, 255, 255, 0.12) 0%, rgba(255, 255, 255, 0.00) 100%), linear-gradient(180deg, #4598F9 0%, #3A77BF 100%)); box-shadow: 0 1px 2px 0 rgba(13, 13, 18, 0.06);">
                  View or Add Cleaning Product
                  </button>
                </a>
              </div>
            </div>
          </div>
        </div>

        <!-- Card 3 - Container Type -->
        <div class="col-lg-4 col-md-4 col-sm-6">
          <div class="p-3 border bg-white rounded-1">
            <div class="bg-white rounded-xl overflow-hidden">
              <div class="h-48 overflow-hidden rounded-1">
                <img src="{{ asset('assets/images/sterilization.png') }}" alt="Container Type" class="w-100 h-100">
              </div>
              <div class="p-4">
                <h5 class="text-lg font-semibold text-gray-900">Machines</h5>
                <div class="border-bottom border-gray-200 mt-2 mb-4"></div>
                <a href="{{ route('container-type') }}">
                  <button class="w-full py-3 text-white rounded-1 border-0" style="border-radius: 8px; border: 1px solid #FFF; background: var(--grad, linear-gradient(180deg, rgba(255, 255, 255, 0.12) 0%, rgba(255, 255, 255, 0.00) 100%), linear-gradient(180deg, #4598F9 0%, #3A77BF 100%)); box-shadow: 0 1px 2px 0 rgba(13, 13, 18, 0.06);">
                  View Machines
                  </button>
                </a>
              </div>
            </div>
          </div>
        </div>

      </div>
    </div>
  </div>
</div>
@endsection

@section('css')
<style>
  body {
    background-color: white !important;
  }
</style>
@endsection