@extends('partials.Layouts.master')
@section('title','Clinics| FabKin')
@section('title-sub', isset($clinic) ? 'Edit Clinic' : 'Add new clinic')
@section('pagetitle','')

<style>
    body {
        background-color: #ffffff !important;
    }
    .main-add-clinic {
        color: var(--Greyscale-900, #0D0D12);
/* Body/Medium/Medium */
font-family: "Inter Tight";
font-size: 14px;
font-style: normal;
font-weight: 500;
line-height: 150%; /* 21px */
letter-spacing: 0.28px;
    }
    .main-clinic {
        color: var(--Greyscale-400, #818898);
/* Body/Medium/Medium */
font-family: "Inter Tight";
font-size: 14px;
font-style: normal;
font-weight: 500;
line-height: 150%; /* 21px */
letter-spacing: 0.28px;
    }
    .save-change {
        border-radius: 8px;
border: 1px solid #FFF;
background: var(--grad, linear-gradient(180deg, rgba(255, 255, 255, 0.12) 0%, rgba(255, 255, 255, 0.00) 100%), linear-gradient(180deg, #4598F9 0%, #3A77BF 100%));
/* Shadow/XSmall */
box-shadow: 0 1px 2px 0 rgba(13, 13, 18, 0.06);
padding: 10px;
color: #ffffff;
    }
    .cancel {
        color: var(--Greyscale-900, #0D0D12);
text-align: center;
/* Body/Medium/Semibold */
font-family: "Inter Tight";
font-size: 14px;
font-style: normal;
font-weight: 600;
border: 1px solid var(--Greyscale-400, #81889859) !important;
line-height: 150%; /* 21px */
letter-spacing: 0.28px;
background-color: #ffffff;
border-color: #00000030;
border-radius: 8px; 
    }
    .clinic-detail {
        color: var(--Greyscale-900, #0D0D12);
/* Heading/H6 */
font-family: "Inter Tight";
font-size: 18px;
font-style: normal;
font-weight: 600;
line-height: 135%; /* 24.3px */
    }
    .clinic-admin {
        color: var(--Greyscale-900, #0D0D12);
/* Heading/H6 */
font-family: "Inter Tight";
font-size: 18px;
font-style: normal;
font-weight: 600;
line-height: 135%; /* 24.3px */
    }
</style>

@section('content')

<!-- Breadcrumb with Back Button - Yeh header ke neeche show hoga -->
<div class="d-flex align-items-center mb-4" style="gap: 12px;">

    <!-- Breadcrumb -->
    <div class="d-flex align-items-center" style="gap: 8px; font-size: 14px;">
        <span class="main-clinic">Clinics</span>
        <span class="main-clinic">/</span>
        <span class="main-add-clinic">{{ isset($clinic) ? 'Edit Clinic' : 'Add Clinic' }}</span>
    </div>
</div>


<div class="p-6 pb-24">
    <form action="{{ isset($clinic) ? route('clinic.update', $clinic->id) : route('clinic.store') }}" method="POST" id="clinicForm" class="bg-white rounded-4 border border-1">
        @csrf
        @if(isset($clinic))
            @method('PUT')
        @endif
        
        <!-- Clinic Details Section -->
         <div class="row">
            <div class="col-lg-4 col-md-6 col-sm-6">
            <div class="p-6">
           <h2 class="clinic-detail mb-6">Clinic Details</h2>
             </div>
            </div>

            <div class="col-lg-8 col-md-6 col-sm-6 p-6">
 <!-- Clinic Name -->
    <div class="mb-6">
        <label class="block text-sm text-gray-700 mb-2">
            Clinic Name <span class="text-red-500">*</span>
        </label>
        <input type="text" name="clinic_name" value="{{ old('clinic_name', isset($clinic) ? $clinic->clinic_name : '') }}"
               class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500 rounded-3" required>
    </div>

    <!-- Clinic Location -->
    <div class="mb-6">
        <label class="block text-sm text-gray-700 mb-2">
            Clinic Location <span class="text-red-500">*</span>
        </label>
        <input type="text" name="clinic_location" value="{{ old('clinic_location', isset($clinic) ? $clinic->clinic_location : '') }}"
               class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500 rounded-3" required>
    </div>

    <!-- Rooms -->
    <div class="w-full mb-6">
        <label class="block text-sm text-gray-700 mb-2">Rooms (<span id="roomCount">0</span>)</label>
        <button type="button" id="manageRoomsBtn"
            class="w-full bg-white px-4 py-2 border border-gray-300 rounded-3 hover:bg-gray-50"
            style="display: flex; align-items: center; justify-content: space-between;">
            <span class="text-gray-900">Manage Rooms</span>
               <span class="text-gray-600 text-lg">›</span>
        </button>
        <!-- Hidden input to store rooms as JSON -->
        <input type="hidden" name="rooms" id="roomsData">
    </div>

    <!-- Hospital Department -->
    <div class="w-full mb-6">
        <label class="block text-sm text-gray-700 mb-2">Hospital Departments (<span id="departmentCount">0</span>)</label>
        <button type="button" id="manageDepartmentsBtn"
            class="w-full bg-white px-4 py-2 border border-gray-300 rounded-3 hover:bg-gray-50"
            style="display: flex; align-items: center; justify-content: space-between;">
            <span class="text-gray-900">Manage Hospital Departments</span>
               <span class="text-gray-600 text-lg">›</span>
        </button>
        <!-- Hidden input to store departments as JSON -->
        <input type="hidden" name="departments" id="departmentsData">
    </div>

    <!-- Responsible Person -->
    <div class="w-full mb-6">
        <label class="block text-sm text-gray-700 mb-2">Responsible Persons (<span id="personCount">0</span>)</label>
        <button type="button" id="managePersonsBtn"
            class="w-full bg-white px-4 py-2 border border-gray-300 rounded-3 hover:bg-gray-50"
            style="display: flex; align-items: center; justify-content: space-between;">
            <span class="text-gray-900">Manage Responsible Persons</span>
                <span class="text-gray-600 text-lg">›</span>
        </button>
        <!-- Hidden input to store persons as JSON -->
        <input type="hidden" name="responsible_persons" id="personsData">
    </div>
            </div>
         </div>
   <!-- Clinic Details Section end -->

   <hr>

<!-- Clinic Admin Section -->
 
 <div class="row">
    <div class="col-lg-4 col-md-6 col-sm-6">
      <div class="p-6">
        <h2 class="mb-6 clinic-admin">Clinic Admin</h2>
      </div>  
    </div>

    <div class="col-lg-8 col-md-6 col-sm-6 p-6">
<!-- Name -->
    <div class="mb-6">
        <label class="block text-sm text-gray-700 mb-2">Name</label>
        <input type="text" name="admin_name" value="{{ old('admin_name', isset($clinic) ? $clinic->admin_name : '') }}"
               class="w-full px-3 py-2 border border-gray-300 rounded-3 focus:outline-none focus:ring-2 focus:ring-blue-500">
    </div>

    <!-- User Name -->
    <div class="mb-6">
        <label class="block text-sm text-gray-700 mb-2">User Name</label>
        <input type="text" name="username" value="{{ old('username', isset($clinic) ? $clinic->admin_username : '') }}"
               class="w-full px-3 py-2 border border-gray-300 rounded-3 focus:outline-none focus:ring-2 focus:ring-blue-500">
    </div>

    <!-- Password -->
     <div class="col-12">
            <label for="password" class="form-label" style="color: #00000082;">
                Password @if(isset($clinic))<small class="text-muted">(Leave blank to keep current password)</small>@else<span class="text-danger">*</span>@endif
            </label>
            <div class="input-group">
                <input type="password" name="password" class="form-control" id="password"
                    placeholder="Enter your password" {{ isset($clinic) ? '' : 'required' }}>
                <span class="input-group-text" id="togglePassword" style="cursor: pointer;">
                    <i class="bi bi-eye" id="eyeIcon"></i>
                </span>
            </div>
        </div>

    </div>
 </div>


<hr />

<!-- Clinic Moduls Section -->
<div class="row" style="margin-top: 30px;">
    <!-- Header -->
    <div class="col-lg-4 col-md-6 col-sm-6">
        <div class="p-6">
            <h2 style="color: #1f2937; font-size: 18px; font-weight: 600; margin: 0;">Clinic Modules</h2>
        </div>  
    </div>

    <!-- Access Level Section -->
    <div class="col-lg-8 col-md-6 col-sm-6 p-6">
        <div class="mb-3">
            <label class="form-label" style="color: #6b7280; font-size: 14px; font-weight: 500; display: block; margin-bottom: 12px;">Access level</label>
            
            <div class="access-level-container" style="padding: 20px; border: 1px solid #e5e7eb; border-radius: 8px; background-color: #ffffff; display: flex; justify-content: center;">
                <div style="display: flex; justify-content: center; width: 100%; max-width: 900px;">
                    <div class="row g-4" style="width: 100%; display: flex; justify-content: space-evenly;">
                        <!-- Cleaning -->
                        <div style="flex: 0 1 calc(33.333% - 10px); min-width: 150px;">
                            <div class="form-check" style="display: flex; align-items: center; gap: 8px;">
                                <input class="form-check-input" type="checkbox" value="Cleaning" id="accessCleaning" name="clinic_modules[]" style="margin: 0; width: 18px; height: 18px; cursor: pointer; flex-shrink: 0;">
                                <label class="form-check-label" for="accessCleaning" style="margin: 0; cursor: pointer; font-size: 14px;">
                                    Cleaning
                                </label>
                            </div>
                        </div>

                        <!-- Disinfection -->
                        <div style="flex: 0 1 calc(33.333% - 10px); min-width: 150px;">
                            <div class="form-check" style="display: flex; align-items: center; gap: 8px;">
                                <input class="form-check-input" type="checkbox" value="Disinfection" id="accessDisinfection" name="clinic_modules[]" style="margin: 0; width: 18px; height: 18px; cursor: pointer; flex-shrink: 0;">
                                <label class="form-check-label" for="accessDisinfection" style="margin: 0; cursor: pointer; font-size: 14px;">
                                    Disinfection
                                </label>
                            </div>
                        </div>

                        <!-- Sterilization -->
                        <div style="flex: 0 1 calc(33.333% - 10px); min-width: 150px;">
                            <div class="form-check" style="display: flex; align-items: center; gap: 8px;">
                                <input class="form-check-input" type="checkbox" value="Sterilization" id="accessSterilization" name="clinic_modules[]" style="margin: 0; width: 18px; height: 18px; cursor: pointer; flex-shrink: 0;">
                                <label class="form-check-label" for="accessSterilization" style="margin: 0; cursor: pointer; font-size: 14px;">
                                    Sterilization
                                </label>
                            </div>
                        </div>

                        <!-- Inventory -->
                        <div style="flex: 0 1 calc(33.333% - 10px); min-width: 150px;">
                            <div class="form-check" style="display: flex; align-items: center; gap: 8px;">
                                <input class="form-check-input" type="checkbox" value="Inventory" id="accessInventory" name="clinic_modules[]" style="margin: 0; width: 18px; height: 18px; cursor: pointer; flex-shrink: 0;">
                                <label class="form-check-label" for="accessInventory" style="margin: 0; cursor: pointer; font-size: 14px;">
                                    Inventory
                                </label>
                            </div>
                        </div>

                        <!-- Task -->
                        <div style="flex: 0 1 calc(33.333% - 10px); min-width: 150px;">
                            <div class="form-check" style="display: flex; align-items: center; gap: 8px;">
                                <input class="form-check-input" type="checkbox" value="Task" id="accessTask" name="clinic_modules[]" style="margin: 0; width: 18px; height: 18px; cursor: pointer; flex-shrink: 0;">
                                <label class="form-check-label" for="accessTask" style="margin: 0; cursor: pointer; font-size: 14px;">
                                    Task
                                </label>
                            </div>
                        </div>

                        <!-- Medical Waste -->
                        <div style="flex: 0 1 calc(33.333% - 10px); min-width: 150px;">
                            <div class="form-check" style="display: flex; align-items: center; gap: 8px;">
                                <input class="form-check-input" type="checkbox" value="Medical Waste" id="accessMedicalWaste" name="clinic_modules[]" style="margin: 0; width: 18px; height: 18px; cursor: pointer; flex-shrink: 0;">
                                <label class="form-check-label" for="accessMedicalWaste" style="margin: 0; cursor: pointer; font-size: 14px;">
                                    Medical Waste
                                </label>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


 <!-- Footer Buttons - Fixed at bottom right -->
<div class="fixed bottom-0 left-0 right-0 border-t rounded-4 bg-white" style="display: flex; justify-content: flex-end;">
    <div class="flex gap-3 px-6 py-4">
        <button type="button" onclick="window.history.back();" 
            class="px-6 py-2 cancel"
            onmouseover="" 
            onmouseout="">
            Cancel
        </button>
        <button type="submit" form="clinicForm"
            class="save-change" 
            onmouseover="" 
            onmouseout="">
            Save Change
        </button>
    </div>
</div>


    </form>
</div>

<!-- Room Management Modal -->
<div class="modal fade" id="roomModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Manage Rooms</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="mb-3">
                    <div class="input-group">
                        <input type="text" id="roomNameInput" class="form-control" placeholder="Enter room name">
                        <button class="btn btn-primary" id="addRoomBtn" style="background: linear-gradient(180deg, #4598F9 0%, #3A77BF 100%); border: none; color: white;">Add Room</button>
                    </div>
                </div>
                <table class="table">
                    <thead>
                        <tr>
                            <th>Room Name</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody id="roomTableBody"></tbody>
                </table>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>

<!-- Department Management Modal -->
<div class="modal fade" id="departmentModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Manage Hospital Departments</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="mb-3">
                    <div class="input-group">
                        <input type="text" id="departmentNameInput" class="form-control" placeholder="Enter department name">
                        <button class="btn btn-primary" id="addDepartmentBtn" style="background: linear-gradient(180deg, #4598F9 0%, #3A77BF 100%); border: none; color: white;">Add Department</button>
                    </div>
                </div>
                <table class="table">
                    <thead>
                        <tr>
                            <th>Department Name</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody id="departmentTableBody"></tbody>
                </table>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>

<!-- Responsible Person Management Modal -->
<div class="modal fade" id="personModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Manage Responsible Persons</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="mb-3">
                    <div class="row g-2">
                        <div class="col-md-3">
                            <input type="text" id="personNameInput" class="form-control" placeholder="Name" required>
                        </div>
                        <div class="col-md-3">
                            <input type="text" id="personUsernameInput" class="form-control" placeholder="Username" required>
                        </div>
                        <div class="col-md-2">
                            <input type="password" id="personPasswordInput" class="form-control" placeholder="Password" required>
                        </div>
                        <div class="col-md-2">
                            <select id="personRoleInput" class="form-control" required>
                                <option value="">Select Role</option>
                                <option value="Admin">Admin</option>
                                <option value="Manager">Manager</option>
                                <option value="User">User</option>
                            </select>
                        </div>
                        <div class="col-md-2">
                            <button class="btn btn-primary w-100" id="addPersonBtn" style="background: linear-gradient(180deg, #4598F9 0%, #3A77BF 100%); border: none; color: white;">Add</button>
                        </div>
                    </div>
                    <div class="row mt-2" id="accessLevelContainer" style="display:none;">
                        <div class="col-12">
                            <label class="form-label">Access Level:</label>
                            <div class="d-flex flex-wrap gap-2">
                                <div class="form-check">
                                    <input class="form-check-input access-level-checkbox" type="checkbox" value="cleaning" id="access_cleaning">
                                    <label class="form-check-label" for="access_cleaning">Cleaning</label>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input access-level-checkbox" type="checkbox" value="disinfection" id="access_disinfection">
                                    <label class="form-check-label" for="access_disinfection">Disinfection</label>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input access-level-checkbox" type="checkbox" value="sterilization" id="access_sterilization">
                                    <label class="form-check-label" for="access_sterilization">Sterilization</label>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input access-level-checkbox" type="checkbox" value="inventory" id="access_inventory">
                                    <label class="form-check-label" for="access_inventory">Inventory</label>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input access-level-checkbox" type="checkbox" value="task" id="access_task">
                                    <label class="form-check-label" for="access_task">Task</label>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input access-level-checkbox" type="checkbox" value="medical_waste" id="access_medical_waste">
                                    <label class="form-check-label" for="access_medical_waste">Medical Waste</label>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <table class="table">
                    <thead>
                        <tr>
                            <th>Name</th>
                            <th>Username</th>
                            <th>Role</th>
                            <th>Access Level</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody id="personTableBody"></tbody>
                </table>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>

   <script>
    document.addEventListener("DOMContentLoaded", function () {
        // Password toggle
        const passwordInput = document.getElementById("password");
        const togglePassword = document.getElementById("togglePassword");
        const eyeIcon = document.getElementById("eyeIcon");

        if(togglePassword) {
            togglePassword.addEventListener("click", () => {
                const type = passwordInput.getAttribute("type") === "password" ? "text" : "password";
                passwordInput.setAttribute("type", type);

                if (type === "password") {
                    eyeIcon.classList.remove("fa-eye-slash");
                    eyeIcon.classList.add("fa-eye");
                } else {
                    eyeIcon.classList.remove("fa-eye");
                    eyeIcon.classList.add("fa-eye-slash");
                }
            });
        }

        // ============ LOCAL STORAGE MANAGEMENT ============
        @if(isset($clinic))
            // Load clinic data for edit mode
            let rooms = {!! json_encode($clinic->rooms->pluck('name')->map(fn($name) => ['name' => $name])->toArray()) !!};
            let departments = {!! json_encode($clinic->departments->pluck('name')->map(fn($name) => ['name' => $name])->toArray()) !!};
            let persons = {!! json_encode($clinic->responsiblePersons->map(fn($person) => [
                'name' => $person->name,
                'username' => $person->username,
                'password' => '******',
                'role' => $person->role,
                'access_level' => json_decode($person->access_level) ?? []
            ])->toArray()) !!};

            // Pre-check clinic modules
            const clinicModules = {!! json_encode(json_decode($clinic->modul_access) ?? []) !!};
            clinicModules.forEach(module => {
                const checkbox = document.querySelector(`input[name="clinic_modules[]"][value="${module}"]`);
                if(checkbox) {
                    checkbox.checked = true;
                }
            });
        @else
            // Clear localStorage for new clinic
            localStorage.removeItem('clinic_rooms');
            localStorage.removeItem('clinic_departments');
            localStorage.removeItem('clinic_persons');

            let rooms = JSON.parse(localStorage.getItem('clinic_rooms') || '[]');
            let departments = JSON.parse(localStorage.getItem('clinic_departments') || '[]');
            let persons = JSON.parse(localStorage.getItem('clinic_persons') || '[]');
        @endif

        // Update counts on page load
        updateCounts();

        // ============ ROOM MANAGEMENT ============
        document.getElementById('manageRoomsBtn').addEventListener('click', function() {
            new bootstrap.Modal(document.getElementById('roomModal')).show();
            renderRooms();
        });

        document.getElementById('addRoomBtn').addEventListener('click', function() {
            const name = document.getElementById('roomNameInput').value.trim();
            if(!name) {
                alert('Please enter room name');
                return;
            }
            if(rooms.find(r => r.name === name)) {
                alert('Room already exists');
                return;
            }
            rooms.push({ name: name });
            @if(!isset($clinic))
            localStorage.setItem('clinic_rooms', JSON.stringify(rooms));
            @endif
            document.getElementById('roomNameInput').value = '';
            renderRooms();
            updateCounts();
        });

        function renderRooms() {
            const tbody = document.getElementById('roomTableBody');
            tbody.innerHTML = '';
            rooms.forEach((room, index) => {
                tbody.innerHTML += `
                    <tr>
                        <td>${room.name}</td>
                        <td>
                            <button class="btn btn-sm btn-danger" onclick="deleteRoom(${index})">Delete</button>
                        </td>
                    </tr>
                `;
            });
        }

        window.deleteRoom = function(index) {
            if(confirm('Delete this room?')) {
                rooms.splice(index, 1);
                @if(!isset($clinic))
                localStorage.setItem('clinic_rooms', JSON.stringify(rooms));
                @endif
                renderRooms();
                updateCounts();
            }
        };

        // ============ DEPARTMENT MANAGEMENT ============
        document.getElementById('manageDepartmentsBtn').addEventListener('click', function() {
            new bootstrap.Modal(document.getElementById('departmentModal')).show();
            renderDepartments();
        });

        document.getElementById('addDepartmentBtn').addEventListener('click', function() {
            const name = document.getElementById('departmentNameInput').value.trim();
            if(!name) {
                alert('Please enter department name');
                return;
            }
            if(departments.find(d => d.name === name)) {
                alert('Department already exists');
                return;
            }
            departments.push({ name: name });
            @if(!isset($clinic))
            localStorage.setItem('clinic_departments', JSON.stringify(departments));
            @endif
            document.getElementById('departmentNameInput').value = '';
            renderDepartments();
            updateCounts();
        });

        function renderDepartments() {
            const tbody = document.getElementById('departmentTableBody');
            tbody.innerHTML = '';
            departments.forEach((dept, index) => {
                tbody.innerHTML += `
                    <tr>
                        <td>${dept.name}</td>
                        <td>
                            <button class="btn btn-sm btn-danger" onclick="deleteDepartment(${index})">Delete</button>
                        </td>
                    </tr>
                `;
            });
        }

        window.deleteDepartment = function(index) {
            if(confirm('Delete this department?')) {
                departments.splice(index, 1);
                @if(!isset($clinic))
                localStorage.setItem('clinic_departments', JSON.stringify(departments));
                @endif
                renderDepartments();
                updateCounts();
            }
        };

        // ============ RESPONSIBLE PERSON MANAGEMENT ============
        document.getElementById('managePersonsBtn').addEventListener('click', function() {
            new bootstrap.Modal(document.getElementById('personModal')).show();
            renderPersons();
        });

        // Show/hide access level based on role
        document.getElementById('personRoleInput').addEventListener('change', function() {
            const accessContainer = document.getElementById('accessLevelContainer');
            if(this.value === 'Manager' || this.value === 'User') {
                accessContainer.style.display = 'block';
            } else {
                accessContainer.style.display = 'none';
            }
        });

        document.getElementById('addPersonBtn').addEventListener('click', function() {
            const name = document.getElementById('personNameInput').value.trim();
            const username = document.getElementById('personUsernameInput').value.trim();
            const password = document.getElementById('personPasswordInput').value.trim();
            const role = document.getElementById('personRoleInput').value;

            if(!name || !username || !password || !role) {
                alert('Please fill all fields');
                return;
            }

            if(persons.find(p => p.username === username)) {
                alert('Username already exists');
                return;
            }

            let accessLevel = [];
            if(role === 'Admin') {
                accessLevel = ['cleaning', 'disinfection', 'sterilization', 'inventory', 'task', 'medical_waste'];
            } else {
                document.querySelectorAll('.access-level-checkbox:checked').forEach(cb => {
                    accessLevel.push(cb.value);
                });
            }

            persons.push({
                name: name,
                username: username,
                password: password,
                role: role,
                access_level: accessLevel
            });

            @if(!isset($clinic))
            localStorage.setItem('clinic_persons', JSON.stringify(persons));
            @endif

            // Clear form
            document.getElementById('personNameInput').value = '';
            document.getElementById('personUsernameInput').value = '';
            document.getElementById('personPasswordInput').value = '';
            document.getElementById('personRoleInput').value = '';
            document.querySelectorAll('.access-level-checkbox').forEach(cb => cb.checked = false);
            document.getElementById('accessLevelContainer').style.display = 'none';

            renderPersons();
            updateCounts();
        });

        function renderPersons() {
            const tbody = document.getElementById('personTableBody');
            tbody.innerHTML = '';
            persons.forEach((person, index) => {
                tbody.innerHTML += `
                    <tr>
                        <td>${person.name}</td>
                        <td>${person.username}</td>
                        <td>${person.role}</td>
                        <td>${person.access_level.join(', ')}</td>
                        <td>
                            <button class="btn btn-sm btn-danger" onclick="deletePerson(${index})">Delete</button>
                        </td>
                    </tr>
                `;
            });
        }

        window.deletePerson = function(index) {
            if(confirm('Delete this person?')) {
                persons.splice(index, 1);
                @if(!isset($clinic))
                localStorage.setItem('clinic_persons', JSON.stringify(persons));
                @endif
                renderPersons();
                updateCounts();
            }
        };

        // ============ UPDATE COUNTS ============
        function updateCounts() {
            document.getElementById('roomCount').textContent = rooms.length;
            document.getElementById('departmentCount').textContent = departments.length;
            document.getElementById('personCount').textContent = persons.length;
        }

        // ============ FORM SUBMISSION ============
        document.getElementById('clinicForm').addEventListener('submit', function(e) {
            // Add data to hidden inputs before submission
            document.getElementById('roomsData').value = JSON.stringify(rooms);
            document.getElementById('departmentsData').value = JSON.stringify(departments);
            document.getElementById('personsData').value = JSON.stringify(persons);
        });

        // Clear localStorage after successful submission (optional)
        // You can add this after redirect if needed
    });
</script>

@endsection