@extends('partials.layouts.master')
@section('title', 'Waste Types - MediTrack')
@section('meta_description', 'Manage medical waste types for your clinic. Add, edit, and categorize different types of medical waste including surgical, biohazard, pharmaceutical, and chemical waste.')
@section('title-sub','Waste Type')
@section('pagetitle','')

@section('content')

<style>
    body {
        background-color: white !important;
    }

    .action-buttons {
    display: flex;
    gap: 8px;
    justify-content: flex-end;
}

.btn-action {
    background: none;
    border: none;
    padding: 6px;
    cursor: pointer;
    border-radius: 6px;
    transition: all 0.2s;
}

.btn-action.edit {
    background-color: #f0fbff;
    border: 1px solid #dee2e6;
}

.btn-action.delete {
    background-color: #fff0f3;
    border: 1px solid #dee2e6;
}

.btn-action:hover {
    opacity: 0.8;
    transform: scale(1.05);
}

    /* Custom Styles for Exact Design Match */
    .page-container {
        background-color: #f8f9fa;
        min-height: 100vh;
        padding: 20px;
    }
    
    .breadcrumb-custom {
        font-size: 14px;
        color: #6b7280;
        margin-bottom: 24px;
    }
    
    .breadcrumb-custom a {
        color: #6b7280;
        text-decoration: none;
    }
    
    .breadcrumb-custom a:hover {
        color: #374151;
    }
    
    .header-section {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 20px;
    }
    
    .page-title {
        font-size: 24px;
        font-weight: 600;
        color: #111827;
        margin: 0;
    }
    
    .btn-add-department {
        background-color: #3b82f6;
        color: white;
        border: none;
        padding: 10px 24px;
        border-radius: 8px;
        font-size: 14px;
        font-weight: 500;
    }
    
    .btn-add-department:hover {
        background-color: #2563eb;
    }
    
    .controls-section {
        background: white;
        border-radius: 12px;
        padding: 16px 20px;
        margin-bottom: 16px;
        display: flex;
        justify-content: space-between;
        align-items: center;
        box-shadow: 0 1px 3px rgba(0,0,0,0.1);
    }
    
    .search-box {
        position: relative;
        width: 300px;
    }
    
    .search-box input {
        width: 100%;
        padding: 8px 12px 8px 36px;
        border: 1px solid #e5e7eb;
        border-radius: 8px;
        font-size: 14px;
    }
    
    .search-box i {
        position: absolute;
        left: 12px;
        top: 50%;
        transform: translateY(-50%);
        color: #9ca3af;
    }
    
    .filter-sort-buttons {
        display: flex;
        gap: 8px;
    }
    
    .btn-filter, .btn-sort {
        background: white;
        border: 1px solid #e5e7eb;
        padding: 8px 16px;
        border-radius: 8px;
        font-size: 14px;
        color: #374151;
        display: flex;
        align-items: center;
        gap: 8px;
    }
    
    .btn-filter:hover, .btn-sort:hover {
        background-color: #f9fafb;
    }
    
    .table-container {
        background: white;
        border-radius: 12px;
        box-shadow: 0 1px 3px rgba(0,0,0,0.1);
        overflow: hidden;
    }
    
    .custom-table {
        width: 100%;
        margin: 0;
    }
    
    .custom-table thead {
        background-color: #f9fafb;
    }
    
    .custom-table thead th {
        padding: 16px 24px;
        font-size: 13px;
        font-weight: 600;
        color: #6b7280;
        text-transform: uppercase;
        letter-spacing: 0.5px;
        border-bottom: 1px solid #e5e7eb;
    }
    
    .custom-table tbody td {
        padding: 20px 24px;
        font-size: 14px;
        color: #111827;
        border-bottom: 1px solid #f3f4f6;
    }
    
    .custom-table tbody tr:hover {
        background-color: #f9fafb;
    }
    
    .custom-table tbody tr:last-child td {
        border-bottom: none;
    }
    
    .action-buttons {
        display: flex;
        gap: 4px;
        justify-content: flex-end;
    }
    
    .btn-action {
        background: none;
        border: none;
        padding: 4px;
        cursor: pointer;
        transition: all 0.2s;
    }
    
    .btn-action.view {
        color: #10b981;
    }
    
    .btn-action.edit {
        color: #3b82f6;
    }
    
    .btn-action.delete {
        color: #ef4444;
    }
    
    .btn-action:hover {
        opacity: 0.7;
        transform: scale(1.1);
    }
    
    .pagination-section {
        background: white;
        padding: 16px 24px;
        margin-top: 16px;
        display: flex;
        justify-content: space-between;
        align-items: center;
    }
    
    .pagination-info {
        font-size: 14px;
        color: #6b7280;
    }
    
    .pagination-controls {
        display: flex;
        align-items: center;
        gap: 20px;
    }
    
    .per-page-selector {
        display: flex;
        align-items: center;
        gap: 8px;
        font-size: 14px;
        color: #6b7280;
    }
    
    .per-page-selector select {
        padding: 4px 8px;
        border: 1px solid #e5e7eb;
        border-radius: 6px;
        font-size: 14px;
    }
    
    .pagination-buttons {
        display: flex;
        gap: 4px;
    }
    
    .page-btn {
        min-width: 36px;
        height: 36px;
        display: flex;
        align-items: center;
        justify-content: center;
        border: 1px solid #e5e7eb;
        background: white;
        border-radius: 6px;
        font-size: 14px;
        color: #374151;
        cursor: pointer;
        transition: all 0.2s;
    }
    
    .page-btn:hover:not(.active):not(.disabled) {
        background-color: #f9fafb;
    }
    
    .page-btn.active {
        background: linear-gradient(180deg, rgba(255, 255, 255, 0.12) 0%, rgba(255, 255, 255, 0.00) 100%), linear-gradient(180deg, #4598F9 0%, #3A77BF 100%); box-shadow: 0 1px 2px 0 rgba(13, 13, 18, 0.06); color: white; text-decoration: none;
        color: white;
        border-color: #3b82f6;
    }
    
    .page-btn.disabled {
        opacity: 0.5;
        cursor: not-allowed;
    }
    
    .modal-content {
        border-radius: 12px;
        border: none;
    }
    
    .modal-header {
        border-bottom: 1px solid #f3f4f6;
        padding: 20px 24px;
    }
    
    .modal-title {
        font-size: 18px;
        font-weight: 600;
        color: #111827;
    }
    
    .modal-body {
        padding: 24px;
    }
    
    .modal-footer {
        border-top: 1px solid #f3f4f6;
        padding: 16px 24px;
    }
    .btn-primary{
        background-color: #3b82f6 !important;
        color: #ffffff !important;
        border: none !important;
    }
    .btn-primary:hover{
        background-color: #3b82f6 !important;
    }
    /* extra code */
       .btn {
        font-size: 14px;
        font-weight: 500;
        border-color: #e5e7eb !important; /* Tailwind's gray-200 */
    }

    .btn:hover {
        color: #374151 !important; /* text-gray-700 */
        /* box-shadow: 0 2px 5px rgba(0,0,0,0.08) !important; */
    }

    .rounded-xl {
        border-radius: 12px !important;
    }

    .shadow-sm {
        box-shadow: 0 1px 3px rgba(0, 0, 0, 0.05) !important;
    }
    .main-home {
color: var(--Greyscale-900, #818898) !important;
/* Body/Medium/Medium */
font-family: "Inter Tight";
font-size: 14px;
font-style: normal;
font-weight: 500;
line-height: 150%; /* 21px */
letter-spacing: 0.28px; 
    }
    .main-clinics{
        color: var(--Greyscale-400, #0D0D12) !important;
/* Body/Medium/Medium */
font-family: "Inter Tight";
font-size: 14px;
font-style: normal;
font-weight: 500;
line-height: 150%; /* 21px */
letter-spacing: 0.28px;
    }
     .main-all-waste-type {
        color: var(--Greyscale-900, #0D0D12);
/* Body/Large/Semibold */
font-family: "Inter Tight";
font-size: 16px;
font-style: normal;
font-weight: 600;
line-height: 150%; /* 24px */
letter-spacing: 0.32px;
    }
    #updateDepartmentBtn:hover {
        color: #ffffff !important;
    }
    .DepartmentModal:hover {
        color: #ffffff !important;
    }
</style>

<div class="p-0 m-2">
    <!-- Top Section: Breadcrumb + Button -->
    <div class="d-flex justify-content-between align-items-center mb-0 pb-0">
        
        <!-- Breadcrumb -->
          <div class="flex items-center space-x-2 text-sm font-medium">
        <span class="main-home"><a href="{{ route('dashboard') }}" class="main-home">Home</a></span>
        <span class="main-home">/</span>
        <span class="main-home"><a href="{{ route('clinics') }}" class="main-home">Clinics</a></span>
       <span class="main-home">/</span>
        <span class="main-home"><a href="{{ route('moduls', ['clinic_id' => $clinic->id]) }}" class="main-home">Moduls</a></span>
         <span class="main-home">/</span>
          <span class="main-home"><a href="{{ route('Medical-Waste', ['clinic_id' => $clinic->id]) }}" class="main-home">Medical Waste</a></span>
         <span class="main-home">/</span>
        <span class="main-clinics">Waste Type</span>
    </div>

        <!-- Action Buttons -->
        <div class="d-flex gap-2">
            <a href="{{ route('Medical-Waste', ['clinic_id' => $clinic->id]) }}"
               class="btn px-4 py-2 mb-0"
               style="background: #f8f9fa; border: 1px solid #dee2e6; color: #374151; text-decoration: none;">
                <i class="bi bi-arrow-left me-1"></i>
                Back
            </a>
            <button type="button"
                    class="btn px-4 py-2 mb-0 DepartmentModal"
                    style="background: linear-gradient(180deg, rgba(255, 255, 255, 0.12) 0%, rgba(255, 255, 255, 0.00) 100%), linear-gradient(180deg, #4598F9 0%, #3A77BF 100%); box-shadow: 0 1px 2px 0 rgba(13, 13, 18, 0.06); color: white; text-decoration: none;"
                    data-bs-toggle="modal"
                    data-bs-target="#addDepartmentModal">
                Add Waste Type
            </button>
        </div>
    </div>
</div>

    <!-- Controls (Search, Filter, Sort) -->
     <div class="p-4">
     <div class="border border-1 p-4 rounded-4">

     
  <div class="d-flex justify-content-between align-items-center mb-3">
    <!-- Left side -->
    <div>
        <h6 class="main-all-waste-type mb-0">All Waste Type</h6>
    </div>

    <!-- Right side -->
    <div class="d-flex align-items-cente">
        <!-- Search Box -->
        <div class="search-box d-flex align-items-center me-1">
            <i class="bi bi-search "></i>
            <input type="text" id="searchInput" placeholder="Search" class="form-control form-control-sm">
        </div>

        <!-- Filter & Sort Buttons -->
<!-- <div class="d-flex align-items-center space-x-2"> -->
    <!-- Filter Button -->
    <!-- <button type="button" class="btn me-1 bg-white border text-gray-600 d-flex align-items-center shadow-sm rounded-xl hover:bg-gray-50 transition px-3 py-2">
        <i class="bi bi-funnel me-1 text-gray-500"></i>
        Filter
    </button> -->

    <!-- Sort Button -->
    <!-- <button type="button" class="btn bg-white border text-gray-600 d-flex align-items-center shadow-sm rounded-xl hover:bg-gray-50 transition px-3 py-2">
        <i class="bi bi-arrow-down-up me-1 text-gray-500"></i>
        Sort by
    </button>
</div> -->

    </div>
</div>


    <!-- Table -->
    <div class="table">
        <table class=" table">
         <thead>
    <tr class="bg-light">
        <th class="heading-name" style="border-right: 1px solid #e5e7eb; border-right: none;">
            Waste Type
        </th>
        <th class="heading-actions" style="text-align: right; border-left: none;">
            Actions
        </th>
    </tr>
</thead>
            <tbody id="departmentTableBody">
                @forelse($wasteTypes as $wasteType)
                <tr data-name="{{ $wasteType->name }}" data-id="{{ $wasteType->id }}" data-status="{{ $wasteType->status ? 'active' : 'inactive' }}">
                    <td>{{ $wasteType->name }}</td>
                    <td>
                        <div class="action-buttons">
                            <button class="btn-action view view-btn me-1" title="View" data-id="{{ $wasteType->id }}">
                            </button>
                            <button class="btn-action edit edit-btn" title="Edit" style="width:29px" data-id="{{ $wasteType->id }}">
                                <i class="bi bi-pencil" style="font-size: 14px; color: #33cfff;"></i>
                            </button>
                            <button class="btn-action delete delete-btn" title="Delete" style="width:29px" data-id="{{ $wasteType->id }}">
                                <i class="bi bi-trash" style="font-size: 14px;"></i>
                            </button>
                        </div>
                    </td>
                </tr>
                @empty
                <tr id="noDataRow">
                    <td colspan="2" class="text-center py-4 text-muted">No waste types found. Add your first waste type!</td>
                </tr>
                @endforelse
            </tbody>
        </table>
    </div>

    <!-- Pagination -->
    <div class="pagination-section bg-white">
        <div class="pagination-info">
            Showing <span id="showingStart">1</span> to <span id="showingEnd">10</span> of <span id="totalResults">500</span> results
        </div>
        
        <div class="pagination-controls">
            <div class="per-page-selector">
                <span>Per page:</span>
                <select id="perPageSelect">
                    <option value="10" selected>10</option>
                    <option value="25">25</option>
                    <option value="50">50</option>
                    <option value="100">100</option>
                </select>
            </div>
            
            <div class="pagination-buttons">
                <button class="page-btn disabled" id="prevBtn">
                    <i class="bi bi-chevron-left"></i>
                </button>
                <button class="page-btn" data-page="1">1</button>
                <button class="page-btn" data-page="2">2</button>
                <button class="page-btn active" data-page="3">3</button>
                <button class="page-btn disabled">...</button>
                <button class="page-btn" data-page="5">5</button>
                <button class="page-btn" id="nextBtn">
                    <i class="bi bi-chevron-right"></i>
                </button>
            </div>
        </div>
    </div>
</div>
</div>

<!-- Add Department Modal -->
<div class="modal fade" id="addDepartmentModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Add Room</h5>
                <button type="button" data-bs-dismiss="modal" style="width: 36px; height: 36px; border-radius: 50%; border: 1px solid #D1D5DB; background-color: white; display: flex; align-items: center; justify-content: center; padding: 0; cursor: pointer; position: absolute; right: 20px; top: 20px;" onmouseover="this.style.backgroundColor='#f9fafb'" onmouseout="this.style.backgroundColor='white'">
                    <i class="bi bi-x" style="font-size: 20px; color: #000; font-weight: bold;"></i>
                </button>    
            </div>
            <div class="modal-body">
                <form id="addDepartmentForm">
                    <div class="mb-3">
                        <label class="form-label">Room Name <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" id="departmentName" placeholder="Name" required>
                    </div>
                </form>
            </div>
           <div style="display: flex; justify-content: flex-end; gap: 10px; padding: 15px 20px;">
    <button type="button" class="btn" data-bs-dismiss="modal" style="background-color: #f8f9fa; border: 1px solid #dee2e6;">
        Cancel
    </button>
    <button type="button" class="btn btn-primary" id="saveDepartmentBtn"
        style="background: linear-gradient(180deg, rgba(255, 255, 255, 0.12) 0%, rgba(255, 255, 255, 0.00) 100%), 
               linear-gradient(180deg, #4598F9 0%, #3A77BF 100%);
               box-shadow: 0 1px 2px 0 rgba(13, 13, 18, 0.06);
               text-decoration: none; border: none; color: white !important;">
        Save
    </button>
</div>

        </div>
    </div>
</div>

<!-- Edit Department Modal -->
<div class="modal fade" id="editDepartmentModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="p-4">
                <h5 class="modal-title">Edit Hospital Department</h5>
                  <button type="button" data-bs-dismiss="modal" style="width: 36px; height: 36px; border-radius: 50%; border: 1px solid #D1D5DB; background-color: white; display: flex; align-items: center; justify-content: center; padding: 0; cursor: pointer; position: absolute; right: 20px; top: 20px;" onmouseover="this.style.backgroundColor='#f9fafb'" onmouseout="this.style.backgroundColor='white'">
                    <i class="bi bi-x" style="font-size: 20px; color: #000; font-weight: bold;"></i>
                </button>                
            </div>
            <div class="modal-body">
                <form id="editDepartmentForm">
                    <div class="mb-3">
                        <label class="form-label">Department Name <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" id="editDepartmentName" required>
                    </div>
                </form>
            </div>

            <div style="display: flex; justify-content: flex-end; gap: 10px; padding: 15px 20px 20px 20px; border-top: none;">
    <button type="button" class="btn" data-bs-dismiss="modal" style="background-color: #f8f9fa;">
        Cancel
    </button>
    <button type="button" class="btn btn-primary" id="updateDepartmentBtn" style=" background: linear-gradient(180deg, rgba(255, 255, 255, 0.12) 0%, rgba(255, 255, 255, 0.00) 100%), linear-gradient(180deg, #4598F9 0%, #3A77BF 100%); box-shadow: 0 1px 2px 0 rgba(13, 13, 18, 0.06); color: white; text-decoration: none;
 border: none;">
        Update
    </button>
</div>

        </div>
    </div>
</div>

<!-- View Department Modal -->
<div class="modal fade" id="viewDepartmentModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Department Details</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="mb-3">
                    <label class="form-label text-muted">Department Name</label>
                    <p class="fw-bold" id="viewDepartmentName" style="font-size: 16px; color: #111827;"></p>
                </div>
                <div class="mb-3">
                    <label class="form-label text-muted">Created Date</label>
                    <p class="fw-bold" style="font-size: 16px; color: #111827;">October 10, 2025</p>
                </div>
                <div class="mb-3">
                    <label class="form-label text-muted">Status</label>
                    <p><span class="badge bg-success">Active</span></p>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>

<!-- Success Dialog Modal -->
<div class="modal fade" id="successModal" tabindex="-1" data-bs-backdrop="static" data-bs-keyboard="false">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content" style="border-radius: 16px; border: none; box-shadow: 0 4px 20px rgba(0,0,0,0.15);">
            <div class="modal-body text-center p-5">
                <div class="mb-3">
                    <div style="width: 80px; height: 80px; background: #d1fae5; border-radius: 50%; display: flex; align-items: center; justify-content: center; margin: 0 auto;">
                        <i class="bi bi-check-circle-fill" style="font-size: 48px; color: #10b981;"></i>
                    </div>
                </div>
                <h4 class="mb-2" style="color: #111827; font-weight: 600;">Success!</h4>
                <p id="successMessage" class="mb-4" style="color: #6b7280; font-size: 16px;"></p>
                <button type="button" class="btn btn-primary px-5" style="background: linear-gradient(180deg, rgba(255, 255, 255, 0.12) 0%, rgba(255, 255, 255, 0.00) 100%), linear-gradient(180deg, #4598F9 0%, #3A77BF 100%); box-shadow: 0 1px 2px 0 rgba(13, 13, 18, 0.06); border: none; border-radius: 8px;" data-bs-dismiss="modal">
                    OK
                </button>
            </div>
        </div>
    </div>
</div>

<!-- Error Dialog Modal -->
<div class="modal fade" id="errorModal" tabindex="-1" data-bs-backdrop="static" data-bs-keyboard="false">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content" style="border-radius: 16px; border: none; box-shadow: 0 4px 20px rgba(0,0,0,0.15);">
            <div class="modal-body text-center p-5">
                <div class="mb-3">
                    <div style="width: 80px; height: 80px; background: #fee2e2; border-radius: 50%; display: flex; align-items: center; justify-content: center; margin: 0 auto;">
                        <i class="bi bi-x-circle-fill" style="font-size: 48px; color: #ef4444;"></i>
                    </div>
                </div>
                <h4 class="mb-2" style="color: #111827; font-weight: 600;">Error!</h4>
                <p id="errorMessage" class="mb-4" style="color: #6b7280; font-size: 16px;"></p>
                <button type="button" class="btn btn-danger px-5" style="background: #ef4444; border: none; border-radius: 8px;" data-bs-dismiss="modal">
                    Close
                </button>
            </div>
        </div>
    </div>
</div>

</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const clinicId = {{ $clinic->id }};
    const csrfToken = '{{ csrf_token() }}';
    let allDepartments = [];
    let currentSortOrder = 'asc';
    let currentFilter = 'all';
    
    // ============ UPDATE MODAL TITLES AND LABELS ============
    
    // Update Add Modal
    const addModalTitle = document.querySelector('#addDepartmentModal .modal-title');
    if(addModalTitle) {
        addModalTitle.textContent = 'Add Waste Type';
    }
    
    const addModalLabel = document.querySelector('#addDepartmentModal .form-label');
    if(addModalLabel) {
        addModalLabel.innerHTML = 'Waste Name <span class="text-danger">*</span>';
    }
    
    const addModalInput = document.getElementById('departmentName');
    if(addModalInput) {
        addModalInput.placeholder = 'Name';
    }
    
    // Update Edit Modal
    const editModalTitle = document.querySelector('#editDepartmentModal .modal-title');
    if(editModalTitle) {
        editModalTitle.textContent = 'Edit Waste Type';
    }
    
    const editModalLabel = document.querySelector('#editDepartmentModal .form-label');
    if(editModalLabel) {
        editModalLabel.innerHTML = 'Waste Name <span class="text-danger">*</span>';
    }
    
    const editModalInput = document.getElementById('editDepartmentName');
    if(editModalInput) {
        editModalInput.placeholder = 'Name';
    }
    
    // Update View Modal
    const viewModalTitle = document.querySelector('#viewDepartmentModal .modal-title');
    if(viewModalTitle) {
        viewModalTitle.textContent = 'Waste Details';
    }
    
    const viewModalLabel = document.querySelector('#viewDepartmentModal .form-label');
    if(viewModalLabel) {
        viewModalLabel.textContent = 'Waste Name';
    }
    
    // Initialize departments from table
    function initializeDepartments() {
        allDepartments = [];
        document.querySelectorAll('#departmentTableBody tr').forEach(row => {
            const name = row.getAttribute('data-name');
            if(name) {
                allDepartments.push(name);
            }
        });
    }
    
    initializeDepartments();

    // ============ CUSTOM DIALOG FUNCTIONS ============

    function showSuccessDialog(message) {
        document.getElementById('successMessage').textContent = message;
        const successModal = new bootstrap.Modal(document.getElementById('successModal'));
        successModal.show();
    }

    function showErrorDialog(message) {
        document.getElementById('errorMessage').textContent = message;
        const errorModal = new bootstrap.Modal(document.getElementById('errorModal'));
        errorModal.show();
    }

    // ============ FILTER & SORT DROPDOWNS ============
    
    // Create Filter Dropdown - NO COLORS
    function createFilterDropdown() {
        const filterBtn = document.querySelector('button i.bi-funnel')?.closest('button');
        if(!filterBtn) return;
        
        // Check if dropdown already exists
        if(filterBtn.hasAttribute('data-dropdown-initialized')) return;
        filterBtn.setAttribute('data-dropdown-initialized', 'true');
        
        // Create dropdown menu
        const dropdownMenu = document.createElement('div');
        dropdownMenu.className = 'dropdown-menu shadow-sm';
        dropdownMenu.style.cssText = 'min-width: 150px; background: white; border: 1px solid #e0e0e0;';
        dropdownMenu.innerHTML = `
            <a class="dropdown-item filter-option" href="#" data-filter="all" style="color: #333; background: white !important;">
                All Waste Type
            </a>
            <a class="dropdown-item filter-option" href="#" data-filter="active" style="color: #333; background: white !important;">
                Active
            </a>
            <a class="dropdown-item filter-option" href="#" data-filter="inactive" style="color: #333; background: white !important;">
                Inactive
            </a>
        `;
        
        // Remove all Bootstrap hover colors
        const style = document.createElement('style');
        style.textContent = `
            .dropdown-item.filter-option:hover,
            .dropdown-item.filter-option:focus,
            .dropdown-item.filter-option:active {
                background-color: #f5f5f5 !important;
                color: #333 !important;
            }
            .dropdown-item.filter-option.active {
                background-color: #e8e8e8 !important;
                color: #333 !important;
                font-weight: 500;
            }
        `;
        document.head.appendChild(style);
        
        // Make button a dropdown
        filterBtn.setAttribute('data-bs-toggle', 'dropdown');
        filterBtn.setAttribute('data-bs-auto-close', 'true');
        
        // Wrap in dropdown div
        const dropdownDiv = document.createElement('div');
        dropdownDiv.className = 'dropdown d-inline-block';
        filterBtn.parentNode.insertBefore(dropdownDiv, filterBtn);
        dropdownDiv.appendChild(filterBtn);
        dropdownDiv.appendChild(dropdownMenu);
        
        // Add click events to filter options
        dropdownMenu.querySelectorAll('.filter-option').forEach(option => {
            option.addEventListener('click', function(e) {
                e.preventDefault();
                const filterValue = this.getAttribute('data-filter');
                currentFilter = filterValue;
                applyFilter(filterValue);
                
                // Update button text
                const btnText = this.textContent.trim();
                filterBtn.innerHTML = `
                    <i class="bi bi-funnel me-1 text-gray-500"></i>
                    ${btnText}
                `;
            });
        });
        
        // Reset visual state when dropdown opens
        filterBtn.addEventListener('show.bs.dropdown', function() {
            dropdownMenu.querySelectorAll('.filter-option').forEach(opt => {
                opt.style.backgroundColor = 'white';
                opt.style.fontWeight = 'normal';
            });
        });
    }
    
    // Create Sort Dropdown - NO COLORS
    function createSortDropdown() {
        const sortBtn = document.querySelector('button i.bi-arrow-down-up')?.closest('button');
        if(!sortBtn) return;
        
        // Check if dropdown already exists
        if(sortBtn.hasAttribute('data-dropdown-initialized')) return;
        sortBtn.setAttribute('data-dropdown-initialized', 'true');
        
        // Create dropdown menu
        const dropdownMenu = document.createElement('div');
        dropdownMenu.className = 'dropdown-menu shadow-sm';
        dropdownMenu.style.cssText = 'min-width: 150px; background: white; border: 1px solid #e0e0e0;';
        dropdownMenu.innerHTML = `
            <a class="dropdown-item sort-option" href="#" data-sort="asc" style="color: #333; background: white !important;">
                A to Z
            </a>
            <a class="dropdown-item sort-option" href="#" data-sort="desc" style="color: #333; background: white !important;">
                Z to A
            </a>
        `;
        
        // Remove all Bootstrap hover colors
        const style = document.createElement('style');
        style.textContent = `
            .dropdown-item.sort-option:hover,
            .dropdown-item.sort-option:focus,
            .dropdown-item.sort-option:active {
                background-color: #f5f5f5 !important;
                color: #333 !important;
            }
            .dropdown-item.sort-option.active {
                background-color: #e8e8e8 !important;
                color: #333 !important;
                font-weight: 500;
            }
        `;
        document.head.appendChild(style);
        
        // Make button a dropdown
        sortBtn.setAttribute('data-bs-toggle', 'dropdown');
        sortBtn.setAttribute('data-bs-auto-close', 'true');
        
        // Wrap in dropdown div
        const dropdownDiv = document.createElement('div');
        dropdownDiv.className = 'dropdown d-inline-block';
        sortBtn.parentNode.insertBefore(dropdownDiv, sortBtn);
        dropdownDiv.appendChild(sortBtn);
        dropdownDiv.appendChild(dropdownMenu);
        
        // Add click events to sort options
        dropdownMenu.querySelectorAll('.sort-option').forEach(option => {
            option.addEventListener('click', function(e) {
                e.preventDefault();
                const sortValue = this.getAttribute('data-sort');
                currentSortOrder = sortValue;
                sortTable(sortValue);
                
                // Update button text
                const btnText = this.textContent.trim();
                sortBtn.innerHTML = `
                    <i class="bi bi-arrow-down-up me-1 text-gray-500"></i>
                    ${btnText}
                `;
            });
        });
        
        // Reset visual state when dropdown opens
        sortBtn.addEventListener('show.bs.dropdown', function() {
            dropdownMenu.querySelectorAll('.sort-option').forEach(opt => {
                opt.style.backgroundColor = 'white';
                opt.style.fontWeight = 'normal';
            });
        });
    }
    
    // Initialize dropdowns
    createFilterDropdown();
    createSortDropdown();
    
    // ============ FILTER FUNCTIONALITY ============
    
    function applyFilter(filterValue) {
        const rows = document.querySelectorAll('#departmentTableBody tr');

        rows.forEach(row => {
            const searchInput = document.getElementById('searchInput');
            const searchTerm = searchInput ? searchInput.value.toLowerCase() : '';
            const name = row.getAttribute('data-name');
            if(!name) return;

            const nameLower = name.toLowerCase();
            const matchesSearch = nameLower.includes(searchTerm);

            // Initially set all rows to visible for filtering
            row.style.display = '';

            if(filterValue === 'all') {
                if(!matchesSearch) {
                    row.style.display = 'none';
                }
            } else {
                const status = row.getAttribute('data-status') || 'active';
                if(status !== filterValue || !matchesSearch) {
                    row.style.display = 'none';
                }
            }
        });

        // Reset to page 1 and re-paginate
        currentPage = 1;
        paginateTable();
    }
    
    // ============ SORT FUNCTIONALITY ============
    
    function sortTable(order) {
        const tbody = document.getElementById('departmentTableBody');
        if(!tbody) return;

        const rows = Array.from(tbody.querySelectorAll('tr'));

        rows.sort((a, b) => {
            const nameA = (a.getAttribute('data-name') || '').toLowerCase();
            const nameB = (b.getAttribute('data-name') || '').toLowerCase();

            if(order === 'asc') {
                return nameA.localeCompare(nameB);
            } else {
                return nameB.localeCompare(nameA);
            }
        });

        // Clear and re-append sorted rows
        tbody.innerHTML = '';
        rows.forEach(row => {
            tbody.appendChild(row);
            attachRowEvents(row);
        });

        // Re-apply current filter and pagination
        applyFilter(currentFilter);
    }
    
    // ============ SEARCH FUNCTIONALITY ============
    
    const searchInput = document.getElementById('searchInput');
    if(searchInput) {
        searchInput.addEventListener('input', function(e) {
            applyFilter(currentFilter);
        });
    }
    
    // ============ ADD WASTE TYPE ============

    const saveBtn = document.getElementById('saveDepartmentBtn');
    if(saveBtn) {
        saveBtn.addEventListener('click', function() {
            const nameInput = document.getElementById('departmentName');
            if(!nameInput) return;

            const name = nameInput.value.trim();

            if(!name) {
                showErrorDialog('Please enter Waste Type name');
                return;
            }

            // Send AJAX request to backend
            fetch(`/moduls/${clinicId}/medical-waste/waste-type/store`, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': csrfToken,
                    'Accept': 'application/json'
                },
                body: JSON.stringify({ name: name })
            })
            .then(response => response.json())
            .then(data => {
                if(data.success) {
                    // Hide the add modal first
                    const addModal = document.getElementById('addDepartmentModal');
                    if(addModal) {
                        const modal = bootstrap.Modal.getInstance(addModal);
                        if(modal) modal.hide();
                    }

                    const tbody = document.getElementById('departmentTableBody');
                    if(!tbody) return;

                    // Remove "no data" row if it exists
                    const noDataRow = document.getElementById('noDataRow');
                    if(noDataRow) {
                        noDataRow.remove();
                    }

                    const newRow = document.createElement('tr');
                    newRow.setAttribute('data-name', data.wasteType.name);
                    newRow.setAttribute('data-id', data.wasteType.id);
                    newRow.setAttribute('data-status', 'active');
                    newRow.innerHTML = `
                        <td>${data.wasteType.name}</td>
                        <td>
                            <div class="action-buttons">
                                <button class="btn-action view view-btn me-1" title="View" data-id="${data.wasteType.id}">
                                </button>
                                <button class="btn-action edit edit-btn" title="Edit" style="width:29px" data-id="${data.wasteType.id}">
                                    <i class="bi bi-pencil" style="font-size: 14px; color: #33cfff;"></i>
                                </button>
                                <button class="btn-action delete delete-btn" title="Delete" style="width:29px" data-id="${data.wasteType.id}">
                                    <i class="bi bi-trash" style="font-size: 14px;"></i>
                                </button>
                            </div>
                        </td>
                    `;

                    tbody.insertBefore(newRow, tbody.firstChild);
                    attachRowEvents(newRow);
                    allDepartments.unshift(data.wasteType.name);

                    nameInput.value = '';

                    // Refresh pagination
                    currentPage = 1; // Reset to first page to show new item
                    paginateTable();

                    // Show success dialog
                    showSuccessDialog(data.message || 'Waste type created successfully!');
                } else {
                    showErrorDialog(data.message || 'Failed to add waste type');
                }
            })
            .catch(error => {
                console.error('Error:', error);
                showErrorDialog('An error occurred while adding waste type');
            });
        });
    }
    
    // ============ VIEW WASTE TYPE ============
    
    function viewDepartment(row) {
        const name = row.getAttribute('data-name');
        const viewNameElement = document.getElementById('viewDepartmentName');
        if(viewNameElement && name) {
            viewNameElement.textContent = name;
        }
        const viewModal = document.getElementById('viewDepartmentModal');
        if(viewModal) {
            new bootstrap.Modal(viewModal).show();
        }
    }
    
    // ============ EDIT WASTE TYPE ============

    function editDepartment(row) {
        const name = row.getAttribute('data-name');
        const id = row.getAttribute('data-id');
        const editNameInput = document.getElementById('editDepartmentName');
        if(editNameInput && name) {
            editNameInput.value = name;
        }

        // Store current waste type ID for updating
        const editModal = document.getElementById('editDepartmentModal');
        if(editModal) {
            editModal.setAttribute('data-editing-id', id);
            new bootstrap.Modal(editModal).show();
        }
    }
    
    // ============ UPDATE WASTE TYPE ============

    const updateBtn = document.getElementById('updateDepartmentBtn');
    if(updateBtn) {
        updateBtn.addEventListener('click', function() {
            const editNameInput = document.getElementById('editDepartmentName');
            if(!editNameInput) return;

            const newName = editNameInput.value.trim();

            if(!newName) {
                showErrorDialog('Please enter waste name');
                return;
            }

            const editModal = document.getElementById('editDepartmentModal');
            if(!editModal) return;

            const id = editModal.getAttribute('data-editing-id');

            // Send AJAX request to backend
            fetch(`/moduls/${clinicId}/medical-waste/waste-type/${id}`, {
                method: 'PUT',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': csrfToken,
                    'Accept': 'application/json'
                },
                body: JSON.stringify({ name: newName })
            })
            .then(response => response.json())
            .then(data => {
                if(data.success) {
                    // Hide the edit modal first
                    const modal = bootstrap.Modal.getInstance(editModal);
                    if(modal) modal.hide();

                    // Find and update the row
                    const row = document.querySelector(`#departmentTableBody tr[data-id="${id}"]`);
                    if(row) {
                        const oldName = row.getAttribute('data-name');

                        const index = allDepartments.indexOf(oldName);
                        if(index > -1) {
                            allDepartments[index] = newName;
                        }

                        row.setAttribute('data-name', newName);
                        const firstTd = row.querySelector('td');
                        if(firstTd) {
                            firstTd.textContent = newName;
                        }
                    }

                    // Show success dialog
                    showSuccessDialog(data.message || 'Waste type updated successfully!');
                } else {
                    showErrorDialog(data.message || 'Failed to update waste type');
                }
            })
            .catch(error => {
                console.error('Error:', error);
                showErrorDialog('An error occurred while updating waste type');
            });
        });
    }

    // ============ DELETE WASTE TYPE ============

    function deleteDepartment(row) {
        if(confirm('Are you sure you want to delete this Waste Type?')) {
            const id = row.getAttribute('data-id');
            const name = row.getAttribute('data-name');

            // Send AJAX request to backend
            fetch(`/moduls/${clinicId}/medical-waste/waste-type/${id}`, {
                method: 'DELETE',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': csrfToken,
                    'Accept': 'application/json'
                }
            })
            .then(response => response.json())
            .then(data => {
                if(data.success) {
                    const index = allDepartments.indexOf(name);
                    if(index > -1) {
                        allDepartments.splice(index, 1);
                    }

                    row.remove();

                    // Check if table is now empty
                    const tbody = document.getElementById('departmentTableBody');
                    const remainingRows = tbody.querySelectorAll('tr[data-name]');

                    if(remainingRows.length === 0) {
                        const noDataRow = document.createElement('tr');
                        noDataRow.id = 'noDataRow';
                        noDataRow.innerHTML = '<td colspan="2" class="text-center py-4 text-muted">No waste types found. Add your first waste type!</td>';
                        tbody.appendChild(noDataRow);
                    }

                    // Refresh pagination
                    paginateTable();

                    // Show success dialog
                    showSuccessDialog(data.message || 'Waste type deleted successfully!');
                } else {
                    showErrorDialog(data.message || 'Failed to delete waste type');
                }
            })
            .catch(error => {
                console.error('Error:', error);
                showErrorDialog('An error occurred while deleting waste type');
            });
        }
    }
    
    // ============ ATTACH EVENTS ============
    
    function attachRowEvents(row) {
        const viewBtn = row.querySelector('.view-btn');
        const editBtn = row.querySelector('.edit-btn');
        const deleteBtn = row.querySelector('.delete-btn');
        
        if(viewBtn) {
            // Remove old event listeners
            const newViewBtn = viewBtn.cloneNode(true);
            viewBtn.parentNode.replaceChild(newViewBtn, viewBtn);
            newViewBtn.addEventListener('click', () => viewDepartment(row));
        }
        
        if(editBtn) {
            // Remove old event listeners
            const newEditBtn = editBtn.cloneNode(true);
            editBtn.parentNode.replaceChild(newEditBtn, editBtn);
            newEditBtn.addEventListener('click', () => editDepartment(row));
        }
        
        if(deleteBtn) {
            // Remove old event listeners
            const newDeleteBtn = deleteBtn.cloneNode(true);
            deleteBtn.parentNode.replaceChild(newDeleteBtn, deleteBtn);
            newDeleteBtn.addEventListener('click', () => deleteDepartment(row));
        }
    }
    
    // Attach events to existing rows
    document.querySelectorAll('#departmentTableBody tr').forEach(row => {
        attachRowEvents(row);
    });
    
    // ============ PAGINATION ============

    let currentPage = 1;
    let itemsPerPage = 10;

    function getVisibleRows() {
        const rows = Array.from(document.querySelectorAll('#departmentTableBody tr[data-name]'));
        return rows.filter(row => row.style.display !== 'none');
    }

    function updatePaginationInfo() {
        const visibleRows = getVisibleRows();
        const totalItems = visibleRows.length;
        const showingStart = totalItems > 0 ? ((currentPage - 1) * itemsPerPage) + 1 : 0;
        const showingEnd = Math.min(currentPage * itemsPerPage, totalItems);

        document.getElementById('showingStart').textContent = showingStart;
        document.getElementById('showingEnd').textContent = showingEnd;
        document.getElementById('totalResults').textContent = totalItems;
    }

    function renderPaginationButtons() {
        const visibleRows = getVisibleRows();
        const totalItems = visibleRows.length;
        const totalPages = Math.ceil(totalItems / itemsPerPage);

        const paginationContainer = document.querySelector('.pagination-buttons');
        if(!paginationContainer) return;

        // Clear existing buttons except prev/next
        const existingButtons = paginationContainer.querySelectorAll('.page-btn:not(#prevBtn):not(#nextBtn)');
        existingButtons.forEach(btn => btn.remove());

        // Get prev and next buttons
        const prevBtn = document.getElementById('prevBtn');
        const nextBtn = document.getElementById('nextBtn');

        // Clear container and re-add prev button
        paginationContainer.innerHTML = '';
        if(prevBtn) paginationContainer.appendChild(prevBtn);

        // Calculate which page numbers to show
        let pagesToShow = [];
        if(totalPages <= 7) {
            // Show all pages if 7 or fewer
            for(let i = 1; i <= totalPages; i++) {
                pagesToShow.push(i);
            }
        } else {
            // Always show first page
            pagesToShow.push(1);

            if(currentPage <= 3) {
                pagesToShow.push(2, 3, 4, '...', totalPages);
            } else if(currentPage >= totalPages - 2) {
                pagesToShow.push('...', totalPages - 3, totalPages - 2, totalPages - 1, totalPages);
            } else {
                pagesToShow.push('...', currentPage - 1, currentPage, currentPage + 1, '...', totalPages);
            }
        }

        // Create page buttons
        pagesToShow.forEach(page => {
            const btn = document.createElement('button');
            btn.className = 'page-btn';

            if(page === '...') {
                btn.textContent = '...';
                btn.classList.add('disabled');
                btn.disabled = true;
            } else {
                btn.textContent = page;
                btn.setAttribute('data-page', page);
                if(page === currentPage) {
                    btn.classList.add('active');
                }
                btn.addEventListener('click', function() {
                    currentPage = parseInt(this.getAttribute('data-page'));
                    paginateTable();
                });
            }

            paginationContainer.appendChild(btn);
        });

        // Re-add next button
        if(nextBtn) paginationContainer.appendChild(nextBtn);

        // Update prev/next button states
        if(prevBtn) {
            if(currentPage === 1) {
                prevBtn.classList.add('disabled');
                prevBtn.disabled = true;
            } else {
                prevBtn.classList.remove('disabled');
                prevBtn.disabled = false;
            }
        }

        if(nextBtn) {
            if(currentPage >= totalPages) {
                nextBtn.classList.add('disabled');
                nextBtn.disabled = true;
            } else {
                nextBtn.classList.remove('disabled');
                nextBtn.disabled = false;
            }
        }
    }

    function paginateTable() {
        const visibleRows = getVisibleRows();
        const startIndex = (currentPage - 1) * itemsPerPage;
        const endIndex = startIndex + itemsPerPage;

        // Hide all visible rows first
        visibleRows.forEach((row, index) => {
            if(index >= startIndex && index < endIndex) {
                row.style.display = '';
            } else {
                row.style.display = 'none';
            }
        });

        updatePaginationInfo();
        renderPaginationButtons();
    }

    // ============ PAGINATION BUTTONS ============

    const prevBtn = document.getElementById('prevBtn');
    if(prevBtn) {
        prevBtn.addEventListener('click', function() {
            if(currentPage > 1) {
                currentPage--;
                paginateTable();
            }
        });
    }

    const nextBtn = document.getElementById('nextBtn');
    if(nextBtn) {
        nextBtn.addEventListener('click', function() {
            const visibleRows = getVisibleRows();
            const totalPages = Math.ceil(visibleRows.length / itemsPerPage);
            if(currentPage < totalPages) {
                currentPage++;
                paginateTable();
            }
        });
    }

    const perPageSelect = document.getElementById('perPageSelect');
    if(perPageSelect) {
        perPageSelect.addEventListener('change', function() {
            const value = parseInt(this.value);
            if(!isNaN(value)) {
                itemsPerPage = value;
                currentPage = 1; // Reset to first page
                paginateTable();
            }
        });
    }

    // Initialize pagination on page load
    paginateTable();
});
</script>
@endsection