@extends('partials.layouts.master')

@section('title', 'Settings - MediTrack')
@section('meta_description', 'Manage your MediTrack account settings. Update profile information, change password, and configure system preferences.')
@section('title-sub', 'Settings')
@section('pagetitle')
    <div class="flex items-center space-x-2 text-sm font-medium">
        <span class="main-home">Home</span>
         <span class="main-home">/</span>
        <span class="main-settings">Settings</span>
    </div>
@endsection


@section('content')

<script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>

<!-- Profile Section - Compact Design -->
 <div class="p-4">
<div class="container border bg-white p-4 rounded-4" x-data="settingsManager">
    <div class="bg-white p-4">
        <div class="row">
            <!-- Profile Title -->
            <div class="col-md-4">
                <h5 class="main-profile mb-0">Profile</h5>
            </div>
            
            <!-- Profile Fields -->
            <div class="col-md-8">
                <form @submit.prevent="updateProfile()">
                    <div class="row g-3">
                        <!-- Admin Name -->
                        <div class="col-lg-12 col-md-12 col-sm-6">
                            <label class="form-label text-muted small mb-1">Admin Name</label>
                            <input
                                type="text"
                                class="form-control form-control-sm p-3"
                                x-model="profileData.name"
                                required
                                style="background-color: #ffffff; border: 1px solid #dee2e6;">
                        </div>

                        <!-- User Name -->
                        <div class="col-lg-12 col-md-12 col-sm-6">
                            <label class="form-label text-muted small mb-1">User Name</label>
                            <input
                                type="text"
                                class="form-control form-control-sm p-3"
                                x-model="profileData.username"
                                required
                                style="background-color: #ffffff; border: 1px solid #dee2e6;">
                        </div>

                        <!-- Password -->
                        <div class="col-lg-12 col-md-12 col-sm-6">
                            <label class="form-label text-muted small mb-1">Password</label>
                            <div class="d-flex gap-2">
                                <input
                                    type="password"
                                    class="form-control form-control-sm p-3"
                                    value="********"
                                    readonly
                                    style="background-color: #f8f9fa; border: 1px solid #dee2e6;">
                                <button type="button" class="btn changePasswordBtn" @click="showPasswordModal = true" style="white-space: nowrap;">
                                    Change Password
                                </button>
                            </div>
                        </div>

                        <div class="d-flex gap-2">
                            <button type="submit" class="btn saveBtn" :disabled="isUpdatingProfile">
                                <span x-show="!isUpdatingProfile">Save Changes</span>
                                <span x-show="isUpdatingProfile">Saving...</span>
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Success Modal -->
    <template x-if="showSuccessModal">
        <div class="modal fade show d-block"
             tabindex="-1"
             @click.self="showSuccessModal=false"
             style="background-color: rgba(0,0,0,0.5); z-index: 1060;">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content" style="border-radius: 16px; border: none; overflow: hidden;">
                    <div class="modal-body text-center py-5 px-4">
                        <div class="mb-4">
                            <div style="width: 80px; height: 80px; background: linear-gradient(135deg, #10b981 0%, #059669 100%); border-radius: 50%; display: flex; align-items: center; justify-content: center; margin: 0 auto;">
                                <i class="bi bi-check-lg" style="font-size: 48px; color: white;"></i>
                            </div>
                        </div>
                        <h4 class="fw-bold mb-3" style="color: #0D0D12;">Success!</h4>
                        <p class="text-muted mb-4" x-text="successMessage"></p>
                        <button class="btn saveBtn px-5" @click="showSuccessModal = false">
                            OK
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </template>

    <!-- Error Modal -->
    <template x-if="showErrorModal">
        <div class="modal fade show d-block"
             tabindex="-1"
             @click.self="showErrorModal=false"
             style="background-color: rgba(0,0,0,0.5); z-index: 1060;">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content" style="border-radius: 16px; border: none; overflow: hidden;">
                    <div class="modal-body text-center py-5 px-4">
                        <div class="mb-4">
                            <div style="width: 80px; height: 80px; background: linear-gradient(135deg, #ef4444 0%, #dc2626 100%); border-radius: 50%; display: flex; align-items: center; justify-content: center; margin: 0 auto;">
                                <i class="bi bi-x-lg" style="font-size: 48px; color: white;"></i>
                            </div>
                        </div>
                        <h4 class="fw-bold mb-3" style="color: #0D0D12;">Error!</h4>
                        <p class="text-muted mb-4" x-text="errorMessage"></p>
                        <button class="btn btn-danger px-5" @click="showErrorModal = false" style="background: linear-gradient(135deg, #ef4444 0%, #dc2626 100%);">
                            Close
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </template>

    <!-- Change Password Modal -->
  <!-- Change Password Modal -->
<template x-if="showPasswordModal">
    <div class="modal fade show d-block" 
         tabindex="-1" 
         @click.self="showPasswordModal=false" 
         style="background-color: rgba(0,0,0,0.5);">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content" style="border-radius: 12px;">
                <div class="modal-header border-0 pb-0" style="position: relative;">
                    <h5 class="modal-title fw-bold">Change Password</h5>
                    
                    <!-- ✅ صحیح CLOSE BUTTON -->
                    <button type="button" class="changePassword"
                            @click="resetPasswordModal()"
                            >
                        <i class="bi bi-x"></i>
                    </button>
                </div>

                <div class="modal-body px-4 py-4">
                    <form @submit.prevent="changePassword()">
                        <div class="mb-3">
                            <label class="form-label text-muted">Current Password</label>
                            <input type="password" 
                                   class="form-control p-3" 
                                   x-model="passwordData.current" 
                                   placeholder="••••••••" 
                                   required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label text-muted">New Password</label>
                            <input type="password" 
                                   class="form-control p-3" 
                                   x-model="passwordData.new" 
                                   placeholder="••••••••" 
                                   required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label text-muted">Re-Enter New Password</label>
                            <input type="password" 
                                   class="form-control p-3" 
                                   x-model="passwordData.confirm" 
                                   placeholder="••••••••" 
                                   required>
                        </div>
                    </form>
                </div>

                <div class="modal-footer border-0 pt-0 px-4 pb-4">
                    <button class="btn border border-1" @click="resetPasswordModal()">Cancel</button>
                    <button class="btn changePasswordBtn" @click="changePassword()">Change password</button>
                </div>
            </div>
        </div>
    </div>
</template>

    <!-- Admin Panel Users Section - Border matches outer container (Only for Super Admin, Admin, and Manager) -->
    @if(in_array($admin->role, ['Super Admin', 'Admin', 'Manager']))
    <div class="bg-white rounded-3 border mt-4" style="margin: 1rem -1rem -1rem -1rem;" x-data="paymentManager">
        <!-- Header Section -->
        <div class="d-flex justify-content-between align-items-center mb-4" style="padding: 1rem 2rem 0 2rem;">
            <h5 class="main-admin-user mb-0">Admin Panel Users</h5>
            <div class="d-flex align-items-center gap-2">
                <div class="input-group" style="width: 250px;">
                    <span class="input-group-text bg-white border-end-0">
                        <i class="bi bi-search text-muted"></i>
                    </span>
                    <input type="text" class="form-control border-start-0" placeholder="Search" x-model="searchQuery">
                </div>
                <button class="btn btn-primary custom-add-btn d-flex align-items-center" @click="addNewUser">
                    Add new User
                </button>
            </div>
        </div>

        <!-- Table -->
        <div class="table-responsive" style="padding: 0 2rem;">
            <table class="table align-middle">
                <thead style="background-color: #f8f9faff; ">
                    <tr>
                        <th class="fw-semibold" style="color: #6c757d; border-top-left-radius: 8px; border-bottom-left-radius: 8px;">Person Name</th>
                        <th class="fw-semibold" style="color: #6c757d;">User Name</th>
                        <th class="fw-semibold" style="color: #6c757d;">Role</th>
                        <th class="fw-semibold" style="color: #6c757d;">Access Level</th>
                        <th class="text-end fw-semibold" style="color: #6c757d; border-top-right-radius: 8px; border-bottom-right-radius: 8px;">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <template x-if="filteredUsers.length === 0">
                        <tr>
                            <td colspan="5" class="text-center text-muted py-4">No users found.</td>
                        </tr>
                    </template>

                    <template x-for="(user, index) in paginatedUsers" :key="user.id">
                        <tr>
                            <td class="fw-medium" x-text="user.name"></td>
                            <td class="text-muted" x-text="user.username"></td>
                            <td x-text="user.role"></td>
                            <td x-text="Array.isArray(user.access_level) ? user.access_level.join(', ') : user.access_level"></td>
                            <td class="text-end">
                                <div class="d-inline-flex align-items-center gap-1">
                                    <button class="btn btn-sm btn-light" @click="openEditModal(index)" style="border: 1px solid #dee2e6;">
                                        <i class="bi bi-pencil" style="color: #4598F9;"></i>
                                    </button>
                                    <button class="btn btn-sm btn-light" @click="deleteUser(user.id, index)" style="border: 1px solid #dee2e6;">
                                        <i class="bi bi-trash" style="color: #dc3545;"></i>
                                    </button>
                                </div>
                            </td>
                        </tr>
                    </template>
                </tbody>
            </table>
        </div>

        <!-- Pagination -->
        <div class="d-flex justify-content-between align-items-center mt-3" style="padding: 0 2rem 1rem 2rem;">
            <div class="text-muted small">
                Showing <span x-text="startIndex + 1"></span> to <span x-text="endIndex"></span> of <span x-text="filteredUsers.length"></span>
            </div>
            
            <div class="d-flex gap-3 align-items-center">
                <span class="text-muted small">Per page</span>
                <select class="form-select form-select-sm" 
                        style="width: 70px;" 
                        x-model="itemsPerPage" 
                        @change="currentPage = 1">
                    <option value="2">2</option>
                    <option value="5">5</option>
                    <option value="10">10</option>
                    <option value="15">15</option>
                </select>
                
                <div class="pagination-container d-flex align-items-center gap-1">
                    <button class="pagination-btn" 
                            @click="prevPage" 
                            :disabled="currentPage === 1">
                        <i class="bi bi-chevron-left"></i>
                    </button>
                    
                    <template x-for="page in visiblePages" :key="page">
                        <button class="pagination-btn" 
                                :class="page === currentPage ? 'active' : ''"
                                @click="goToPage(page)"
                                x-text="page"></button>
                    </template>
                    
                    <button class="pagination-btn" 
                            @click="nextPage" 
                            :disabled="currentPage === totalPages">
                        <i class="bi bi-chevron-right"></i>
                    </button>
                </div>
            </div>
        </div>

        <!-- Filter Modal -->
        <template x-if="showFilterModal">
            <div class="modal fade show d-block" tabindex="-1" @click.self="showFilterModal=false" style="background-color: rgba(0,0,0,0.5);">
                <div class="modal-dialog modal-dialog-centered">
                    <div class="modal-content" style="border-radius: 12px;">
                        <div class="modal-header border-0 pb-0">
                            <h5 class="modal-title fw-bold">Filter Users</h5>
                            <button type="button" class="btn-close" @click="showFilterModal=false"></button>
                        </div>
                        <div class="modal-body px-4 py-4">
                            <div class="mb-3">
                                <label class="form-label text-muted">Role</label>
                                <select class="form-select" x-model="filterRole">
                                    <option value="">All</option>
                                    <option value="Admin">Admin</option>
                                    <option value="Manager">Manager</option>
                                    <option value="User">User</option>
                                </select>
                            </div>
                            <div class="mb-3">
                                <label class="form-label text-muted">Access Level</label>
                                <select class="form-select" x-model="filterAccess">
                                    <option value="">All</option>
                                    <option value="Full Access">Full Access</option>
                                    <option value="Limited Access">Limited Access</option>
                                    <option value="Read Only">Read Only</option>
                                </select>
                            </div>
                            <div class="d-flex justify-content-end gap-2 mt-3">
                                <button class="btn btn-light border" @click="resetFilter()">Reset</button>
                                <button class="btn text-white" style="background-color:#4598F9;" @click="applyFilter()">Apply</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </template>

        <!-- Success Modal -->
        <template x-if="showSuccessModal">
            <div class="modal fade show d-block"
                 tabindex="-1"
                 @click.self="showSuccessModal=false"
                 style="background-color: rgba(0,0,0,0.5); z-index: 1060;">
                <div class="modal-dialog modal-dialog-centered">
                    <div class="modal-content" style="border-radius: 16px; border: none; overflow: hidden;">
                        <div class="modal-body text-center py-5 px-4">
                            <div class="mb-4">
                                <div style="width: 80px; height: 80px; background: linear-gradient(135deg, #10b981 0%, #059669 100%); border-radius: 50%; display: flex; align-items: center; justify-content: center; margin: 0 auto;">
                                    <i class="bi bi-check-lg" style="font-size: 48px; color: white;"></i>
                                </div>
                            </div>
                            <h4 class="fw-bold mb-3" style="color: #0D0D12;">Success!</h4>
                            <p class="text-muted mb-4" x-text="successMessage"></p>
                            <button class="btn saveBtn px-5" @click="showSuccessModal = false">
                                OK
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </template>

        <!-- Error Modal -->
        <template x-if="showErrorModal">
            <div class="modal fade show d-block"
                 tabindex="-1"
                 @click.self="showErrorModal=false"
                 style="background-color: rgba(0,0,0,0.5); z-index: 1060;">
                <div class="modal-dialog modal-dialog-centered">
                    <div class="modal-content" style="border-radius: 16px; border: none; overflow: hidden;">
                        <div class="modal-body text-center py-5 px-4">
                            <div class="mb-4">
                                <div style="width: 80px; height: 80px; background: linear-gradient(135deg, #ef4444 0%, #dc2626 100%); border-radius: 50%; display: flex; align-items: center; justify-content: center; margin: 0 auto;">
                                    <i class="bi bi-x-lg" style="font-size: 48px; color: white;"></i>
                                </div>
                            </div>
                            <h4 class="fw-bold mb-3" style="color: #0D0D12;">Error!</h4>
                            <p class="text-muted mb-4" x-text="errorMessage"></p>
                            <button class="btn btn-danger px-5" @click="showErrorModal = false" style="background: linear-gradient(135deg, #ef4444 0%, #dc2626 100%);">
                                Close
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </template>

        <!-- Add/Edit Modal -->
        <template x-if="showModal">
            <div class="modal fade show d-block" tabindex="-1" @click.self="resetModal()" style="background-color: rgba(0,0,0,0.5);">
                <div class="modal-dialog modal-dialog-centered">
                    <div class="modal-content" style="border-radius: 12px;">
                        <div class="modal-header border-0 pb-0">
                            <h5 class="modal-title fw-bold" x-text="editIndex !== null ? 'Edit User' : 'Add New User'"></h5>

                            <!-- add new user close button -->
                            <button type="button"
                style="width: 36px; height: 36px; border-radius: 50%; border: 1px solid #D1D5DB; background-color: white; display: flex; align-items: center; justify-content: center; padding: 0; cursor: pointer;"
                    class="btn-close"
                    @click="resetModal()"
                    style="position: absolute; right: 20px; top: 20px;">
                </button>

                    </div>
                        <div class="modal-body px-4 py-4">
                            <form @submit.prevent="saveUser()">
                                <div class="mb-3">
                                    <label class="form-label text-muted">Person Name</label>
                                    <input type="text" class="form-control" x-model="editUser.name" required>
                                </div>
                                <div class="mb-3">
                                    <label class="form-label text-muted">User Name</label>
                                    <input type="text" class="form-control" x-model="editUser.username" required>
                                </div>
                                <div class="mb-3">
                                    <label class="form-label text-muted">Password</label>
                                    <input type="password" class="form-control" x-model="editUser.password"
                                           :placeholder="editIndex !== null ? 'Leave blank to keep current password' : 'Enter password'"
                                           :required="editIndex === null" minlength="6">
                                    <small class="text-muted" x-show="editIndex !== null">Leave blank to keep the current password</small>
                                </div>
                                <div class="mb-3">
                                    <label class="form-label text-muted">Role</label>
                                    <select class="form-select" x-model="editUser.role" @change="updateAccessLevelsByRole()" required>
                                        <option value="Admin">Admin</option>
                                        <option value="Manager">Manager</option>
                                        <option value="User">User</option>
                                    </select>
                                </div>

                       <!-- Access level Section -->
                                  <div class="mb-3">
    <label class="form-label" style="color: #6b7280; font-size: 14px;">Access level</label>
    <div class="access-level-container" style="display: flex; justify-content: center; padding: 15px; border: 1px solid #e5e7eb; border-radius: 8px;">
        <div style="display: grid; grid-template-columns: repeat(3, 1fr); gap: 30px; max-width: 500px;">

            <!-- Cleaning -->
            <div class="form-check" style="display: flex; align-items: center; gap: 2px;">
                <input class="form-check-input" type="checkbox" value="cleaning" x-model="editUser.accessLevelArray" :disabled="editUser.role === 'Admin'" style="margin: 0;">
                <label class="form-check-label" style="margin: 0; cursor: pointer;">
                    Cleaning
                </label>
            </div>

            <!-- Disinfection -->
            <div class="form-check" style="display: flex; align-items: center; gap: 2px;">
                <input class="form-check-input" type="checkbox" value="disinfection" x-model="editUser.accessLevelArray" :disabled="editUser.role === 'Admin'" style="margin: 0;">
                <label class="form-check-label" style="margin: 0; cursor: pointer;">
                    Disinfection
                </label>
            </div>

            <!-- Sterilization -->
            <div class="form-check" style="display: flex; align-items: center; gap: 2px;">
                <input class="form-check-input" type="checkbox" value="sterilization" x-model="editUser.accessLevelArray" :disabled="editUser.role === 'Admin'" style="margin: 0;">
                <label class="form-check-label" style="margin: 0; cursor: pointer;">
                    Sterilization
                </label>
            </div>

            <!-- Inventory -->
            <div class="form-check" style="display: flex; align-items: center; gap: 2px;">
                <input class="form-check-input" type="checkbox" value="inventory" x-model="editUser.accessLevelArray" :disabled="editUser.role === 'Admin'" style="margin: 0;">
                <label class="form-check-label" style="margin: 0; cursor: pointer;">
                    Inventory
                </label>
            </div>

            <!-- Task -->
            <div class="form-check" style="display: flex; align-items: center; gap: 2px;">
                <input class="form-check-input" type="checkbox" value="task" x-model="editUser.accessLevelArray" :disabled="editUser.role === 'Admin'" style="margin: 0;">
                <label class="form-check-label" style="margin: 0; cursor: pointer;">
                    Task
                </label>
            </div>

            <!-- Medical Waste -->
            <div class="form-check" style="display: flex; align-items: center; gap: 2px;">
                <input class="form-check-input" type="checkbox" value="medical_waste" x-model="editUser.accessLevelArray" :disabled="editUser.role === 'Admin'" style="margin: 0;">
                <label class="form-check-label" style="margin: 0; cursor: pointer;">
                    Medical Waste
                </label>
            </div>
        </div>
    </div>
</div>
                                
                            </form>
                        </div>
                        <div class="modal-footer border-0 pt-0 px-4 pb-4">
                            <button class="btn border border-1" @click="resetModal()">Cancel</button>
                            <button class="btn px-5 py-2 saveBtn" @click="saveUser()">Save</button>
                        </div>
                    </div>
                </div>
            </div>
        </template>
    </div>
    @endif
</div>
</div>


<script>
document.addEventListener('alpine:init', () => {
    // Settings Manager for Profile Section
    Alpine.data('settingsManager', () => ({
        showPasswordModal: false,
        showSuccessModal: false,
        showErrorModal: false,
        successMessage: '',
        errorMessage: '',
        profileData: {
            name: '{{ $admin->name ?? "" }}',
            username: '{{ $admin->username ?? "" }}'
        },
        passwordData: {
            current: '',
            new: '',
            confirm: ''
        },
        isSubmitting: false,
        isUpdatingProfile: false,

        showSuccess(message) {
            this.successMessage = message;
            this.showSuccessModal = true;
        },

        showError(message) {
            this.errorMessage = message;
            this.showErrorModal = true;
        },

        async updateProfile() {
            if (!this.profileData.name || !this.profileData.username) {
                this.showError('Please fill in all fields!');
                return;
            }

            this.isUpdatingProfile = true;
            try {
                const response = await fetch('{{ route("admin.update-profile") }}', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': '{{ csrf_token() }}'
                    },
                    body: JSON.stringify({
                        name: this.profileData.name,
                        username: this.profileData.username
                    })
                });

                const data = await response.json();

                if (response.ok) {
                    this.showSuccess(data.message || 'Profile updated successfully!');
                    // Update local data with response
                    if (data.data) {
                        this.profileData.name = data.data.name;
                        this.profileData.username = data.data.username;
                    }
                } else {
                    this.showError(data.message || 'Failed to update profile!');
                }
            } catch (error) {
                this.showError('An error occurred. Please try again.');
                console.error(error);
            } finally {
                this.isUpdatingProfile = false;
            }
        },

        async changePassword() {
            // Validation
            if (!this.passwordData.current || !this.passwordData.new || !this.passwordData.confirm) {
                this.showError('Please fill all password fields!');
                return;
            }

            if (this.passwordData.new !== this.passwordData.confirm) {
                this.showError('New passwords do not match!');
                return;
            }

            if (this.passwordData.new.length < 6) {
                this.showError('Password must be at least 6 characters long!');
                return;
            }

            // Submit to backend
            this.isSubmitting = true;
            try {
                const response = await fetch('{{ route("admin.change-password") }}', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': '{{ csrf_token() }}'
                    },
                    body: JSON.stringify({
                        current_password: this.passwordData.current,
                        new_password: this.passwordData.new,
                        new_password_confirmation: this.passwordData.confirm
                    })
                });

                const data = await response.json();

                if (response.ok) {
                    this.resetPasswordModal();
                    this.showSuccess(data.message || 'Password changed successfully!');
                } else {
                    this.showError(data.message || 'Failed to change password!');
                }
            } catch (error) {
                this.showError('An error occurred. Please try again.');
                console.error(error);
            } finally {
                this.isSubmitting = false;
            }
        },

        resetPasswordModal() {
            this.showPasswordModal = false;
            this.passwordData = {
                current: '',
                new: '',
                confirm: ''
            };
        }
    }));

    // Payment Manager for Users Table
    Alpine.data('paymentManager', () => ({
        showModal: false,
        showFilterModal: false,
        showSuccessModal: false,
        showErrorModal: false,
        successMessage: '',
        errorMessage: '',
        editIndex: null,
        editUser: { name: '', username: '', password: '', role: 'User', accessLevelArray: [] },
        currentPage: 1,
        itemsPerPage: 10,
        searchQuery: '',
        filterRole: '',
        filterAccess: '',
        sortAsc: true,
        users: [],
        isLoading: false,

        async init() {
            await this.fetchUsers();
        },

        showSuccess(message) {
            this.successMessage = message;
            this.showSuccessModal = true;
        },

        showError(message) {
            this.errorMessage = message;
            this.showErrorModal = true;
        },

        async fetchUsers() {
            this.isLoading = true;
            try {
                const response = await fetch('{{ route("admin.users.index") }}');
                if (response.ok) {
                    this.users = await response.json();
                } else {
                    this.showError('Failed to load users');
                }
            } catch (error) {
                this.showError('An error occurred while loading users');
                console.error(error);
            } finally {
                this.isLoading = false;
            }
        },

        get filteredUsers() {
            let list = this.users;
            if (this.filterRole) list = list.filter(u => u.role === this.filterRole);
            if (this.filterAccess) {
                list = list.filter(u => {
                    if (Array.isArray(u.access_level)) {
                        return u.access_level.some(a => a.toLowerCase().includes(this.filterAccess.toLowerCase()));
                    }
                    return false;
                });
            }
            if (this.searchQuery) {
                const q = this.searchQuery.toLowerCase();
                list = list.filter(u =>
                    u.name.toLowerCase().includes(q) ||
                    u.username.toLowerCase().includes(q) ||
                    u.role.toLowerCase().includes(q)
                );
            }
            return list;
        },
        
        get totalPages() { return Math.ceil(this.filteredUsers.length / this.itemsPerPage); },
        get startIndex() { return (this.currentPage - 1) * this.itemsPerPage; },
        get endIndex() { return Math.min(this.startIndex + this.itemsPerPage, this.filteredUsers.length); },
        get paginatedUsers() { return this.filteredUsers.slice(this.startIndex, this.endIndex); },
        
        get visiblePages() {
            const total = this.totalPages;
            const current = this.currentPage;
            const delta = 2;
            
            let range = [];
            let rangeWithDots = [];
            let l;

            for (let i = 1; i <= total; i++) {
                if (i == 1 || i == total || (i >= current - delta && i <= current + delta)) {
                    range.push(i);
                }
            }

            range.forEach((i) => {
                if (l) {
                    if (i - l === 2) {
                        rangeWithDots.push(l + 1);
                    } else if (i - l !== 1) {
                        rangeWithDots.push('...');
                    }
                }
                rangeWithDots.push(i);
                l = i;
            });

            return rangeWithDots;
        },

        prevPage() { if (this.currentPage > 1) this.currentPage--; },
        nextPage() { if (this.currentPage < this.totalPages) this.currentPage++; },
        goToPage(p) { 
            if (p !== '...' && p >= 1 && p <= this.totalPages) {
                this.currentPage = p; 
            }
        },

        applyFilter() { 
            this.currentPage = 1; 
            this.showFilterModal = false; 
        },
        
        resetFilter() { 
            this.filterRole = ''; 
            this.filterAccess = ''; 
            this.searchQuery = ''; 
            this.currentPage = 1;
            this.showFilterModal = false;
        },

        addNewUser() {
            this.editUser = { name: '', username: '', password: '', role: 'User', accessLevelArray: [] };
            this.editIndex = null;
            this.showModal = true;
        },

        // Watch for role changes and auto-select access levels for Admin
        updateAccessLevelsByRole() {
            if (this.editUser.role === 'Admin') {
                this.editUser.accessLevelArray = ['cleaning', 'disinfection', 'sterilization', 'inventory', 'task', 'medical_waste'];
            }
        },

        openEditModal(i) {
            const u = this.paginatedUsers[i];
            this.editUser = {
                id: u.id,
                name: u.name,
                username: u.username,
                password: '',
                role: u.role,
                accessLevelArray: Array.isArray(u.access_level) ? [...u.access_level] : []
            };
            this.editIndex = this.users.findIndex(user => user.id === u.id);
            // Ensure Admin role has all access levels selected
            this.updateAccessLevelsByRole();
            this.showModal = true;
        },

        async saveUser() {
            const userData = {
                name: this.editUser.name,
                username: this.editUser.username,
                role: this.editUser.role,
                access_level: this.editUser.accessLevelArray
            };

            // Only include password if it's provided
            if (this.editUser.password && this.editUser.password.trim() !== '') {
                userData.password = this.editUser.password;
            }

            try {
                let response;
                if (this.editIndex !== null && this.editUser.id) {
                    // Update existing user
                    response = await fetch(`{{ url('/admin/users') }}/${this.editUser.id}`, {
                        method: 'PUT',
                        headers: {
                            'Content-Type': 'application/json',
                            'X-CSRF-TOKEN': '{{ csrf_token() }}'
                        },
                        body: JSON.stringify(userData)
                    });
                } else {
                    // Create new user
                    if (!userData.password) {
                        this.showError('Password is required for new users');
                        return;
                    }
                    response = await fetch('{{ route("admin.users.store") }}', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json',
                            'X-CSRF-TOKEN': '{{ csrf_token() }}'
                        },
                        body: JSON.stringify(userData)
                    });
                }

                const data = await response.json();

                if (response.ok) {
                    this.showSuccess(data.message);
                    await this.fetchUsers();
                    this.resetModal();
                } else {
                    this.showError(data.message || 'Failed to save user');
                }
            } catch (error) {
                this.showError('An error occurred. Please try again.');
                console.error(error);
            }
        },

        async deleteUser(userId, index) {
            if (!confirm('Are you sure you want to delete this user?')) {
                return;
            }

            try {
                const response = await fetch(`{{ url('/admin/users') }}/${userId}`, {
                    method: 'DELETE',
                    headers: {
                        'X-CSRF-TOKEN': '{{ csrf_token() }}'
                    }
                });

                const data = await response.json();

                if (response.ok) {
                    this.showSuccess(data.message);
                    await this.fetchUsers();
                } else {
                    this.showError(data.message || 'Failed to delete user');
                }
            } catch (error) {
                this.showError('An error occurred. Please try again.');
                console.error(error);
            }
        },

        resetModal() {
            this.showModal = false;
            this.editUser = { name: '', username: '', password: '', role: 'User', accessLevelArray: [] };
            this.editIndex = null;
        },
    }));
});
</script>

<style>
    [x-cloak]{display:none!important}
    .modal{z-index:1050}
    
    .custom-add-btn {
        background: linear-gradient(180deg, rgba(255, 255, 255, 0.12) 0%, rgba(255, 255, 255, 0.00) 100%), linear-gradient(180deg, #4598F9 0%, #3A77BF 100%); box-shadow: 0 1px 2px 0 rgba(13, 13, 18, 0.06); color: #ffffff !important;
        border-color: #4598F9 !important;
        color: white !important;
    }
    
    .pagination-container {
        display: flex;
        align-items: center;
    }
    
    .pagination-btn {
        width: 32px;
        height: 32px;
        border-radius: 6px;
        border: 1px solid #dee2e6;
        background-color: #fff;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 14px;
        color: #333;
        cursor: pointer;
        transition: all 0.2s;
    }
    
    .pagination-btn:hover:not(:disabled):not(.active) {
        background-color: #f8f9fa;
    }
    
    .pagination-btn.active {
        background: linear-gradient(180deg, rgba(255, 255, 255, 0.12) 0%, rgba(255, 255, 255, 0.00) 100%), linear-gradient(180deg, #4598F9 0%, #3A77BF 100%); box-shadow: 0 1px 2px 0 rgba(13, 13, 18, 0.06); color: #ffffff !important;
        color: white;
        border-color: #4598F9;
    }
    
    .pagination-btn:disabled {
        opacity: 0.4;
        cursor: not-allowed;
    }

    .table thead th:first-child {
        border-top-left-radius: 8px;
    }

    .table thead th:last-child {
        border-top-right-radius: 8px;
    }
    body {
        background-color: white !important;
    }
    .saveBtn {
     background: linear-gradient(180deg, rgba(255, 255, 255, 0.12) 0%, rgba(255, 255, 255, 0.00) 100%), linear-gradient(180deg, #4598F9 0%, #3A77BF 100%); box-shadow: 0 1px 2px 0 rgba(13, 13, 18, 0.06); color: #ffffff !important;
    }
    .changePasswordBtn {
                background: linear-gradient(180deg, rgba(255, 255, 255, 0.12) 0%, rgba(255, 255, 255, 0.00) 100%), linear-gradient(180deg, #4598F9 0%, #3A77BF 100%); box-shadow: 0 1px 2px 0 rgba(13, 13, 18, 0.06); color: #ffffff !important;
    }
    .main-home {
    color: var(--Greyscale-400, #818898);
/* Body/Medium/Medium */
font-family: "Inter Tight";
font-size: 14px;
font-style: normal;
font-weight: 500;
line-height: 150%; /* 21px */
letter-spacing: 0.28px;
    }
    .main-settings {
 color: var(--Greyscale-900, #0D0D12);
/* Body/Medium/Medium */
font-family: "Inter Tight";
font-size: 14px;
font-style: normal;
font-weight: 500;
line-height: 150%; /* 21px */
letter-spacing: 0.28px;
    }
    .main-profile {
        color: var(--Greyscale-900, #0D0D12);
/* Heading/H6 */
font-family: "Inter Tight";
font-size: 18px;
font-style: normal;
font-weight: 600;
line-height: 135%; /* 24.3px */
    }
    .main-admin-user {
        olor: var(--Greyscale-900, #0D0D12);
/* Body/Large/Semibold */
font-family: "Inter Tight";
font-size: 16px;
font-style: normal;
font-weight: 600;
line-height: 150%; /* 24px */
letter-spacing: 0.32px;
    }
    table thead th:nth-child(4) {
    border-right: none !important;
    border-left: none !important;
}
table thead th:nth-child(5) {
    border-left: none !important;
}
</style>
@endsection