@extends('partials.layouts.master')
@section('title','Rooms | FabKin')
@section('title-sub','Add Room')
@section('pagetitle','')

@section('content')

<style>
    body {
        background-color: white;
    }
    .main-clinic {
        color: var(--Greyscale-400, #818898);
        font-family: "Inter Tight";
        font-size: 14px;
        font-style: normal;
        font-weight: 500;
        line-height: 150%;
        letter-spacing: 0.28px;
    }
    .main-room {
        color: var(--Greyscale-900, #0D0D12);
        font-family: "Inter Tight";
        font-size: 14px;
        font-style: normal;
        font-weight: 500;
        line-height: 150%;
        letter-spacing: 0.28px;
    }
    .room-text {
        color: var(--Greyscale-900, #0D0D12);
        font-family: "Inter Tight";
        font-size: 16px;
        font-style: normal;
        font-weight: 600;
        line-height: 150%;
        letter-spacing: 0.32px;
    }
    .room-btn {
        border-radius: 8px;
        border: 1px solid #FFF;
        background: var(--grad, linear-gradient(180deg, rgba(255, 255, 255, 0.12) 0%, rgba(255, 255, 255, 0.00) 100%), linear-gradient(180deg, #4598F9 0%, #3A77BF 100%));
        box-shadow: 0 1px 2px 0 rgba(13, 13, 18, 0.06);
    }
    .room-btn:hover {
        color: white !important;
    }
    .search-box {
        position: relative;
        width: 300px;
    }
    .search-box input {
        width: 100%;
        padding: 8px 12px 8px 36px;
        border: 1px solid #e5e7eb;
        border-radius: 8px;
        font-size: 14px;
    }
    .search-box i {
        position: absolute;
        left: 12px;
        top: 50%;
        transform: translateY(-50%);
        color: #9ca3af;
    }
    .btn-primary{
        background: var(--grad, linear-gradient(180deg, rgba(255, 255, 255, 0.12) 0%, rgba(255, 255, 255, 0.00) 100%), linear-gradient(180deg, #4598F9 0%, #3A77BF 100%));
        color: #ffffff !important;
        border: none !important;
    }
    .btn-primary:hover{
        background-color: #2563eb !important;
    }
    .btn-secondary {
        background-color: #ffffff !important;
        color: #374151 !important;
        border: 1px solid #e5e7eb !important;
    }
    .btn-secondary:hover {
        background-color: #f9fafb !important;
        color: #374151 !important;
    }
</style>

<div class="p-0 m-2">
    <!-- Top Section: Breadcrumb + Button -->
    <div class="d-flex justify-content-between align-items-center mb-0 pb-0">
        <!-- Breadcrumb -->
        <div class="breadcrumb-custom d-flex align-items-center m-0 p-0">
            <a href="{{ route('clinics') }}" class="main-clinic">Clinics</a>
            <span class="mx-2 text-muted main-clinic">/</span>
            <a href="{{ route('add-new-Clinic') }}" class="main-clinic">Add Clinic</a>
            <span class="mx-2 text-muted main-clinic">/</span>
            <span class="main-room">Rooms</span>
        </div>

        <!-- Add Button -->
        <button type="button"
                class="btn btn-primary px-4 py-2 room-btn mb-0"
                data-bs-toggle="modal"
                data-bs-target="#addRoomModal">
            Add Room
        </button>
    </div>
</div>

<div class="p-4">
    @if(session('success'))
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        {{ session('success') }}
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
    @endif

    @if(session('error'))
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        {{ session('error') }}
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
    @endif

    <div class="p-4 rounded-4" style="border-radius: 16px; border: 1px solid var(--Greyscale-100, #DFE1E7); background: var(--Greyscale-0, #FFF); box-shadow: 0 1px 2px 0 rgba(228, 229, 231, 0.24);">
        <div class="d-flex justify-content-between align-items-center mb-3">
            <!-- Left side -->
            <div>
                <h6 class="mb-0 room-text">All Rooms</h6>
            </div>

            <!-- Right side -->
            <div class="d-flex align-items-center">
                <!-- Search Box -->
                <div class="search-box d-flex align-items-center me-1">
                    <i class="bi bi-search"></i>
                    <input type="text" id="searchInput" placeholder="Search" class="form-control form-control-sm">
                </div>
            </div>
        </div>

        <!-- Table -->
        <div class="table-responsive">
            <table class="table overflow-hidden">
                <thead>
                    <tr class="bg-light">
                        <th style="color: var(--Greyscale-500, #666D80); background: var(--Greyscale-25, #F6F8FA); border-top-left-radius: 8px; border-bottom-left-radius: 8px;">
                            Name
                        </th>
                        <th style="text-align: right; color: var(--Greyscale-500, #666D80); background: var(--Greyscale-25, #F6F8FA); border-top-right-radius: 8px; border-bottom-right-radius: 8px;">
                            Actions
                        </th>
                    </tr>
                </thead>
                <tbody id="roomTableBody">
                    @forelse($rooms as $room)
                    <tr data-id="{{ $room->id }}" data-name="{{ $room->name }}">
                        <td>{{ $room->name }}</td>
                        <td class="text-end py-3" style="white-space: nowrap;">
                            <button class="btn btn-sm me-1 edit-btn"
                                    style="background-color: #f0fbff; border: 1px solid #dee2e6; padding: 4px 8px;"
                                    data-id="{{ $room->id }}"
                                    data-name="{{ $room->name }}">
                                <i class="bi bi-pencil" style="color: #33cfff; font-size: 14px;"></i>
                            </button>
                            <button class="btn btn-sm delete-btn"
                                    style="background-color: #fff0f3; border: 1px solid #dee2e6; padding: 4px 8px;"
                                    data-id="{{ $room->id }}"
                                    data-name="{{ $room->name }}">
                                <i class="bi bi-trash" style="color: red; font-size: 14px;"></i>
                            </button>
                        </td>
                    </tr>
                    @empty
                    <tr id="emptyRow">
                        <td colspan="2" class="text-center py-4 text-muted">
                            No rooms found. Add your first room using the button above.
                        </td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        <!-- Back Button -->
        <div class="mt-4 d-flex justify-content-end">
            <a href="{{ route('add-new-Clinic') }}" class="btn btn-secondary px-4">
                <i class="bi bi-arrow-left me-2"></i> Back to Add Clinic
            </a>
        </div>
    </div>
</div>

<!-- Add Room Modal -->
<div class="modal fade" id="addRoomModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header border-0 pb-0">
                <h5 class="modal-title">Add Room</h5>
                <button type="button" data-bs-dismiss="modal" style="width: 36px; height: 36px; border-radius: 50%; border: 1px solid #D1D5DB; background-color: white; display: flex; align-items: center; justify-content: center; padding: 0; cursor: pointer; position: absolute; right: 20px; top: 20px;" onmouseover="this.style.backgroundColor='#f9fafb'" onmouseout="this.style.backgroundColor='white'">
                    <i class="bi bi-x" style="font-size: 20px; color: #000; font-weight: bold;"></i>
                </button>
            </div>
            <div class="modal-body">
                <form id="addRoomForm">
                    <div class="mb-3">
                        <label class="form-label">Room Name <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" id="roomName" placeholder="Enter room name" required>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                <button type="button" class="btn btn-primary" id="saveRoomBtn">Save</button>
            </div>
        </div>
    </div>
</div>

<!-- Edit Room Modal -->
<div class="modal fade" id="editRoomModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Edit Room</h5>
                <button type="button" data-bs-dismiss="modal" style="width: 36px; height: 36px; border-radius: 50%; border: 1px solid #D1D5DB; background-color: white; display: flex; align-items: center; justify-content: center; padding: 0; cursor: pointer; position: absolute; right: 20px; top: 20px;" onmouseover="this.style.backgroundColor='#f9fafb'" onmouseout="this.style.backgroundColor='white'">
                    <i class="bi bi-x" style="font-size: 20px; color: #000; font-weight: bold;"></i>
                </button>
            </div>
            <div class="modal-body">
                <form id="editRoomForm">
                    <div class="mb-3">
                        <label class="form-label">Room Name <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" id="editRoomName" required>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                <button type="button" class="btn btn-primary" id="updateRoomBtn">Update</button>
            </div>
        </div>
    </div>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        let currentEditId = null;
        const csrfToken = '{{ csrf_token() }}';

        // ============ SEARCH FUNCTIONALITY ============
        const searchInput = document.getElementById('searchInput');
        if(searchInput) {
            searchInput.addEventListener('input', function(e) {
                const searchTerm = e.target.value.toLowerCase();
                const rows = document.querySelectorAll('#roomTableBody tr:not(#emptyRow)');

                rows.forEach(row => {
                    const name = row.getAttribute('data-name');
                    if(name && name.toLowerCase().includes(searchTerm)) {
                        row.style.display = '';
                    } else {
                        row.style.display = 'none';
                    }
                });
            });
        }

        // ============ ADD ROOM ============
        document.getElementById('saveRoomBtn').addEventListener('click', async function() {
            const name = document.getElementById('roomName').value.trim();

            if(!name) {
                alert('Please enter room name');
                return;
            }

            try {
                const response = await fetch('{{ route("room.store") }}', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': csrfToken
                    },
                    body: JSON.stringify({ name: name })
                });

                const data = await response.json();

                if(data.success) {
                    window.location.reload();
                } else {
                    alert(data.message || 'Failed to add room');
                }
            } catch(error) {
                alert('An error occurred. Please try again.');
                console.error(error);
            }
        });

        // ============ EDIT ROOM ============
        document.querySelectorAll('.edit-btn').forEach(btn => {
            btn.addEventListener('click', function() {
                currentEditId = this.getAttribute('data-id');
                const name = this.getAttribute('data-name');
                document.getElementById('editRoomName').value = name;
                new bootstrap.Modal(document.getElementById('editRoomModal')).show();
            });
        });

        // ============ UPDATE ROOM ============
        document.getElementById('updateRoomBtn').addEventListener('click', async function() {
            const newName = document.getElementById('editRoomName').value.trim();

            if(!newName) {
                alert('Please enter room name');
                return;
            }

            if(!currentEditId) {
                alert('No room selected');
                return;
            }

            try {
                const response = await fetch(`/room/${currentEditId}`, {
                    method: 'PUT',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': csrfToken
                    },
                    body: JSON.stringify({ name: newName })
                });

                const data = await response.json();

                if(data.success) {
                    window.location.reload();
                } else {
                    alert(data.message || 'Failed to update room');
                }
            } catch(error) {
                alert('An error occurred. Please try again.');
                console.error(error);
            }
        });

        // ============ DELETE ROOM ============
        document.querySelectorAll('.delete-btn').forEach(btn => {
            btn.addEventListener('click', async function() {
                const id = this.getAttribute('data-id');
                const name = this.getAttribute('data-name');

                if(!confirm(`Are you sure you want to delete "${name}"?`)) {
                    return;
                }

                try {
                    const response = await fetch(`/room/${id}`, {
                        method: 'DELETE',
                        headers: {
                            'Content-Type': 'application/json',
                            'X-CSRF-TOKEN': csrfToken
                        }
                    });

                    const data = await response.json();

                    if(data.success) {
                        window.location.reload();
                    } else {
                        alert(data.message || 'Failed to delete room');
                    }
                } catch(error) {
                    alert('An error occurred. Please try again.');
                    console.error(error);
                }
            });
        });
    });
</script>

@endsection
