@extends('partials.layouts.master')

@section('title', 'Medical Waste Management - MediTrack')
@section('meta_description', 'Comprehensive medical waste management dashboard. Access waste bags, waste types, container types, and waste collectors. Track and manage all medical waste disposal activities.')
@section('title-sub', 'Medical Waste')
@section('pagetitle')
    <div class="flex items-center space-x-2 text-sm font-medium">
        <span class="main-home"><a href="{{ route('dashboard') }}" class="main-home">Home</a></span>
        <span class="main-home">/</span>
        <span class="main-home"><a href="{{ route('clinics') }}" class="main-home">Clinics</a></span>
       <span class="main-home">/</span>
        <span class="main-home"><a href="{{ route('moduls', ['clinic_id' => $clinic->id]) }}" class="main-home">Moduls</a></span>
         <span class="main-home">/</span>
        <span class="main-clinics">Medical Waste</span>
    </div>
@endsection
{{-- ************************ --}}



@section('content')


<div class="container mt-4">
  <div class="p-4 bg-white rounded-1">
    <div class="border border-1 p-3 rounded-2">
    <div class="row g-3 p-3">
        

      <!-- Card 1 -->
      <div class="col-lg-4 col-md-4 col-sm-6">
        <div class="p-3 border bg-white rounded-1">
          <div class="bg-white rounded-xl overflow-hidden">
            <div class="h-48 overflow-hidden rounded-1">
              <img src="{{ asset('assets/images/clean.png') }}" alt="" class="w-100 h-100">
            </div>
            <div class="p-4">
              <h5 class="medical-waste">Waste bags</h5>
              <div class="border-bottom border-gray-200 mt-2 mb-4"></div>
              <a href="{{route ('Waste-bags', ['clinic_id' => $clinic->id]) }}">
                 <button class="w-full py-3 text-white rounded-1 border-0" style="border-radius: 8px; border: 1px solid #FFF; background: var(--grad, linear-gradient(180deg, rgba(255, 255, 255, 0.12) 0%, rgba(255, 255, 255, 0.00) 100%), linear-gradient(180deg, #4598F9 0%, #3A77BF 100%)); box-shadow: 0 1px 2px 0 rgba(13, 13, 18, 0.06);">
                            View All Waste bags
                  </button>
              </a>
            </div>
          </div>
        </div>
      </div>

      <!-- Card 2 -->
        <div class="col-lg-4 col-md-4 col-sm-6">
              <a href="{{ route('waste-type.index', ['clinic_id' => $clinic->id]) }}">
          <div class="p-3 border bg-white rounded-1">
            <div class="bg-white rounded-xl overflow-hidden">
              <div class="h-48 overflow-hidden rounded-1">
                <img src="{{ asset('assets/images/disinfection.png') }}" alt="" class="w-100 h-100">
              </div>
              <div class="p-4">
                <h5 class="medical-waste">Waste Type</h5>
                <div class="border-bottom border-gray-200 mt-2 mb-4"></div>
                <button class="w-full py-3 text-white rounded-1 border-0" style="border-radius: 8px; border: 1px solid #FFF; background: var(--grad, linear-gradient(180deg, rgba(255, 255, 255, 0.12) 0%, rgba(255, 255, 255, 0.00) 100%), linear-gradient(180deg, #4598F9 0%, #3A77BF 100%)); box-shadow: 0 1px 2px 0 rgba(13, 13, 18, 0.06);">
                    View or Add Waste Type
                  </button>
              </div>
            </div>
          </div>
           </a>
        </div>
     

      <!-- Card 3 -->
      <div class="col-lg-4 col-md-4 col-sm-6">
        <a href="{{ route('container-type.index', ['clinic_id' => $clinic->id]) }}">
        <div class="p-3 border bg-white rounded-1">
          <div class="bg-white rounded-xl overflow-hidden">
            <div class="h-48 overflow-hidden rounded-1">
              <img src="{{ asset('assets/images/sterilization.png') }}" alt="" class="w-100 h-100">
            </div>
            <div class="p-4">
              <h5 class="medical-waste">Container Type</h5>
              <div class="border-bottom border-gray-200 mt-2 mb-4"></div>
                <button class="w-full py-3 text-white rounded-1 border-0" style="border-radius: 8px; border: 1px solid #FFF; background: var(--grad, linear-gradient(180deg, rgba(255, 255, 255, 0.12) 0%, rgba(255, 255, 255, 0.00) 100%), linear-gradient(180deg, #4598F9 0%, #3A77BF 100%)); box-shadow: 0 1px 2px 0 rgba(13, 13, 18, 0.06);">
                   View or Add Container Type
                  </button>
            </div>
          </div>
        </div>
        </a>
      </div>

      <!-- Card 4 -->
      <div class="col-lg-4 col-md-4 col-sm-6">
        <a href="{{ route('collectors.index', ['clinic_id' => $clinic->id]) }}">
        <div class="p-3 border bg-white rounded-1">
          <div class="bg-white rounded-xl overflow-hidden">
            <div class="h-48 overflow-hidden rounded-1">
              <img src="{{ asset('assets/images/sterilization.png') }}" alt="" class="w-100 h-100">
            </div>
            <div class="p-4">
              <h5 class="medical-waste"> Collectors </h5>
              <div class="border-bottom border-gray-200 mt-2 mb-4"></div>
                <button class="w-full py-3 text-white rounded-1 border-0" style="border-radius: 8px; border: 1px solid #FFF; background: var(--grad, linear-gradient(180deg, rgba(255, 255, 255, 0.12) 0%, rgba(255, 255, 255, 0.00) 100%), linear-gradient(180deg, #4598F9 0%, #3A77BF 100%)); box-shadow: 0 1px 2px 0 rgba(13, 13, 18, 0.06);">
                  View or Add Collectors
                  </button>
            </div>
          </div>
        </div>
        </a>
      </div>

    </div>
  </div>
</div>
</div>


<style>
    body{
        background-color: white !important;
    }
    .medical-waste {
      color: var(--Black, #05080B);
font-family: Inter;
font-size: 16px;
font-style: normal;
font-weight: 600;
line-height: 110%; /* 17.6px */
    }
     .main-home {
color: var(--Greyscale-900, #818898) !important;
/* Body/Medium/Medium */
font-family: "Inter Tight";
font-size: 14px;
font-style: normal;
font-weight: 500;
line-height: 150%; /* 21px */
letter-spacing: 0.28px; 
    }
    .main-clinics{
        color: var(--Greyscale-400, #0D0D12) !important;
/* Body/Medium/Medium */
font-family: "Inter Tight";
font-size: 14px;
font-style: normal;
font-weight: 500;
line-height: 150%; /* 21px */
letter-spacing: 0.28px;
    }
</style>

@endsection

@section('js')

    <script src="assets/libs/apexcharts/apexcharts.min.js"></script>

    <script src="assets/js/dashboard/analytics.init.js"></script>

    <!-- App js -->
    <script type="module" src="assets/js/app.js"></script>
@endsection

