@extends('partials.layouts.master')
@section('title','Hospital Department | FabKin')
@section('title-sub','Add new clinic')
@section('pagetitle','')

@section('content')

<style>
    body {
        background-color: white;
    }
    /* Custom Styles for Exact Design Match */
    .page-container {
        background-color: #f8f9fa;
        min-height: 100vh;
        padding: 20px;
    }
    
    .breadcrumb-custom {
        font-size: 14px;
        color: #6b7280;
        margin-bottom: 24px;
    }
    
    .breadcrumb-custom a {
        color: #6b7280;
        text-decoration: none;
    }
    
    .breadcrumb-custom a:hover {
        color: #374151;
    }
    
    .header-section {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 20px;
    }
    
    .page-title {
        font-size: 24px;
        font-weight: 600;
        color: #111827;
        margin: 0;
    }
    
    .btn-add-department {
        background-color: #3b82f6;
        color: white;
        border: none;
        padding: 10px 24px;
        border-radius: 8px;
        font-size: 14px;
        font-weight: 500;
    }
    
    .btn-add-department:hover {
        background-color: #2563eb;
    }
    
    .controls-section {
        background: white;
        border-radius: 12px;
        padding: 16px 20px;
        margin-bottom: 16px;
        display: flex;
        justify-content: space-between;
        align-items: center;
        box-shadow: 0 1px 3px rgba(0,0,0,0.1);
    }
    
    .search-box {
        position: relative;
        width: 300px;
    }
    
    .search-box input {
        width: 100%;
        padding: 8px 12px 8px 36px;
        border: 1px solid #e5e7eb;
        border-radius: 8px;
        font-size: 14px;
    }
    
    .search-box i {
        position: absolute;
        left: 12px;
        top: 50%;
        transform: translateY(-50%);
        color: #9ca3af;
    }
    
    .filter-sort-buttons {
        display: flex;
        gap: 8px;
    }
    
    .btn-filter, .btn-sort {
        background: white;
        border: 1px solid #e5e7eb;
        padding: 8px 16px;
        border-radius: 8px;
        font-size: 14px;
        color: #374151;
        display: flex;
        align-items: center;
        gap: 8px;
    }
    
    .btn-filter:hover, .btn-sort:hover {
        background-color: #f9fafb;
    }
    
    .table-container {
        background: white;
        border-radius: 12px;
        box-shadow: 0 1px 3px rgba(0,0,0,0.1);
        overflow: hidden;
    }
    
    .custom-table {
        width: 100%;
        margin: 0;
    }
    
    .custom-table thead {
        background-color: #f9fafb;
    }
    
    .custom-table thead th {
        padding: 16px 24px;
        font-size: 13px;
        font-weight: 600;
        color: #6b7280;
        text-transform: uppercase;
        letter-spacing: 0.5px;
        border-bottom: 1px solid #e5e7eb;
    }
    
    .custom-table tbody td {
        padding: 20px 24px;
        font-size: 14px;
        color: #111827;
        border-bottom: 1px solid #f3f4f6;
    }
    
    .custom-table tbody tr:hover {
        background-color: #f9fafb;
    }
    
    .custom-table tbody tr:last-child td {
        border-bottom: none;
    }
    
    .action-buttons {
        display: flex;
        gap: 12px;
        justify-content: flex-end;
    }
    
    .btn-action {
        background: none;
        border: none;
        padding: 4px;
        cursor: pointer;
        transition: all 0.2s;
    }
    
    .btn-action.view {
        color: #10b981;
    }
    
    .btn-action.edit {
        color: #3b82f6;
    }
    
    .btn-action.delete {
        color: #ef4444;
    }
    
    .btn-action:hover {
        opacity: 0.7;
        transform: scale(1.1);
    }
    
    .pagination-section {
        background: white;
        padding: 16px 24px;
        margin-top: 16px;
        display: flex;
        justify-content: space-between;
        align-items: center;
    }
    
    .pagination-info {
        font-size: 14px;
        color: #6b7280;
    }
    
    .pagination-controls {
        display: flex;
        align-items: center;
        gap: 20px;
    }
    
    .per-page-selector {
        display: flex;
        align-items: center;
        gap: 8px;
        font-size: 14px;
        color: #6b7280;
    }
    
    .per-page-selector select {
        padding: 4px 8px;
        border: 1px solid #e5e7eb;
        border-radius: 6px;
        font-size: 14px;
    }
    
    .pagination-buttons {
        display: flex;
        gap: 4px;
    }
    
    .page-btn {
        min-width: 36px;
        height: 36px;
        display: flex;
        align-items: center;
        justify-content: center;
        border: 1px solid #e5e7eb;
        background: white;
        border-radius: 6px;
        font-size: 14px;
        color: #374151;
        cursor: pointer;
        transition: all 0.2s;
    }
    
    .page-btn:hover:not(.active):not(.disabled) {
        background-color: #f9fafb;
    }
    
    .page-btn.active {
        background: linear-gradient(180deg, rgba(255, 255, 255, 0.12) 0%, rgba(255, 255, 255, 0.00) 100%), linear-gradient(180deg, #4598F9 0%, #3A77BF 100%); border: 1px solid #FFF; color: white;"
        color: white;
        border-color: #3b82f6;
    }
    
    .page-btn.disabled {
        opacity: 0.5;
        cursor: not-allowed;
    }
    
    .modal-content {
        border-radius: 12px;
        border: none;
    }
    
    .modal-header {
        border-bottom: 1px solid #f3f4f6;
        padding: 20px 24px;
    }
    
    .modal-title {
        font-size: 18px;
        font-weight: 600;
        color: #111827;
    }
    
    .modal-body {
        padding: 24px;
    }
    
    .modal-footer {
        border-top: 1px solid #f3f4f6;
        padding: 16px 24px;
    }
    .btn-primary{
        background-color: #3b82f6 !important;
        color: #ffffff !important;
        border: none !important;
    }
    .btn-primary:hover{
        background-color: #3b82f6 !important;
    }
    /* extra code */
       .btn {
        font-size: 14px;
        font-weight: 500;
        border-color: #e5e7eb !important; /* Tailwind's gray-200 */
    }

    .btn:hover {
        color: #374151 !important; /* text-gray-700 */
        /* box-shadow: 0 2px 5px rgba(0,0,0,0.08) !important; */
    }

    .rounded-xl {
        border-radius: 12px !important;
    }

    .shadow-sm {
        box-shadow: 0 1px 3px rgba(0, 0, 0, 0.05) !important;
    }
    .btnadd-person:hover {
        color: #ffffff !important;
    }
    #saveDepartmentBtn {
       background: linear-gradient(180deg, rgba(255, 255, 255, 0.12) 0%, rgba(255, 255, 255, 0.00) 100%), linear-gradient(180deg, #4598F9 0%, #3A77BF 100%); border: 1px solid #FFF; color: white;"
    }
     #saveDepartmentBtn:hover {
        color: #ffffff !important;
     }
     #updateDepartmentBtn {
               background: linear-gradient(180deg, rgba(255, 255, 255, 0.12) 0%, rgba(255, 255, 255, 0.00) 100%), linear-gradient(180deg, #4598F9 0%, #3A77BF 100%); border: 1px solid #FFF; color: white;"
     }
     #updateDepartmentBtn:hover {
        color: #ffffff !important;
     }
    
     .main-clinic-person{
    color: var(--Greyscale-400, #818898);
/* Body/Medium/Medium */
font-family: "Inter Tight";
font-size: 14px;
font-style: normal;
font-weight: 500;
line-height: 150%; /* 21px */
letter-spacing: 0.28px;
     }
     .main-clinic-person{
        color: var(--Greyscale-900, #0D0D12);
/* Body/Medium/Medium */
font-family: "Inter Tight";
font-size: 14px;
font-style: normal;
font-weight: 500;
line-height: 150%; /* 21px */
letter-spacing: 0.28px;
     }
     .all-person-text {
        color: var(--Greyscale-900, #0D0D12);
/* Body/Large/Semibold */
font-family: "Inter Tight";
font-size: 16px;
font-style: normal;
font-weight: 600;
line-height: 150%; /* 24px */
letter-spacing: 0.32px;
     }
     table thead th:nth-child(2) {
    border-right: none !important;
}
 table thead th:nth-child(3) {
    border-left: none !important;
}
</style>

<div class="p-0 m-2">
    <!-- Top Section: Breadcrumb + Button -->
   <div class="d-flex justify-content-between align-items-center mb-4 pb-0">
    
    <!-- Breadcrumb -->
    <div class="breadcrumb-custom d-flex align-items-center m-0 p-0">
        <a href="{{ route('clinics') }}" class="main-clinic-person">Home</a>
        <span class="mx-2 text-muted main-clinic-person">/</span>
        <a href="{{ route('add-new-Clinic') }}" class="main-clinic-person">Clinics</a>
        <span class="mx-2 text-muted main-clinic-person">/</span>
        <span class="main-clinic-person">All Persons</span>
    </div>

    <!-- Buttons Group -->
    <div class="d-flex gap-2">
        <!-- Export CSV Button -->
        <button type="button" 
                class="btn fw-bold px-4 py-2 fw-medium mb-0">
            <!-- <i class="bi bi-download me-1"></i> -->
            Export CSV
        </button>
        
        <!-- Add Person Button -->
        <button type="button" 
        class="btn px-4 py-2 fw-medium shadow-sm mb-0 btnadd-person" 
        style="background: linear-gradient(180deg, rgba(255, 255, 255, 0.12) 0%, rgba(255, 255, 255, 0.00) 100%), linear-gradient(180deg, #4598F9 0%, #3A77BF 100%); border: 1px solid #FFF; color: white;"
        data-bs-toggle="modal" 
        data-bs-target="#addDepartmentModal">
    Add Person
</button>
    </div>
    
</div>


   

   

    <!-- Controls (Search, Filter, Sort) -->
     <div class="p-4 ">

     
     <div class="p-4 rounded-4 border border-1">

     
  <div class="d-flex justify-content-between align-items-center mb-3">
    <!-- Left side -->
    <div>
        <h6 class="mb-0 all-person-text">All Persons</h6>
    </div>

    <!-- Right side -->
    <div class="d-flex align-items-cente">
        <!-- Search Box -->
        <div class="search-box d-flex align-items-center me-1">
            <i class="bi bi-search "></i>
            <input type="text" id="searchInput" placeholder="Search" class="form-control form-control-sm">
        </div>

        <!-- Filter & Sort Buttons -->
<!-- <div class="d-flex align-items-center space-x-2"> -->
    <!-- Filter Button -->
    <!-- <button type="button" class="btn me-1 bg-white border text-gray-600 d-flex align-items-center shadow-sm rounded-xl hover:bg-gray-50 transition px-3 py-2">
        <i class="bi bi-funnel me-1 text-gray-500"></i>
        Filter
    </button> -->

    <!-- Sort Button -->
    <!-- <button type="button" class="btn bg-white border text-gray-600 d-flex align-items-center shadow-sm rounded-xl hover:bg-gray-50 transition px-3 py-2">
        <i class="bi bi-arrow-down-up me-1 text-gray-500"></i>
        Sort by
    </button>
</div> -->

    </div>
</div>


    <!-- Table -->
    <div class="table">
        <table class=" table">
           <thead>
    <tr>
        <th style="color: var(--Greyscale-500, #666D80); ">
            Name
        </th>
        <th style="color:var(--Greyscale-500, #666D80); background-color: #f6f8fa;">
            User Name
        </th>
        <th style="text-align: right; color: var(--Greyscale-500, #666D80);">
            Actions
        </th>
    </tr>
</thead>
            <tbody id="departmentTableBody">
                <tr data-name="Stethoscope" data-username="jacksonlee" data-role="Employee">
                    <td>Stethoscope</td>
                    <td>jacksonlee</td>
                   
                    <td class="text-end py-3" style="white-space: nowrap;">
                                <button class="btn btn-sm me-1 edit-btn" style="background-color: #f0fbff; border: 1px solid #dee2e6; padding: 4px 8px;" onclick="editPerson(this)">
                                    <i class="bi bi-pencil" style="color: #33cfff; font-size: 14px;"></i>
                                </button>
                                <button class="btn btn-sm delete-btn" style="background-color: #fff0f3; border: 1px solid #dee2e6; padding: 4px 8px;" onclick="deletePerson(this)">
                                    <i class="bi bi-trash" style="color: red; font-size: 14px;"></i>
                                </button>
                            </td>
                </tr>
                <tr data-name="Blood Pressure Monitor" data-username="ethancarter" data-role="Employee">
                    <td>Blood Pressure Monitor</td>
                    <td>ethancarter</td>
                    
                     <td class="text-end py-3" style="white-space: nowrap;">
                                <button class="btn btn-sm me-1 edit-btn" style="background-color: #f0fbff; border: 1px solid #dee2e6; padding: 4px 8px;" onclick="editPerson(this)">
                                    <i class="bi bi-pencil" style="color: #33cfff; font-size: 14px;"></i>
                                </button>
                                <button class="btn btn-sm delete-btn" style="background-color: #fff0f3; border: 1px solid #dee2e6; padding: 4px 8px;" onclick="deletePerson(this)">
                                    <i class="bi bi-trash" style="color: red; font-size: 14px;"></i>
                                </button>
                            </td>
                    
                </tr>
                <tr data-name="Syringe" data-username="avamartinez" data-role="Employee">
                    <td>Syringe</td>
                    <td>avamartinez</td>
                    
                     <td class="text-end py-3" style="white-space: nowrap;">
                                <button class="btn btn-sm me-1 edit-btn" style="background-color: #f0fbff; border: 1px solid #dee2e6; padding: 4px 8px;" onclick="editPerson(this)">
                                    <i class="bi bi-pencil" style="color: #33cfff; font-size: 14px;"></i>
                                </button>
                                <button class="btn btn-sm delete-btn" style="background-color: #fff0f3; border: 1px solid #dee2e6; padding: 4px 8px;" onclick="deletePerson(this)">
                                    <i class="bi bi-trash" style="color: red; font-size: 14px;"></i>
                                </button>
                            </td>
                    
                </tr>
                <tr data-name="Thermometer" data-username="noahjohnson" data-role="Employee">
                    <td>Thermometer</td>
                    <td>noahjohnson</td>
                    
                     <td class="text-end py-3" style="white-space: nowrap;">
                                <button class="btn btn-sm me-1 edit-btn" style="background-color: #f0fbff; border: 1px solid #dee2e6; padding: 4px 8px;" onclick="editPerson(this)">
                                    <i class="bi bi-pencil" style="color: #33cfff; font-size: 14px;"></i>
                                </button>
                                <button class="btn btn-sm delete-btn" style="background-color: #fff0f3; border: 1px solid #dee2e6; padding: 4px 8px;" onclick="deletePerson(this)">
                                    <i class="bi bi-trash" style="color: red; font-size: 14px;"></i>
                                </button>
                            </td>
                    
                </tr>
                <tr data-name="Bandage Roll" data-username="lucaswhite" data-role="Employee">
                    <td>Bandage Roll</td>
                    <td>lucaswhite</td>
                    
                     <td class="text-end py-3" style="white-space: nowrap;">
                                <button class="btn btn-sm me-1 edit-btn" style="background-color: #f0fbff; border: 1px solid #dee2e6; padding: 4px 8px;" onclick="editPerson(this)">
                                    <i class="bi bi-pencil" style="color: #33cfff; font-size: 14px;"></i>
                                </button>
                                <button class="btn btn-sm delete-btn" style="background-color: #fff0f3; border: 1px solid #dee2e6; padding: 4px 8px;" onclick="deletePerson(this)">
                                    <i class="bi bi-trash" style="color: red; font-size: 14px;"></i>
                                </button>
                            </td>
                    
                </tr>
                <tr data-name="Oxygen Mask" data-username="lilybrown" data-role="Employee">
                    <td>Oxygen Mask</td>
                    <td>lilybrown</td>
                    
                     <td class="text-end py-3" style="white-space: nowrap;">
                                <button class="btn btn-sm me-1 edit-btn" style="background-color: #f0fbff; border: 1px solid #dee2e6; padding: 4px 8px;" onclick="editPerson(this)">
                                    <i class="bi bi-pencil" style="color: #33cfff; font-size: 14px;"></i>
                                </button>
                                <button class="btn btn-sm delete-btn" style="background-color: #fff0f3; border: 1px solid #dee2e6; padding: 4px 8px;" onclick="deletePerson(this)">
                                    <i class="bi bi-trash" style="color: red; font-size: 14px;"></i>
                                </button>
                            </td>
                    
                </tr>
                <tr data-name="IV Drip Set" data-username="sophiadavis" data-role="Employee">
                    <td>IV Drip Set</td>
                    <td>sophiadavis</td>
                   
                     <td class="text-end py-3" style="white-space: nowrap;">
                                <button class="btn btn-sm me-1 edit-btn" style="background-color: #f0fbff; border: 1px solid #dee2e6; padding: 4px 8px;" onclick="editPerson(this)">
                                    <i class="bi bi-pencil" style="color: #33cfff; font-size: 14px;"></i>
                                </button>
                                <button class="btn btn-sm delete-btn" style="background-color: #fff0f3; border: 1px solid #dee2e6; padding: 4px 8px;" onclick="deletePerson(this)">
                                    <i class="bi bi-trash" style="color: red; font-size: 14px;"></i>
                                </button>
                            </td>
                    
                </tr>
                <tr data-name="Electrocardiogram Machine" data-username="miathompson" data-role="Employee">
                    <td>Electrocardiogram Machine</td>
                    <td>miathompson</td>
                   
                     <td class="text-end py-3" style="white-space: nowrap;">
                                <button class="btn btn-sm me-1 edit-btn" style="background-color: #f0fbff; border: 1px solid #dee2e6; padding: 4px 8px;" onclick="editPerson(this)">
                                    <i class="bi bi-pencil" style="color: #33cfff; font-size: 14px;"></i>
                                </button>
                                <button class="btn btn-sm delete-btn" style="background-color: #fff0f3; border: 1px solid #dee2e6; padding: 4px 8px;" onclick="deletePerson(this)">
                                    <i class="bi bi-trash" style="color: red; font-size: 14px;"></i>
                                </button>
                            </td>
                    
                </tr>
                <tr data-name="Defibrillator" data-username="gracewilson" data-role="Employee">
                    <td>Defibrillator</td>
                    <td>gracewilson</td>
                    
                     <td class="text-end py-3" style="white-space: nowrap;">
                                <button class="btn btn-sm me-1 edit-btn" style="background-color: #f0fbff; border: 1px solid #dee2e6; padding: 4px 8px;" onclick="editPerson(this)">
                                    <i class="bi bi-pencil" style="color: #33cfff; font-size: 14px;"></i>
                                </button>
                                <button class="btn btn-sm delete-btn" style="background-color: #fff0f3; border: 1px solid #dee2e6; padding: 4px 8px;" onclick="deletePerson(this)">
                                    <i class="bi bi-trash" style="color: red; font-size: 14px;"></i>
                                </button>
                            </td>
                    
                </tr>
                <tr data-name="Surgical Scalpel" data-username="miathompson" data-role="Employee">
                    <td>Surgical Scalpel</td>
                    <td>miathompson</td>
                    
                     <td class="text-end py-3" style="white-space: nowrap;">
                                <button class="btn btn-sm me-1 edit-btn" style="background-color: #f0fbff; border: 1px solid #dee2e6; padding: 4px 8px;" onclick="editPerson(this)">
                                    <i class="bi bi-pencil" style="color: #33cfff; font-size: 14px;"></i>
                                </button>
                                <button class="btn btn-sm delete-btn" style="background-color: #fff0f3; border: 1px solid #dee2e6; padding: 4px 8px;" onclick="deletePerson(this)">
                                    <i class="bi bi-trash" style="color: red; font-size: 14px;"></i>
                                </button>
                            </td>
                    
                </tr>
            </tbody>
        </table>
    </div>

    <!-- Pagination -->
    <div class="pagination-section bg-white">
        <div class="pagination-info">
            Showing <span id="showingStart">1</span> to <span id="showingEnd">10</span> of <span id="totalResults">500</span> results
        </div>
        
        <div class="pagination-controls">
            <div class="per-page-selector">
                <span>Per page:</span>
                <select id="perPageSelect">
                    <option value="10" selected>10</option>
                    <option value="25">25</option>
                    <option value="50">50</option>
                    <option value="100">100</option>
                </select>
            </div>
            
            <div class="pagination-buttons">
                <button class="page-btn disabled" id="prevBtn">
                    <i class="bi bi-chevron-left"></i>
                </button>
                <button class="page-btn" data-page="1">1</button>
                <button class="page-btn" data-page="2">2</button>
                <button class="page-btn active" data-page="3">3</button>
                <button class="page-btn disabled">...</button>
                <button class="page-btn" data-page="5">5</button>
                <button class="page-btn" id="nextBtn">
                    <i class="bi bi-chevron-right"></i>
                </button>
            </div>
        </div>
    </div>
</div>
</div>

<!-- Add Department Modal -->
<div class="modal fade" id="addDepartmentModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Add Person</h5>
                <button type="button" data-bs-dismiss="modal" style="width: 36px; height: 36px; border-radius: 50%; border: 1px solid #D1D5DB; background-color: white; display: flex; align-items: center; justify-content: center; padding: 0; cursor: pointer; position: absolute; right: 20px; top: 20px;" onmouseover="this.style.backgroundColor='#f9fafb'" onmouseout="this.style.backgroundColor='white'">
                     <i class="bi bi-x" style="font-size: 20px; color: #000; font-weight: bold;"></i>
                </button> 
            </div>
            <div class="modal-body">
                <form id="addDepartmentForm">
                    <div class="mb-3">
                        <label class="form-label" style="color: #6b7280; font-size: 14px;">Person Name</label>
                        <input type="text" class="form-control" id="departmentName" placeholder="Name" required style="border: 1px solid #e5e7eb; border-radius: 8px; padding: 10px;">
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label" style="color: #6b7280; font-size: 14px;">Role</label>
                        <select class="form-select" id="personRole" required style="border: 1px solid #e5e7eb; border-radius: 8px; padding: 10px; background-color: #f0f9ff;">
                            <option value="Employee" selected>Employee</option>
                            <option value="Manager">Manager</option>
                            <option value="Admin">Admin</option>
                        </select>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label" style="color: #6b7280; font-size: 14px;">User Name</label>
                        <input type="text" class="form-control" id="personUsername" placeholder="user" required style="border: 1px solid #e5e7eb; border-radius: 8px; padding: 10px;">
                    </div>
                    
                     <!-- Password -->
     <div class="mb-3">
            <label for="password" class="form-label" style="color: #00000082;">
                Password <span class="text-danger">*</span>
            </label>
            <div class="input-group">
                <input type="password" name="password" class="form-control" id="password" 
                    placeholder="Enter your password" required style="border: 1px solid #e5e7eb; border-radius: 8px; padding: 10px;">
                <span class="input-group-text" id="togglePassword" style="cursor: pointer; border: 1px solid #e5e7eb; border-radius: 0 8px 8px 0;">
                    <i class="bi bi-eye" id="eyeIcon"></i>
                </span>
            </div>
        </div>
                    


          <div class="mb-3">
    <label class="form-label" style="color: #6b7280; font-size: 14px;">Access level</label>
    <div class="access-level-container" style="display: flex; justify-content: center; padding: 15px; border: 1px solid #e5e7eb; border-radius: 8px;">
        <div style="display: grid; grid-template-columns: repeat(3, 1fr); gap: 30px; max-width: 500px;">
            
            <!-- Cleaning -->
            <div class="form-check" style="display: flex; align-items: center; gap: 2px;">
                <input class="form-check-input" type="checkbox" value="Cleaning" id="accessCleaning" style="margin: 0;">
                <label class="form-check-label" for="accessCleaning" style="margin: 0; cursor: pointer;">
                    Cleaning
                </label>
            </div>

            <!-- Disinfection -->
            <div class="form-check" style="display: flex; align-items: center; gap: 2px;">
                <input class="form-check-input" type="checkbox" value="Disinfection" id="accessDisinfection" style="margin: 0;">
                <label class="form-check-label" for="accessDisinfection" style="margin: 0; cursor: pointer;">
                    Disinfection
                </label>
            </div>

            <!-- Sterilization -->
            <div class="form-check" style="display: flex; align-items: center; gap: 2px;">
                <input class="form-check-input" type="checkbox" value="Sterilization" id="accessSterilization" style="margin: 0;">
                <label class="form-check-label" for="accessSterilization" style="margin: 0; cursor: pointer;">
                    Sterilization
                </label>
            </div>

            <!-- Inventory -->
            <div class="form-check" style="display: flex; align-items: center; gap: 2px;">
                <input class="form-check-input" type="checkbox" value="Inventory" id="accessInventory" style="margin: 0;">
                <label class="form-check-label" for="accessInventory" style="margin: 0; cursor: pointer;">
                    Inventory
                </label>
            </div>

            <!-- Task -->
            <div class="form-check" style="display: flex; align-items: center; gap: 2px;">
                <input class="form-check-input" type="checkbox" value="Task" id="accessTask" style="margin: 0;">
                <label class="form-check-label" for="accessTask" style="margin: 0; cursor: pointer;">
                    Task
                </label>
            </div>

            <!-- Medical Waste -->
            <div class="form-check" style="display: flex; align-items: center; gap: 2px;">
                <input class="form-check-input" type="checkbox" value="Medical Waste" id="accessMedicalWaste" style="margin: 0;">
                <label class="form-check-label" for="accessMedicalWaste" style="margin: 0; cursor: pointer;">
                    Medical Waste
                </label>
            </div>
        </div>
    </div>
</div>


                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn" data-bs-dismiss="modal">Cancel</button>
                <button type="button" class="btn btn-primary" id="saveDepartmentBtn">Save</button>
            </div>
        </div>
    </div>
</div>

<!-- Edit Department Modal -->
<div class="modal fade" id="editDepartmentModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Edit Person</h5>
                <button type="button" data-bs-dismiss="modal" style="width: 36px; height: 36px; border-radius: 50%; border: 1px solid #D1D5DB; background-color: white; display: flex; align-items: center; justify-content: center; padding: 0; cursor: pointer; position: absolute; right: 20px; top: 20px;" onmouseover="this.style.backgroundColor='#f9fafb'" onmouseout="this.style.backgroundColor='white'">
                     <i class="bi bi-x" style="font-size: 20px; color: #000; font-weight: bold;"></i>
                </button>            
             </div>
            <div class="modal-body">
                <form id="editDepartmentForm">
                    <div class="mb-3">
                        <label class="form-label" style="color: #6b7280; font-size: 14px;">Person Name</label>
                        <input type="text" class="form-control" id="editDepartmentName" placeholder="Name" required style="border: 1px solid #e5e7eb; border-radius: 8px; padding: 10px;">
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label" style="color: #6b7280; font-size: 14px;">Role</label>
                        <select class="form-select" id="editPersonRole" required style="border: 1px solid #e5e7eb; border-radius: 8px; padding: 10px; background-color: #f0f9ff;">
                            <option value="Employee">Employee</option>
                            <option value="Manager">Manager</option>
                            <option value="Admin">Admin</option>
                        </select>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label" style="color: #6b7280; font-size: 14px;">User Name</label>
                        <input type="text" class="form-control" id="editPersonUsername" placeholder="user" required style="border: 1px solid #e5e7eb; border-radius: 8px; padding: 10px;">
                    </div>
                    
                     <!-- Password -->
     <div class="mb-3">
            <label for="editPassword" class="form-label" style="color: #00000082;">
                Password <span class="text-danger">*</span>
            </label>
            <div class="input-group">
                <input type="password" name="password" class="form-control" id="editPassword" 
                    placeholder="Enter your password" required style="border: 1px solid #e5e7eb; border-radius: 8px; padding: 10px;">
                <span class="input-group-text" id="editTogglePassword" style="cursor: pointer; border: 1px solid #e5e7eb; border-radius: 0 8px 8px 0;">
                    <i class="bi bi-eye" id="editEyeIcon"></i>
                </span>
            </div>
        </div>
                    
        
             <div class="mb-3">
    <label class="form-label" style="color: #6b7280; font-size: 14px;">Access level</label>
    <div class="access-level-container" style="display: flex; justify-content: center; padding: 15px; border: 1px solid #e5e7eb; border-radius: 8px;">
        <div style="display: grid; grid-template-columns: repeat(3, 1fr); gap: 30px; max-width: 500px;">
            
            <!-- Cleaning -->
            <div class="form-check" style="display: flex; align-items: center; gap: 2px;">
                <input class="form-check-input" type="checkbox" value="Cleaning" id="accessCleaning" style="margin: 0;">
                <label class="form-check-label" for="accessCleaning" style="margin: 0; cursor: pointer;">
                    Cleaning
                </label>
            </div>

            <!-- Disinfection -->
            <div class="form-check" style="display: flex; align-items: center; gap: 2px;">
                <input class="form-check-input" type="checkbox" value="Disinfection" id="accessDisinfection" style="margin: 0;">
                <label class="form-check-label" for="accessDisinfection" style="margin: 0; cursor: pointer;">
                    Disinfection
                </label>
            </div>

            <!-- Sterilization -->
            <div class="form-check" style="display: flex; align-items: center; gap: 2px;">
                <input class="form-check-input" type="checkbox" value="Sterilization" id="accessSterilization" style="margin: 0;">
                <label class="form-check-label" for="accessSterilization" style="margin: 0; cursor: pointer;">
                    Sterilization
                </label>
            </div>

            <!-- Inventory -->
            <div class="form-check" style="display: flex; align-items: center; gap: 2px;">
                <input class="form-check-input" type="checkbox" value="Inventory" id="accessInventory" style="margin: 0;">
                <label class="form-check-label" for="accessInventory" style="margin: 0; cursor: pointer;">
                    Inventory
                </label>
            </div>

            <!-- Task -->
            <div class="form-check" style="display: flex; align-items: center; gap: 2px;">
                <input class="form-check-input" type="checkbox" value="Task" id="accessTask" style="margin: 0;">
                <label class="form-check-label" for="accessTask" style="margin: 0; cursor: pointer;">
                    Task
                </label>
            </div>

            <!-- Medical Waste -->
            <div class="form-check" style="display: flex; align-items: center; gap: 2px;">
                <input class="form-check-input" type="checkbox" value="Medical Waste" id="accessMedicalWaste" style="margin: 0;">
                <label class="form-check-label" for="accessMedicalWaste" style="margin: 0; cursor: pointer;">
                    Medical Waste
                </label>
            </div>
        </div>
    </div>
</div>
        
        
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn" data-bs-dismiss="modal">Cancel</button>
                <button type="button" class="btn btn-primary" id="updateDepartmentBtn">Update</button>
            </div>
        </div>
    </div>
</div>

<!-- View Department Modal -->
<div class="modal fade" id="viewDepartmentModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Department Details</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="mb-3">
                    <label class="form-label text-muted">Department Name</label>
                    <p class="fw-bold" id="viewDepartmentName" style="font-size: 16px; color: #111827;"></p>
                </div>
                <div class="mb-3">
                    <label class="form-label text-muted">Created Date</label>
                    <p class="fw-bold" style="font-size: 16px; color: #111827;">October 10, 2025</p>
                </div>
                <div class="mb-3">
                    <label class="form-label text-muted">Status</label>
                    <p><span class="badge bg-success">Active</span></p>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>

</div>

<script>
// Simple functions for edit and delete
function editPerson(button) {
    const row = button.closest('tr');
    const name = row.getAttribute('data-name');
    const username = row.getAttribute('data-username');
    const role = row.getAttribute('data-role');
    
    // Populate the edit form
    document.getElementById('editDepartmentName').value = name;
    document.getElementById('editPersonUsername').value = username;
    document.getElementById('editPersonRole').value = role;
    
    // Store the row reference for updating
    document.getElementById('editDepartmentModal').setAttribute('data-editing-row', Array.from(row.parentNode.children).indexOf(row));
    
    // Show the modal
    const editModal = new bootstrap.Modal(document.getElementById('editDepartmentModal'));
    editModal.show();
}

function deletePerson(button) {
    if(confirm('Are you sure you want to delete this person?')) {
        const row = button.closest('tr');
        row.remove();
    }
}

document.addEventListener('DOMContentLoaded', function() {
    let allDepartments = [];
    let allUsernames = [];
    let currentSortOrder = 'asc';
    let currentFilter = 'all';
    
    // ============ UPDATE MODAL CONTENT ============
    
    // Update Add Modal with new form fields
    const addModal = document.getElementById('addDepartmentModal');
    if(addModal) {
        const modalTitle = addModal.querySelector('.modal-title');
        const modalBody = addModal.querySelector('.modal-body');
        
        if(modalTitle) {
            modalTitle.textContent = 'Add Person';
        }
    }
    
    // Update Edit Modal
    const editModal = document.getElementById('editDepartmentModal');
    if(editModal) {
        const modalTitle = editModal.querySelector('.modal-title');
        
        if(modalTitle) {
            modalTitle.textContent = 'Edit Person';
        }
    }
    
    // Initialize departments and usernames from table
    function initializeDepartments() {
        allDepartments = [];
        allUsernames = [];
        document.querySelectorAll('#departmentTableBody tr').forEach(row => {
            allDepartments.push(row.getAttribute('data-name'));
            const username = row.querySelector('td:nth-child(2)').textContent;
            allUsernames.push(username);
        });
    }
    
    initializeDepartments();
    
    // ============ FILTER & SORT DROPDOWNS ============
    
    // Create Filter Dropdown
    function createFilterDropdown() {
        const filterBtn = document.querySelector('button i.bi-funnel')?.closest('button');
        if(!filterBtn) return;
        
        const dropdownMenu = document.createElement('div');
        dropdownMenu.className = 'dropdown-menu shadow-sm';
        dropdownMenu.style.cssText = 'min-width: 150px; background: white; border: 1px solid #e0e0e0;';
        dropdownMenu.innerHTML = `
            <a class="dropdown-item filter-option" href="#" data-filter="all" style="color: #333; background: white !important;">
                All Persons
            </a>
            <a class="dropdown-item filter-option" href="#" data-filter="active" style="color: #333; background: white !important;">
                Active
            </a>
            <a class="dropdown-item filter-option" href="#" data-filter="inactive" style="color: #333; background: white !important;">
                Inactive
            </a>
        `;
        
        const style = document.createElement('style');
        style.textContent = `
            .dropdown-item.filter-option:hover,
            .dropdown-item.filter-option:focus,
            .dropdown-item.filter-option:active {
                background-color: #f5f5f5 !important;
                color: #333 !important;
            }
            .dropdown-item.filter-option.active {
                background-color: #e8e8e8 !important;
                color: #333 !important;
                font-weight: 500;
            }
        `;
        document.head.appendChild(style);
        
        filterBtn.setAttribute('data-bs-toggle', 'dropdown');
        filterBtn.setAttribute('data-bs-auto-close', 'true');
        
        const dropdownDiv = document.createElement('div');
        dropdownDiv.className = 'dropdown d-inline-block';
        filterBtn.parentNode.insertBefore(dropdownDiv, filterBtn);
        dropdownDiv.appendChild(filterBtn);
        dropdownDiv.appendChild(dropdownMenu);
        
        dropdownMenu.querySelectorAll('.filter-option').forEach(option => {
            option.addEventListener('click', function(e) {
                e.preventDefault();
                const filterValue = this.getAttribute('data-filter');
                currentFilter = filterValue;
                applyFilter(filterValue);
                
                const btnText = this.textContent.trim();
                filterBtn.innerHTML = `
                    <i class="bi bi-funnel me-1 text-gray-500"></i>
                    ${btnText}
                `;
            });
        });
        
        filterBtn.addEventListener('show.bs.dropdown', function() {
            dropdownMenu.querySelectorAll('.filter-option').forEach(opt => {
                opt.style.backgroundColor = 'white';
                opt.style.fontWeight = 'normal';
            });
        });
    }
    
    // Create Sort Dropdown
    function createSortDropdown() {
        const sortBtn = document.querySelector('button i.bi-arrow-down-up')?.closest('button');
        if(!sortBtn) return;
        
        const dropdownMenu = document.createElement('div');
        dropdownMenu.className = 'dropdown-menu shadow-sm';
        dropdownMenu.style.cssText = 'min-width: 150px; background: white; border: 1px solid #e0e0e0;';
        dropdownMenu.innerHTML = `
            <a class="dropdown-item sort-option" href="#" data-sort="asc" style="color: #333; background: white !important;">
                A to Z
            </a>
            <a class="dropdown-item sort-option" href="#" data-sort="desc" style="color: #333; background: white !important;">
                Z to A
            </a>
        `;
        
        const style = document.createElement('style');
        style.textContent = `
            .dropdown-item.sort-option:hover,
            .dropdown-item.sort-option:focus,
            .dropdown-item.sort-option:active {
                background-color: #f5f5f5 !important;
                color: #333 !important;
            }
            .dropdown-item.sort-option.active {
                background-color: #e8e8e8 !important;
                color: #333 !important;
                font-weight: 500;
            }
        `;
        document.head.appendChild(style);
        
        sortBtn.setAttribute('data-bs-toggle', 'dropdown');
        sortBtn.setAttribute('data-bs-auto-close', 'true');
        
        const dropdownDiv = document.createElement('div');
        dropdownDiv.className = 'dropdown d-inline-block';
        sortBtn.parentNode.insertBefore(dropdownDiv, sortBtn);
        dropdownDiv.appendChild(sortBtn);
        dropdownDiv.appendChild(dropdownMenu);
        
        dropdownMenu.querySelectorAll('.sort-option').forEach(option => {
            option.addEventListener('click', function(e) {
                e.preventDefault();
                const sortValue = this.getAttribute('data-sort');
                currentSortOrder = sortValue;
                sortTable(sortValue);
                
                const btnText = this.textContent.trim();
                sortBtn.innerHTML = `
                    <i class="bi bi-arrow-down-up me-1 text-gray-500"></i>
                    ${btnText}
                `;
            });
        });
        
        sortBtn.addEventListener('show.bs.dropdown', function() {
            dropdownMenu.querySelectorAll('.sort-option').forEach(opt => {
                opt.style.backgroundColor = 'white';
                opt.style.fontWeight = 'normal';
            });
        });
    }
    
    createFilterDropdown();
    createSortDropdown();
    
    // ============ FILTER FUNCTIONALITY ============
    
    function applyFilter(filterValue) {
        const rows = document.querySelectorAll('#departmentTableBody tr');
        let visibleCount = 0;
        
        rows.forEach(row => {
            const searchInput = document.getElementById('searchInput');
            const searchTerm = searchInput ? searchInput.value.toLowerCase() : '';
            const name = row.getAttribute('data-name').toLowerCase();
            const matchesSearch = name.includes(searchTerm);
            
            if(filterValue === 'all') {
                if(matchesSearch) {
                    row.style.display = '';
                    visibleCount++;
                } else {
                    row.style.display = 'none';
                }
            } else {
                const status = row.getAttribute('data-status') || 'active';
                if(status === filterValue && matchesSearch) {
                    row.style.display = '';
                    visibleCount++;
                } else {
                    row.style.display = 'none';
                }
            }
        });
        
        updatePaginationInfo(visibleCount);
    }
    
    // ============ SORT FUNCTIONALITY ============
    
    function sortTable(order) {
        const tbody = document.getElementById('departmentTableBody');
        const rows = Array.from(tbody.querySelectorAll('tr'));
        
        rows.sort((a, b) => {
            const nameA = a.getAttribute('data-name').toLowerCase();
            const nameB = b.getAttribute('data-name').toLowerCase();
            
            if(order === 'asc') {
                return nameA.localeCompare(nameB);
            } else {
                return nameB.localeCompare(nameA);
            }
        });
        
        tbody.innerHTML = '';
        rows.forEach(row => {
            tbody.appendChild(row);
        });
        
        applyFilter(currentFilter);
    }
    
    // ============ SEARCH FUNCTIONALITY ============
    
    const searchInput = document.getElementById('searchInput');
    if(searchInput) {
        searchInput.addEventListener('input', function(e) {
            applyFilter(currentFilter);
        });
    }
    
    // ============ ADD PERSON ============
    
    const saveBtn = document.getElementById('saveDepartmentBtn');
    if(saveBtn) {
        saveBtn.addEventListener('click', function() {
            const name = document.getElementById('departmentName').value.trim();
            const role = document.getElementById('personRole').value;
            const username = document.getElementById('personUsername').value.trim();
            const password = document.getElementById('password').value;
            
            if(!name || !username || !password) {
                alert('Please fill all required fields');
                return;
            }
            
            if(allDepartments.includes(name)) {
                alert('Person already exists!');
                return;
            }
            
            if(allUsernames.includes(username)) {
                alert('Username already exists!');
                return;
            }
            
            const tbody = document.getElementById('departmentTableBody');
            const newRow = document.createElement('tr');
            newRow.setAttribute('data-name', name);
            newRow.setAttribute('data-username', username);
            newRow.setAttribute('data-role', role);
            newRow.setAttribute('data-status', 'active');
            newRow.innerHTML = `
                <td>${name}</td>
                <td>${username}</td>
                <td class="text-end py-3" style="white-space: nowrap;">
                    <button class="btn btn-sm me-1 edit-btn" style="background-color: #f0fbff; border: 1px solid #dee2e6; padding: 4px 8px;" onclick="editPerson(this)">
                        <i class="bi bi-pencil" style="color: #33cfff; font-size: 14px;"></i>
                    </button>
                    <button class="btn btn-sm delete-btn" style="background-color: #fff0f3; border: 1px solid #dee2e6; padding: 4px 8px;" onclick="deletePerson(this)">
                        <i class="bi bi-trash" style="color: red; font-size: 14px;"></i>
                    </button>
                </td>
            `;
            
            tbody.insertBefore(newRow, tbody.firstChild);
            allDepartments.unshift(name);
            allUsernames.unshift(username);
            
            document.getElementById('departmentName').value = '';
            document.getElementById('personUsername').value = '';
            document.getElementById('password').value = '';
            
            const modal = bootstrap.Modal.getInstance(document.getElementById('addDepartmentModal'));
            if(modal) modal.hide();
            
            updatePaginationInfo(document.querySelectorAll('#departmentTableBody tr').length);
        });
    }
    
    // ============ UPDATE PERSON ============
    
    const updateBtn = document.getElementById('updateDepartmentBtn');
    if(updateBtn) {
        updateBtn.addEventListener('click', function() {
            const newName = document.getElementById('editDepartmentName').value.trim();
            const newUsername = document.getElementById('editPersonUsername').value.trim();
            const newRole = document.getElementById('editPersonRole').value;
            
            if(!newName || !newUsername) {
                alert('Please fill all required fields');
                return;
            }
            
            const editModal = document.getElementById('editDepartmentModal');
            const rowIndex = parseInt(editModal.getAttribute('data-editing-row'));
            const rows = document.querySelectorAll('#departmentTableBody tr');
            const currentRow = rows[rowIndex];
            
            if(currentRow) {
                const oldName = currentRow.getAttribute('data-name');
                const oldUsername = currentRow.getAttribute('data-username');
                
                if(newName !== oldName && allDepartments.includes(newName)) {
                    alert('Person already exists!');
                    return;
                }
                
                if(newUsername !== oldUsername && allUsernames.includes(newUsername)) {
                    alert('Username already exists!');
                    return;
                }
                
                const nameIndex = allDepartments.indexOf(oldName);
                if(nameIndex > -1) {
                    allDepartments[nameIndex] = newName;
                }
                
                const usernameIndex = allUsernames.indexOf(oldUsername);
                if(usernameIndex > -1) {
                    allUsernames[usernameIndex] = newUsername;
                }
                
                currentRow.setAttribute('data-name', newName);
                currentRow.setAttribute('data-username', newUsername);
                currentRow.setAttribute('data-role', newRole);
                
                const tds = currentRow.querySelectorAll('td');
                if(tds[0]) tds[0].textContent = newName;
                if(tds[1]) tds[1].textContent = newUsername;
            }
            
            const modal = bootstrap.Modal.getInstance(editModal);
            if(modal) modal.hide();
        });
    }
    
    // ============ PAGINATION ============
    
    function updatePaginationInfo(count) {
        const showingEndElement = document.getElementById('showingEnd');
        const totalResultsElement = document.getElementById('totalResults');
        
        if(showingEndElement) {
            showingEndElement.textContent = count;
        }
        if(totalResultsElement) {
            totalResultsElement.textContent = allDepartments.length;
        }
    }
    
    // ============ PAGINATION BUTTONS ============
    
    document.querySelectorAll('.page-btn[data-page]').forEach(btn => {
        btn.addEventListener('click', function() {
            document.querySelectorAll('.page-btn').forEach(b => b.classList.remove('active'));
            this.classList.add('active');
        });
    });
    
    const perPageSelect = document.getElementById('perPageSelect');
    if(perPageSelect) {
        perPageSelect.addEventListener('change', function() {
            updatePaginationInfo(parseInt(this.value));
        });
    }
});

// hide and show password
  document.addEventListener("DOMContentLoaded", function () {
        const passwordInput = document.getElementById("password");
        const togglePassword = document.getElementById("togglePassword");
        const eyeIcon = document.getElementById("eyeIcon");

        togglePassword.addEventListener("click", () => {
            const type = passwordInput.getAttribute("type") === "password" ? "text" : "password";
            passwordInput.setAttribute("type", type);

            // Change icon
            if (type === "password") {
                eyeIcon.classList.remove("bi-eye-slash");
                eyeIcon.classList.add("bi-eye");
            } else {
                eyeIcon.classList.remove("bi-eye");
                eyeIcon.classList.add("bi-eye-slash");
            }
        });
        
        // For edit password
        const editPasswordInput = document.getElementById("editPassword");
        const editTogglePassword = document.getElementById("editTogglePassword");
        const editEyeIcon = document.getElementById("editEyeIcon");

        if(editTogglePassword) {
            editTogglePassword.addEventListener("click", () => {
                const type = editPasswordInput.getAttribute("type") === "password" ? "text" : "password";
                editPasswordInput.setAttribute("type", type);

                // Change icon
                if (type === "password") {
                    editEyeIcon.classList.remove("bi-eye-slash");
                    editEyeIcon.classList.add("bi-eye");
                } else {
                    editEyeIcon.classList.remove("bi-eye");
                    editEyeIcon.classList.add("bi-eye-slash");
                }
            });
        }
    });

</script>

@endsection