@extends('partials.layouts.master')

@section('title', 'All Cleaning | FabKin Admin & Dashboards Template')
@section('title-sub', 'All Cleaning')

@section('pagetitle')
<div x-data @click.outside="showModal = false" class="d-flex justify-content-between align-items-center mb-3">
    <div class="flex items-center space-x-2 text-sm font-medium">
        <span class="text-gray-500 hover:text-gray-700 transition duration-150">Home</span>
        <span class="text-gray-400">/</span>
        <span class="text-gray-500 hover:text-gray-700 transition duration-150">Clinics</span>
        <span class="text-gray-400">/</span>
        <span class="text-gray-500 hover:text-gray-700 transition duration-150">Moduls</span>
        <span class="text-gray-400">/</span>
        <span class="text-gray-900 font-bold">All Cleaning</span>
    </div>
    <div class="d-flex">
        <a href="#" 
           class="btn px-5 me-2 fw-bold" 
           style="border: 1px solid #00000034; color: #000;" 
           @click.prevent="exportCSV()">
           Export CSV
        </a>
        <a href="#" 
           class="btn text-white px-5" 
           style="background-color: #4598F9;" 
           @click.prevent="openAddModal()">
           Add Cleaning
        </a>
    </div>
</div>
@endsection

@section('content')

<script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>

<div class="container-fluid" x-data="cleaningManager">

    <div class="border border-2 p-4 bg-white" style="border-radius: 6px;">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <div>
                <h4 class="fw-bold mb-0">All Cleaning</h4>
            </div>
            <div class="d-flex gap-2">
                <!-- Search Input -->
                <div class="input-group" style="max-width: 280px; border: 1px solid #dee2e6; border-radius: 12px; overflow: hidden;">
                    <span class="input-group-text bg-white" style="border: none; border-radius: 20px 0 0 20px;">
                        <i class="bi bi-search text-muted"></i>
                    </span>
                    <input 
                        type="text" 
                        class="form-control ps-0" 
                        placeholder="Search" 
                        x-model="searchQuery"
                        style="border: none; height: 40px; outline: none; box-shadow: none;">
                </div>
                
                <!-- Filter Button -->
                <button class="btn btn-light filter bg-white d-flex align-items-center gap-2" 
                        @click="showFilterModal = true"
                        style="border-radius: 12px; padding: 8px 20px; border: 1px solid #e0e0e0; width:100px; height:40px;">
                    <i class="bi bi-funnel"></i>
                    <span>Filter</span>
                </button>
                
                <!-- Sort By Button -->
                <button class="btn btn-light sort bg-white d-flex align-items-center gap-2" 
                        @click="toggleSort()"
                        style="border-radius: 12px; padding: 8px 20px; border: 1px solid #e0e0e0; width:140px; height:40px;">
                    <i class="bi bi-arrow-down-up"></i>
                    <span>Sort by</span>
                </button>
            </div>
        </div>

        <!-- Cleaning Table -->
        <div class="card border-0">
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table align-middle mb-0">
                        <thead class="table-light">
                            <tr>
                                <th class="border-0 py-3">Hospital Department</th>
                                <th class="border-0 py-3">Room</th>
                                <th class="border-0 py-3">Machine Status</th>
                                <th class="border-0 py-3">Machine</th>
                                <th class="border-0 py-3">Cleaning Product</th>
                                <th class="border-0 py-3">Type</th>
                                <th class="border-0 py-3">Times a day</th>
                                <th class="border-0 py-3">Responsible person</th>
                                <th class="border-0 py-3">Date</th>
                                <th class="border-0 py-3">Status</th>
                                <th class="border-0 py-3">Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <template x-if="filteredCleanings.length === 0">
                                <tr>
                                    <td colspan="11" class="text-center text-muted py-4">No matching records found.</td>
                                </tr>
                            </template>

                            <template x-for="(cleaning, index) in paginatedCleanings" :key="index">
                                <tr>
                                    <td class="py-3" x-text="cleaning.department"></td>
                                    <td class="py-3" x-text="cleaning.room"></td>
                                    <td class="py-3" x-text="cleaning.machineStatus"></td>
                                    <td class="py-3" x-text="cleaning.machine"></td>
                                    <td class="py-3" x-text="cleaning.product"></td>
                                    <td class="py-3" x-text="cleaning.type"></td>
                                    <td class="py-3" x-text="cleaning.timesADay"></td>
                                    <td class="py-3" x-text="cleaning.responsible"></td>
                                    <td class="py-3" x-text="cleaning.date"></td>
                                    <td class="py-3">
                                        <span class="status-badge" 
                                              :class="cleaning.status === 'Finished' ? 'status-finished' : 'status-active'">
                                            <span class="status-dot"></span>
                                            <span x-text="cleaning.status"></span>
                                        </span>
                                    </td>
                                    <td class="text-end py-3">
                                        <div class="d-inline-flex align-items-center gap-1">
                                            <!-- View Button -->
                                            <button class="action-btn action-view" 
                                                    @click="viewCleaning(index)"
                                                    title="View">
                                                <i class="bi bi-eye"></i>
                                            </button>
                                            <!-- Edit Button -->
                                            <button class="action-btn action-edit" 
                                                    @click="openEditModal(index)"
                                                    title="Edit">
                                                <i class="bi bi-pencil"></i>
                                            </button>
                                            <!-- Delete Button -->
                                            <button class="action-btn action-delete" 
                                                    @click="deleteCleaning(index)"
                                                    title="Delete">
                                                <i class="bi bi-trash"></i>
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                            </template>
                        </tbody>
                    </table>
                </div>

                <!-- Pagination -->
                <div class="d-flex justify-content-between align-items-center mt-4 px-3 border-top pt-3">
                    <div class="text-muted">
                        Showing <span x-text="startIndex + 1"></span> to <span x-text="endIndex"></span>
                    </div>
                    
                    <div class="d-flex gap-3 align-items-center">
                        <!-- Per page dropdown -->
                        <div class="text-muted">Per page</div>
                        <select class="form-select form-select-sm" 
                                style="width: 70px; border-radius: 8px;" 
                                x-model="itemsPerPage" 
                                @change="resetPagination">
                            <option value="10">10</option>
                            <option value="25">25</option>
                            <option value="50">50</option>
                            <option value="100">100</option>
                        </select>
                        
                        <!-- Pagination buttons -->
                        <div class="pagination-container d-flex align-items-center">
                            <button class="pagination-btn prev-btn" 
                                    @click="prevPage" 
                                    :disabled="currentPage === 1">
                                <i class="bi bi-chevron-left"></i>
                            </button>
                            
                            <template x-for="page in visiblePages" :key="page">
                                <button class="pagination-btn" 
                                        :class="page === currentPage ? 'active' : ''"
                                        @click="goToPage(page)"
                                        x-text="page"></button>
                            </template>
                            
                            <button class="pagination-btn next-btn" 
                                    @click="nextPage" 
                                    :disabled="currentPage === totalPages">
                                <i class="bi bi-chevron-right"></i>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Filter Modal -->
    <template x-if="showFilterModal">
        <div class="modal fade show d-block"
             tabindex="-1"
             @click.self="showFilterModal = false"
             style="background-color: rgba(0,0,0,0.5);">
            <div class="modal-dialog modal-dialog-centered" style="max-width: 400px;">
                <div class="modal-content" style="border-radius: 16px; border: none;">
                    <div class="modal-header border-0 pb-2">
                        <h5 class="modal-title fw-bold d-flex align-items-center gap-2">
                            <span style="color: #7c3aed;">
                                <i class="bi bi-funnel-fill"></i>
                            </span>
                            Filter
                        </h5>
                        <button type="button" 
                                class="btn-close" 
                                @click="showFilterModal = false"></button>
                    </div>
                    <div class="modal-body px-4 py-3">
                        <form>
                            <!-- Department Filter -->
                            <div class="mb-4">
                                <label class="form-label fw-semibold mb-2" style="font-size: 14px; color: #666;">Department</label>
                                <input type="text" 
                                       class="form-control" 
                                       x-model="filters.department"
                                       placeholder="Enter department"
                                       style="border-radius: 10px; padding: 10px 15px; border: 1px solid #dee2e6; background-color: #f8f9fa;">
                            </div>

                            <!-- Status Filter -->
                            <div class="mb-4">
                                <label class="form-label fw-semibold mb-2" style="font-size: 14px; color: #666;">Status</label>
                                <select class="form-select" 
                                        x-model="filters.status"
                                        style="border-radius: 10px; padding: 10px 15px; border: 1px solid #dee2e6; background-color: #f8f9fa;">
                                    <option value="">All</option>
                                    <option value="Finished">Finished</option>
                                    <option value="Active">Active</option>
                                </select>
                            </div>
                        </form>
                    </div>
                    <div class="modal-footer border-0 pt-0 px-4 pb-4">
                        <button type="button" 
                                class="btn btn-light" 
                                @click="resetFilters()"
                                style="border-radius: 10px; padding: 10px 28px; border: 1px solid #dee2e6; font-weight: 500;">
                            Cancel
                        </button>
                        <button type="button" 
                                class="btn text-white" 
                                @click="applyFilters()"
                                style="background-color: #4598F9; border-radius: 10px; padding: 10px 28px; font-weight: 500;">
                            Apply Filter
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </template>

    <!-- Add/Edit Modal -->
    <template x-if="showModal">
        <div class="modal fade show d-block"
             tabindex="-1"
             @click.self="resetModal()"
             style="background-color: rgba(0,0,0,0.5);">
            <div class="modal-dialog modal-dialog-centered modal-lg">
                <div class="modal-content" style="border-radius: 12px; border: none;">
                    <div class="modal-header border-0 pb-0">
                        <h5 class="modal-title fw-bold" x-text="isEditing ? 'Edit Cleaning Record' : 'Add Cleaning Record'"></h5>
                        <button type="button" class="btn-close" @click="resetModal()"></button>
                    </div>
                    <div class="modal-body px-4 py-4">
                        <form @submit.prevent="saveCleaning()">
                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label class="form-label text-muted" style="font-size: 14px;">Hospital Department</label>
                                    <input type="text" class="form-control" x-model="cleaning.department" required>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label text-muted" style="font-size: 14px;">Room</label>
                                    <input type="text" class="form-control" x-model="cleaning.room" required>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label text-muted" style="font-size: 14px;">Machine Status</label>
                                    <select class="form-select" x-model="cleaning.machineStatus" required>
                                        <option value="Yes">Yes</option>
                                        <option value="No">No</option>
                                    </select>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label text-muted" style="font-size: 14px;">Machine</label>
                                    <input type="text" class="form-control" x-model="cleaning.machine">
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label text-muted" style="font-size: 14px;">Cleaning Product</label>
                                    <input type="text" class="form-control" x-model="cleaning.product" required>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label text-muted" style="font-size: 14px;">Type</label>
                                    <select class="form-select" x-model="cleaning.type" required>
                                        <option value="Daily">Daily</option>
                                        <option value="Weekly">Weekly</option>
                                        <option value="Monthly">Monthly</option>
                                    </select>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label text-muted" style="font-size: 14px;">Times a day</label>
                                    <select class="form-select" x-model="cleaning.timesADay" required>
                                        <option value="Morning">Morning</option>
                                        <option value="Evening">Evening</option>
                                        <option value="Morning & Evening">Morning & Evening</option>
                                    </select>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label text-muted" style="font-size: 14px;">Responsible Person</label>
                                    <input type="text" class="form-control" x-model="cleaning.responsible">
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label text-muted" style="font-size: 14px;">Date</label>
                                    <input type="text" class="form-control" x-model="cleaning.date" required>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label text-muted" style="font-size: 14px;">Status</label>
                                    <select class="form-select" x-model="cleaning.status" required>
                                        <option value="Finished">Finished</option>
                                        <option value="Active">Active</option>
                                    </select>
                                </div>
                            </div>
                        </form>
                    </div>
                    <div class="modal-footer border-0 pt-0 px-4 pb-4">
                        <button type="button" 
                                class="btn btn-light"
                                @click="resetModal()"
                                style="border-radius: 8px; padding: 8px 24px; border: 1px solid #dee2e6;">
                            Cancel
                        </button>
                        <button type="button" 
                                class="btn text-white"
                                @click="saveCleaning()"
                                style="background-color: #4598F9; border-radius: 8px; padding: 8px 24px;">
                            Save
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </template>
</div>

<script>
document.addEventListener('alpine:init', () => {
    Alpine.data('cleaningManager', () => ({
        showModal: false,
        showFilterModal: false,
        isEditing: false,
        editIndex: null,
        cleaning: {
            department: '',
            room: '',
            machineStatus: 'Yes',
            machine: '',
            product: '',
            type: 'Daily',
            timesADay: 'Morning',
            responsible: '',
            date: '',
            status: 'Active'
        },
        searchQuery: '',
        sortOrder: 'asc',
        filters: {
            department: '',
            status: ''
        },
        currentPage: 1,
        itemsPerPage: 10,

        cleanings: [
            { department: 'Pediatrics Unit', room: 'Room 11', machineStatus: 'Yes', machine: 'EcoClean 600', product: "St. Michael's Surgical Center", type: 'Daily', timesADay: 'Morning', responsible: 'Jamie Lee', date: '26-11-25', status: 'Finished' },
            { department: 'Oncology Services', room: 'Room 22', machineStatus: 'No', machine: '-', product: 'Blue Horizon Surgical Institute', type: 'Weekly', timesADay: 'Evening', responsible: 'Casey Brown', date: '26-11-25', status: 'Finished' },
            { department: 'Oncology Services', room: 'Room 22', machineStatus: 'No', machine: '-', product: 'Blue Horizon Surgical Institute', type: 'Monthly', timesADay: 'Evening', responsible: 'Casey Brown', date: '26-11-25', status: 'Finished' },
            { department: 'Emergency Care Unit', room: 'Room 21', machineStatus: 'Yes', machine: 'HygieneMax 100', product: 'Bright Future Surgical Clinic', type: 'Daily', timesADay: 'Morning', responsible: 'Alex Kim', date: '26-11-25', status: 'Finished' },
            { department: 'Radiology Department', room: 'Room 11', machineStatus: 'Yes', machine: 'CareSync Pro', product: 'Willow Springs Surgical Hospital', type: 'Daily', timesADay: 'Evening', responsible: '-', date: '26-11-25', status: 'Active' },
            { department: 'Neurology Division', room: 'Room 10', machineStatus: 'No', machine: '-', product: 'Golden Valley Surgical Center', type: 'weekly', timesADay: 'Morning', responsible: '-', date: '26-11-25', status: 'Active' },
            { department: 'Orthopedic Surgery', room: 'Room 2', machineStatus: 'Yes', machine: 'SafeGuard 250', product: 'Cypress Hill Surgical Center', type: 'Daily', timesADay: 'Evening', responsible: 'Taylor Nguyen', date: '26-11-25', status: 'Finished' },
            { department: 'Gastroenterology Clinic', room: 'Room 13', machineStatus: 'Yes', machine: 'CleanMaster 400', product: 'Maple Grove Surgical Hospital', type: 'Monthly', timesADay: 'Morning & Evening', responsible: '-', date: '26-11-25', status: 'Active' },
            { department: 'Pulmonary Medicine', room: 'Room 23', machineStatus: 'Yes', machine: 'UltraSanitizer X', product: 'Crystal Springs Surgical Facility', type: 'Monthly', timesADay: 'Morning', responsible: '-', date: '26-11-25', status: 'Active' },
            { department: 'Cardiology Department', room: 'Room 15', machineStatus: 'Yes', machine: 'SaniPro 500', product: 'Riverside Medical Center', type: 'Daily', timesADay: 'Morning', responsible: 'Jordan Smith', date: '26-11-25', status: 'Finished' },
            { department: 'ICU Ward', room: 'Room 8', machineStatus: 'Yes', machine: 'ProClean 800', product: 'Sunrise Medical Facility', type: 'Daily', timesADay: 'Morning & Evening', responsible: 'Sarah Johnson', date: '27-11-25', status: 'Active' },
            { department: 'Surgery Department', room: 'Room 5', machineStatus: 'Yes', machine: 'MediClean 300', product: 'Horizon Health Center', type: 'Daily', timesADay: 'Morning', responsible: 'Michael Chen', date: '27-11-25', status: 'Finished' },
            { department: 'Maternity Ward', room: 'Room 18', machineStatus: 'No', machine: '-', product: 'Valley View Hospital', type: 'Weekly', timesADay: 'Evening', responsible: 'Emma Williams', date: '27-11-25', status: 'Active' },
            { department: 'Dermatology Clinic', room: 'Room 7', machineStatus: 'Yes', machine: 'SkinCare Pro', product: 'Coastal Medical Group', type: 'Monthly', timesADay: 'Morning', responsible: 'David Martinez', date: '28-11-25', status: 'Finished' },
            { department: 'Physiotherapy Center', room: 'Room 12', machineStatus: 'No', machine: '-', product: 'Mountain Peak Wellness', type: 'Weekly', timesADay: 'Evening', responsible: '-', date: '28-11-25', status: 'Active' }
        ],

        get filteredCleanings() {
            let list = this.cleanings;
            
            if (this.searchQuery.trim() !== '') {
                const query = this.searchQuery.toLowerCase();
                list = list.filter(item => 
                    item.department.toLowerCase().includes(query) || 
                    item.room.toLowerCase().includes(query) || 
                    item.product.toLowerCase().includes(query) ||
                    item.responsible.toLowerCase().includes(query)
                );
            }
            
            if (this.filters.department) {
                list = list.filter(item => 
                    item.department.toLowerCase().includes(this.filters.department.toLowerCase())
                );
            }
            
            if (this.filters.status) {
                list = list.filter(item => item.status === this.filters.status);
            }
            
            if (this.sortOrder === 'asc') {
                list = list.slice().sort((a, b) => a.department.localeCompare(b.department));
            } else {
                list = list.slice().sort((a, b) => b.department.localeCompare(a.department));
            }
            
            return list;
        },

        get totalPages() {
            return Math.ceil(this.filteredCleanings.length / this.itemsPerPage);
        },

        get startIndex() {
            return (this.currentPage - 1) * this.itemsPerPage;
        },

        get endIndex() {
            const end = this.startIndex + this.itemsPerPage;
            return end > this.filteredCleanings.length ? this.filteredCleanings.length : end;
        },

        get paginatedCleanings() {
            return this.filteredCleanings.slice(this.startIndex, this.endIndex);
        },

        get visiblePages() {
            const total = this.totalPages;
            const current = this.currentPage;
            const delta = 2;
            
            let range = [];
            let rangeWithDots = [];
            let l;

            for (let i = 1; i <= total; i++) {
                if (i == 1 || i == total || (i >= current - delta && i <= current + delta)) {
                    range.push(i);
                }
            }

            range.forEach((i) => {
                if (l) {
                    if (i - l === 2) {
                        rangeWithDots.push(l + 1);
                    } else if (i - l !== 1) {
                        rangeWithDots.push('...');
                    }
                }
                rangeWithDots.push(i);
                l = i;
            });

            return rangeWithDots;
        },

        applyFilters() {
            this.currentPage = 1;
            this.showFilterModal = false;
        },

        resetFilters() {
            this.filters = {
                department: '',
                status: ''
            };
            this.showFilterModal = false;
            this.currentPage = 1;
        },

        resetPagination() {
            this.currentPage = 1;
        },

        goToPage(page) {
            if (page !== '...' && page >= 1 && page <= this.totalPages) {
                this.currentPage = page;
            }
        },

        prevPage() {
            if (this.currentPage > 1) {
                this.currentPage--;
            }
        },

        nextPage() {
            if (this.currentPage < this.totalPages) {
                this.currentPage++;
            }
        },

        saveCleaning() {
            if (!this.cleaning.department || !this.cleaning.room) return;
            
            if (this.isEditing && this.editIndex !== null) {
                this.cleanings[this.editIndex] = {...this.cleaning};
            } else {
                this.cleanings.unshift({...this.cleaning});
            }
            this.resetModal();
        },

        openAddModal() {
            this.resetModal();
            this.showModal = true;
            this.isEditing = false;
        },

        openEditModal(index) {
            const item = this.paginatedCleanings[index];
            this.cleaning = {...item};
            this.editIndex = this.cleanings.indexOf(item);
            this.isEditing = true;
            this.showModal = true;
        },

        deleteCleaning(index) {
            if (confirm('Are you sure you want to delete this cleaning record?')) {
                const item = this.paginatedCleanings[index];
                const originalIndex = this.cleanings.indexOf(item);
                if (originalIndex > -1) this.cleanings.splice(originalIndex, 1);
            }
        },

        viewCleaning(index) {
            const item = this.paginatedCleanings[index];
            alert(`Viewing details for: ${item.department} - ${item.room}`);
        },

        resetModal() {
            this.cleaning = {
                department: '',
                room: '',
                machineStatus: 'Yes',
                machine: '',
                product: '',
                type: 'Daily',
                timesADay: 'Morning',
                responsible: '',
                date: '',
                status: 'Active'
            };
            this.editIndex = null;
            this.isEditing = false;
            this.showModal = false;
        },

        toggleSort() {
            this.sortOrder = this.sortOrder === 'asc' ? 'desc' : 'asc';
        },

        exportCSV() {
            alert('Exporting CSV file...');
        }
    }));
});
</script>

<style>
    [x-cloak] { display: none !important; }
    .modal { z-index: 1050; }
    
    /* Status Badges */
    .status-badge {
        display: inline-flex;
        align-items: center;
        gap: 6px;
        padding: 6px 12px;
        border-radius: 12px;
        font-size: 12px;
        font-weight: 500;
        border: 1px solid;
    }
    
    .status-finished {
        color: #166534;
        border-color: #86efac;
    }
    
    .status-active {
        color: #92400e;
        border-color: #fde047;
    }
    
    .status-dot {
        width: 6px;
        height: 6px;
        border-radius: 50%;
        display: inline-block;
    }
    
    .status-finished .status-dot {
        background-color: #16a34a;
    }
    
    .status-active .status-dot {
        background-color: #f59e0b;
    }
    
    /* Action Buttons */
    .action-btn {
        width: 32px;
        height: 32px;
        border-radius: 6px;
        border: 1px solid #dee2e6;
        background-color: #fff;
        display: inline-flex;
        align-items: center;
        justify-content:
        justify-content: center;
        cursor: pointer;
        transition: all 0.2s;
        font-size: 14px;
    }
    
    .action-view {
        background-color: #e0f2fe;
        border-color: #bae6fd;
        color: #0369a1;
    }
    
    .action-view:hover {
        background-color: #bae6fd;
        border-color: #7dd3fc;
    }
    
    .action-edit {
        background-color: #f0fbff;
        border-color: #cffafe;
        color: #0891b2;
    }
    
    .action-edit:hover {
        background-color: #cffafe;
        border-color: #a5f3fc;
    }
    
    .action-delete {
        background-color: #fee2e2;
        border-color: #fecaca;
        color: #dc2626;
    }
    
    .action-delete:hover {
        background-color: #fecaca;
        border-color: #fca5a5;
    }
    
    /* Pagination */
    .pagination-container {
        display: flex;
        align-items: center;
        gap: 5px;
    }
    
    .pagination-btn {
        width: 36px;
        height: 36px;
        border-radius: 8px;
        border: 1px solid #e0e0e0;
        background-color: #fff;
        display: flex;
        align-items: center;
        justify-content: center;
        font-weight: 500;
        color: #333;
        transition: all 0.2s;
        cursor: pointer;
    }
    
    .pagination-btn:hover:not(:disabled) {
        background-color: #f5f5f5;
    }
    
    .pagination-btn.active {
        background-color: #4598F9;
        color: white;
        border-color: #4598F9;
    }
    
    .pagination-btn:disabled {
        opacity: 0.5;
        cursor: not-allowed;
    }
    
    .pagination-btn.prev-btn, 
    .pagination-btn.next-btn {
        font-size: 14px;
    }
    
    /* Table Styling */
    .table thead th {
        font-size: 12px;
        font-weight: 600;
        color: #6b7280;
        text-transform: uppercase;
        letter-spacing: 0.05em;
        background-color: #f9fafb !important;
    }
    
    .table tbody tr {
        border-bottom: 1px solid #f3f4f6;
        transition: background-color 0.2s;
    }
    
    .table tbody tr:hover {
        background-color: #f9fafb;
    }
    
    .table tbody td {
        font-size: 14px;
        color: #374151;
        vertical-align: middle;
    }
    
    /* Form Controls */
    .form-control:focus,
    .form-select:focus {
        border-color: #4598F9;
        box-shadow: 0 0 0 0.2rem rgba(69, 152, 249, 0.25);
    }
    
    /* Modal Styling */
    .modal-content {
        box-shadow: 0 20px 25px -5px rgba(0, 0, 0, 0.1), 0 10px 10px -5px rgba(0, 0, 0, 0.04);
    }
    
    /* Search and Filter Buttons */
    .filter:hover,
    .sort:hover {
        background-color: #f9fafb !important;
        border-color: #d1d5db !important;
    }
</style>

@endsection    