<?php

use Illuminate\Foundation\Application;
use Illuminate\Foundation\Configuration\Exceptions;
use Illuminate\Foundation\Configuration\Middleware;

return Application::configure(basePath: dirname(__DIR__))
    ->withRouting(
        web: __DIR__.'/../routes/web.php',
        commands: __DIR__.'/../routes/console.php',
        health: '/up',
    )
    ->withMiddleware(function (Middleware $middleware): void {
        $middleware->alias([
            'admin.auth' => \App\Http\Middleware\CheckAdminAuth::class,
            'admin.guest' => \App\Http\Middleware\RedirectIfAuthenticated::class,
        ]);
    })
    ->withSchedule(function ($schedule): void {
        // Generate monthly invoices on the 15th of each month at 9:00 AM
        $schedule->command('invoices:generate-monthly')
            ->monthlyOn(15, '09:00')
            ->timezone('America/New_York');
    })
    ->withExceptions(function (Exceptions $exceptions): void {
        //
    })->create();
