<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class WasteBag extends Model
{
    protected $table = 'waste_bag';

    protected $fillable = [
        'clinic_id',
        'waste_type_id',
        'container_type_id',
        'department_id',
        'collector_id',
        'status',
        'created_by_id',
        'closed_by_id',
        'delivered_by_id',
        'created_timestamp',
        'closed_timestamp',
        'delivered_timestamp'
    ];

    // Disable default timestamps since we're using custom timestamp columns
    public $timestamps = false;

    /**
     * Get the clinic that owns the waste bag
     */
    public function clinic()
    {
        return $this->belongsTo(Clinic::class);
    }

    /**
     * Get the waste type
     */
    public function wasteType()
    {
        return $this->belongsTo(WasteType::class);
    }

    /**
     * Get the container type
     */
    public function containerType()
    {
        return $this->belongsTo(ContainerType::class);
    }

    /**
     * Get the department
     */
    public function department()
    {
        return $this->belongsTo(HospitalDepartment::class, 'department_id');
    }

    /**
     * Get the collector
     */
    public function collector()
    {
        return $this->belongsTo(Collector::class);
    }

    /**
     * Status constants
     */
    const STATUS_ACTIVE = 1;
    const STATUS_CLOSED = 2;
    const STATUS_DELIVERED = 3;

    /**
     * Get status label
     */
    public function getStatusLabelAttribute()
    {
        switch ($this->status) {
            case self::STATUS_ACTIVE:
                return 'Active';
            case self::STATUS_CLOSED:
                return 'Closed';
            case self::STATUS_DELIVERED:
                return 'Delivered';
            default:
                return 'Unknown';
        }
    }
}
