<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ResponsiblePerson extends Model
{
    protected $table = 'responsible_person';

    protected $fillable = [
        'clinic_id',
        'name',
        'username',
        'password',
        'role',
        'access_level',
    ];

    protected $hidden = [
        'password',
    ];

    protected $casts = [
        'access_level' => 'array',
    ];

    public $timestamps = true;

    /**
     * Get the clinic that owns the responsible person
     */
    public function clinic()
    {
        return $this->belongsTo(Clinic::class, 'clinic_id');
    }
}
