<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Invoice extends Model
{
    protected $fillable = [
        'clinic_id',
        'invoice_number',
        'invoice_date',
        'amount',
        'status',
        'pdf_path',
        'paid_date'
    ];

    protected $casts = [
        'invoice_date' => 'date',
        'paid_date' => 'date',
        'amount' => 'decimal:2'
    ];

    public function clinic()
    {
        return $this->belongsTo(Clinic::class);
    }
}
