<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class HospitalDepartment extends Model
{
    protected $table = 'hospital_department';

    protected $fillable = [
        'clinic_id',
        'name',
    ];

    public $timestamps = true;

    /**
     * Get the clinic that owns the department
     */
    public function clinic()
    {
        return $this->belongsTo(Clinic::class, 'clinic_id');
    }
}
