<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ContainerType extends Model
{
    protected $table = 'container_type';

    protected $fillable = [
        'clinic_id',
        'name',
    ];

    /**
     * Get the clinic that owns the container type
     */
    public function clinic()
    {
        return $this->belongsTo(Clinic::class);
    }
}
