<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Collector extends Model
{
    protected $table = 'collector';

    protected $fillable = [
        'clinic_id',
        'name',
        'location',
        'phone_number'
    ];

    /**
     * Get the clinic that owns the collector
     */
    public function clinic()
    {
        return $this->belongsTo(Clinic::class);
    }
}
