<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Clinic extends Model
{
    protected $table = 'clinic';

    protected $fillable = [
        'clinic_name',
        'clinic_location',
        'admin_name',
        'admin_username',
        'admin_password',
        'name',
        'location',
        'modul_access',
        'status',
    ];

    protected $hidden = [
        'admin_password',
    ];

    protected $casts = [
        'modul_access' => 'array',
    ];

    public $timestamps = true;

    /**
     * Get the departments for the clinic
     */
    public function departments()
    {
        return $this->hasMany(HospitalDepartment::class, 'clinic_id');
    }

    /**
     * Get the rooms for the clinic
     */
    public function rooms()
    {
        return $this->hasMany(Room::class, 'clinic_id');
    }

    /**
     * Get the responsible persons for the clinic
     */
    public function responsiblePersons()
    {
        return $this->hasMany(ResponsiblePerson::class, 'clinic_id');
    }

    /**
     * Get the invoices for the clinic
     */
    public function invoices()
    {
        return $this->hasMany(Invoice::class, 'clinic_id');
    }
}
