<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Hash;

class AdminUser extends Model
{
    protected $table = 'admin_user';

    protected $fillable = [
        'name',
        'username',
        'password',
        'role',
        'access_level',
    ];

    protected $casts = [
        'access_level' => 'array',
    ];

    protected $hidden = [
        'password',
    ];

    /**
     * Verify password for login
     */
    public function verifyPassword($password)
    {
        return Hash::check($password, $this->password);
    }
}
