<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
use Illuminate\Support\Facades\Session;

class CheckAdminAuth
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        // Check if admin is logged in
        if (!Session::has('is_logged_in') || !Session::get('is_logged_in')) {
            // Redirect to login if not authenticated
            return redirect()->route('sign-in')->with('error', 'Please login to access this page.');
        }

        return $next($request);
    }
}
