<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Barryvdh\DomPDF\Facade\Pdf;

class WasteSummaryController extends Controller
{
    private function getWasteData()
    {
        return [
            'clinic_name' => 'Riverside health Clinic',
            'location' => '246 Elm Drive, Brookside, WA 98001',
            'hospital_department' => 'Urologist Room',
            'waste_type' => 'Drip Bag',
            'created_by' => 'Jhon Wick',
            'closed_by' => 'Steve Harvey',
            'deliver_by' => 'Sam Wilson',
            'container_type' => 'Plastic',
            'collector_name' => 'Steve Job',
            'status' => 'Active',
            'created_time' => '12/02/2025 12:00 AM',
            'closed_time' => '12/02/2025 12:30 AM',
            'deliver_time' => '12/02/2025 12:30 AM',
        ];
    }

    public function index()
    {
        $data = $this->getWasteData();
        return view('summary', compact('data'));
    }

    public function viewPdf()
    {
        try {
            $data = $this->getWasteData();
            $pdf = Pdf::loadView('pdf.waste-summary', compact('data'));
            $pdf->setPaper('A4');
            
            return $pdf->stream('waste-summary.pdf');
        } catch (\Exception $e) {
            return back()->with('error', 'PDF generation failed: ' . $e->getMessage());
        }
    }

    public function exportPdf()
    {
        try {
            $data = $this->getWasteData();
            $pdf = Pdf::loadView('pdf.waste-summary', compact('data'));
            $pdf->setPaper('A4');
            
            return $pdf->download('waste-summary-' . date('Y-m-d-H-i-s') . '.pdf');
        } catch (\Exception $e) {
            return back()->with('error', 'PDF export failed: ' . $e->getMessage());
        }
    }
}